/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.renders;

import arc.Core;
import arc.Events;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.game.EventType;
import progressed.graphics.PMShaders;

public class DimRenderer {
    private static final int scaling = 4;
    private float[] vertices = new float[24];
    private FrameBuffer buffer = new FrameBuffer();
    private Seq<Runnable> lights = new Seq();
    private Seq<FadeCircle> circles = new Seq(FadeCircle.class);
    private int circleIndex = 0;
    private TextureRegion circleRegion;
    private float dimAlpha = 0.0f;

    public DimRenderer() {
        Events.on(EventType.ResetEvent.class, e -> {
            this.dimAlpha = 0.0f;
        });
    }

    public void updateAlpha(float dimAlpha) {
        this.dimAlpha = Mathf.clamp((float)Math.max(this.dimAlpha, dimAlpha));
    }

    public void add(Runnable run) {
        this.lights.add((Object)run);
    }

    public void add(float x, float y, float radius, float opacity) {
        if (this.circles.size <= this.circleIndex) {
            this.circles.add((Object)new FadeCircle());
        }
        FadeCircle light = ((FadeCircle[])this.circles.items)[this.circleIndex];
        light.set(x, y, radius, opacity);
        ++this.circleIndex;
    }

    public void add(float x, float y, TextureRegion region, float opacity) {
        this.add(x, y, region, 0.0f, opacity);
    }

    public void add(float x, float y, TextureRegion region, float rotation, float opacity) {
        float xscl = Draw.xscl;
        float yscl = Draw.yscl;
        this.add(() -> {
            Draw.alpha((float)opacity);
            Draw.scl((float)xscl, (float)yscl);
            Draw.rect((TextureRegion)region, (float)x, (float)y, (float)rotation);
            Draw.scl();
        });
    }

    public void line(float x, float y, float x2, float y2, float stroke, float alpha) {
        this.add(() -> {
            Draw.alpha((float)alpha);
            float rot = Mathf.angleExact((float)(x2 - x), (float)(y2 - y));
            TextureAtlas.AtlasRegion ledge = Core.atlas.find("circle-end");
            TextureAtlas.AtlasRegion lmid = Core.atlas.find("circle-mid");
            float color = Draw.getColor().toFloatBits();
            float u = lmid.u;
            float v = lmid.v2;
            float u2 = lmid.u2;
            float v2 = lmid.v;
            Vec2 v1 = Tmp.v1.trnsExact(rot + 90.0f, stroke);
            float lx1 = x - v1.x;
            float ly1 = y - v1.y;
            float lx2 = x + v1.x;
            float ly2 = y + v1.y;
            float lx3 = x2 + v1.x;
            float ly3 = y2 + v1.y;
            float lx4 = x2 - v1.x;
            float ly4 = y2 - v1.y;
            this.vertices[0] = lx1;
            this.vertices[1] = ly1;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx2;
            this.vertices[7] = ly2;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx3;
            this.vertices[13] = ly3;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx4;
            this.vertices[19] = ly4;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert((Texture)ledge.texture, (float[])this.vertices, (int)0, (int)this.vertices.length);
            Vec2 v3 = Tmp.v2.trnsExact(rot, stroke);
            u = ledge.u;
            v = ledge.v2;
            u2 = ledge.u2;
            v2 = ledge.v;
            this.vertices[0] = lx4;
            this.vertices[1] = ly4;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx3;
            this.vertices[7] = ly3;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx3 + v3.x;
            this.vertices[13] = ly3 + v3.y;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx4 + v3.x;
            this.vertices[19] = ly4 + v3.y;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert((Texture)ledge.texture, (float[])this.vertices, (int)0, (int)this.vertices.length);
            this.vertices[0] = lx2;
            this.vertices[1] = ly2;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = 0.0f;
            this.vertices[6] = lx1;
            this.vertices[7] = ly1;
            this.vertices[8] = color;
            this.vertices[9] = u;
            this.vertices[10] = v2;
            this.vertices[11] = 0.0f;
            this.vertices[12] = lx1 - v3.x;
            this.vertices[13] = ly1 - v3.y;
            this.vertices[14] = color;
            this.vertices[15] = u2;
            this.vertices[16] = v2;
            this.vertices[17] = 0.0f;
            this.vertices[18] = lx2 - v3.x;
            this.vertices[19] = ly2 - v3.y;
            this.vertices[20] = color;
            this.vertices[21] = u2;
            this.vertices[22] = v;
            this.vertices[23] = 0.0f;
            Draw.vert((Texture)ledge.texture, (float[])this.vertices, (int)0, (int)this.vertices.length);
        });
    }

    public void draw() {
        if (this.dimAlpha <= 0.001f) {
            this.lights.clear();
            this.circleIndex = 0;
            return;
        }
        if (this.circleRegion == null) {
            this.circleRegion = Core.atlas.find("circle-shadow");
        }
        this.buffer.resize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4);
        Draw.color();
        this.buffer.begin(Color.clear);
        Draw.sort((boolean)false);
        Gl.blendEquationSeparate((int)32774, (int)32776);
        Blending.normal.apply();
        for (Runnable run : this.lights) {
            run.run();
        }
        for (int i = 0; i < this.circleIndex; ++i) {
            FadeCircle cir = ((FadeCircle[])this.circles.items)[i];
            Draw.alpha((float)cir.alpha);
            Draw.rect((TextureRegion)this.circleRegion, (float)cir.x, (float)cir.y, (float)(cir.radius * 2.0f), (float)(cir.radius * 2.0f));
        }
        Draw.reset();
        Draw.sort((boolean)true);
        this.buffer.end();
        Gl.blendEquationSeparate((int)32774, (int)32774);
        Draw.color();
        PMShaders.dimShader.alpha = this.dimAlpha;
        this.buffer.blit((Shader)PMShaders.dimShader);
        this.lights.clear();
        this.circleIndex = 0;
        this.dimAlpha = 0.0f;
    }

    static class FadeCircle {
        float x;
        float y;
        float radius;
        float alpha;

        FadeCircle() {
        }

        public void set(float x, float y, float radius, float alpha) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.alpha = alpha;
        }
    }
}

