/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.renders;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.game.EventType;
import progressed.graphics.renders.DimRenderer;
import progressed.graphics.renders.SlashRenderer;

public class PMRenders {
    private static DimRenderer dimRenderer;
    private static float flashIntensity;
    private static float flashReduction;
    private static float flashTime;

    public static void init() {
        dimRenderer = new DimRenderer();
        SlashRenderer.init();
        Events.on(EventType.ResetEvent.class, e -> {
            flashTime = 0.0f;
            flashReduction = 0.0f;
        });
        Events.run((Object)EventType.Trigger.update, () -> flashIntensity -= flashReduction * Time.delta);
        Events.run((Object)EventType.Trigger.drawOver, () -> {
            Draw.draw((float)151.5f, () -> {
                dimRenderer.draw();
                if (flashIntensity > 0.001f) {
                    Draw.color((Color)Color.white, (float)flashIntensity);
                    Draw.rect();
                    Draw.color();
                }
            });
            SlashRenderer.draw();
        });
    }

    public static void flash(float intensity, float duration) {
        flashIntensity = intensity;
        flashTime = Math.max(flashTime, duration);
        flashReduction = flashIntensity / flashTime;
    }

    public static void flash(float duration) {
        PMRenders.flash(1.0f, duration);
    }

    public static void dimAlpha(float a) {
        dimRenderer.updateAlpha(a);
    }

    public static void dimGlow(float x, float y, float radius, float opacity) {
        dimRenderer.add(x, y, radius, opacity);
    }

    public static void dimGlow(Position pos, float radius, float opacity) {
        PMRenders.dimGlow(pos.getX(), pos.getY(), radius, opacity);
    }

    public static void dimGlow(float x, float y, TextureRegion region, float opacity) {
        PMRenders.dimGlow(x, y, region, 0.0f, opacity);
    }

    public static void dimGlow(float x, float y, TextureRegion region, float rotation, float opacity) {
        dimRenderer.add(x, y, region, rotation, opacity);
    }

    public static void dimGlowLine(float x, float y, float x2, float y2) {
        dimRenderer.line(x, y, x2, y2, 30.0f, 0.3f);
    }

    public static void dimGlowLine(float x, float y, float x2, float y2, float stroke, float alpha) {
        dimRenderer.line(x, y, x2, y2, stroke, alpha);
    }
}

