/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.trails;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.FloatSeq;
import arc.util.Time;
import mindustry.graphics.Trail;

public class PMTrail
extends Trail {
    private final FloatSeq points;
    private float lastX = -1.0f;
    private float lastY = -1.0f;
    private float counter = 0.0f;

    public PMTrail(int length) {
        super(length);
        this.points = new FloatSeq(length * 4);
    }

    public Trail copy() {
        return null;
    }

    public PMTrail copyPM() {
        PMTrail out = new PMTrail(this.length);
        out.points.addAll(this.points);
        out.lastX = this.lastX;
        out.lastY = this.lastY;
        return out;
    }

    public int size() {
        return this.points.size / 4;
    }

    public void drawCap(Color color, float width) {
        if (this.points.size > 0) {
            Draw.color((Color)color);
            float[] items = this.points.items;
            int i = this.points.size - 4;
            float x1 = items[i];
            float y1 = items[i + 1];
            float w1 = items[i + 2];
            float ai = items[i + 3];
            float w = w1 * width / (float)(this.points.size / 4) * (float)i / 4.0f * 2.0f;
            if (w1 <= 0.001f) {
                return;
            }
            Draw.rect((String)"hcircle", (float)x1, (float)y1, (float)w, (float)w, (float)(-57.295776f * ai + 180.0f));
            Draw.reset();
        }
    }

    public void draw(Color color, float width) {
        Draw.color((Color)color);
        float[] items = this.points.items;
        for (int i = 0; i < this.points.size - 4; i += 4) {
            float x1 = items[i];
            float y1 = items[i + 1];
            float w1 = items[i + 2];
            float a1 = items[i + 3];
            float x2 = items[i + 4];
            float y2 = items[i + 5];
            float w2 = items[i + 6];
            float a2 = items[i + 7];
            float size = width / (float)(this.points.size / 4);
            if (w1 <= 0.001f || w2 <= 0.001f) continue;
            float cx = Mathf.sin((float)a1) * (float)i / 4.0f * size * w1;
            float cy = Mathf.cos((float)a1) * (float)i / 4.0f * size * w1;
            float nx = Mathf.sin((float)a2) * ((float)i / 4.0f + 1.0f) * size * w2;
            float ny = Mathf.cos((float)a2) * ((float)i / 4.0f + 1.0f) * size * w2;
            Fill.quad((float)(x1 - cx), (float)(y1 - cy), (float)(x1 + cx), (float)(y1 + cy), (float)(x2 + nx), (float)(y2 + ny), (float)(x2 - nx), (float)(y2 - ny));
        }
        Draw.reset();
    }

    public void shorten() {
        float f;
        this.counter += Time.delta;
        if (f >= 0.99f) {
            if (this.points.size >= 4) {
                this.points.removeRange(0, 3);
            }
            this.counter = 0.0f;
        }
    }

    public void update(float x, float y) {
        this.updateRot(x, y, Angles.angle((float)x, (float)y, (float)this.lastX, (float)this.lastY));
    }

    public void update(float x, float y, float width) {
        this.update(x, y, width, Angles.angle((float)x, (float)y, (float)this.lastX, (float)this.lastY));
    }

    public void updateRot(float x, float y, float rotation) {
        this.update(x, y, 1.0f, rotation);
    }

    public void update(float x, float y, float width, float rotation) {
        float f;
        this.counter += Time.delta;
        if (f >= 0.99f) {
            if (this.points.size > this.length * 4) {
                this.points.removeRange(0, 3);
            }
            this.points.add(x, y, width, -rotation * ((float)Math.PI / 180));
            this.counter = 0.0f;
            this.lastX = x;
            this.lastY = y;
        }
    }
}

