/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.trails;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.graphics.Trail;
import progressed.graphics.draw3d.Perspective;

public class ZTrail
extends Trail {
    protected float lastZ = 0.0f;

    public ZTrail(int length) {
        super(length);
        this.points = new FloatSeq(length * 4);
    }

    public Trail copy() {
        ZTrail out = new ZTrail(this.length);
        out.points.addAll(this.points);
        out.lastX = this.lastX;
        out.lastY = this.lastY;
        out.lastW = this.lastW;
        out.lastZ = this.lastZ;
        return out;
    }

    public float width() {
        return this.lastW;
    }

    public void clear() {
        this.points.clear();
    }

    public int size() {
        return this.points.size / 4;
    }

    public void drawCap(Color color, float width, boolean fade) {
        if (this.points.size > 4) {
            float[] items = this.points.items;
            int i = this.points.size - 4;
            float z1 = items[i - 4 + 3];
            Vec2 pos1 = Perspective.drawPos(items[i - 4], items[i - 4 + 1], z1);
            float x1 = pos1.x;
            float y1 = pos1.y;
            Vec2 pos2 = Perspective.drawPos(this.lastX, this.lastY, this.lastZ);
            float x2 = pos2.x;
            float y2 = pos2.y;
            float w1 = Perspective.scale(this.lastX, this.lastY, this.lastZ);
            float w = w1 * width / (float)(this.points.size / 4) * (float)i / 4.0f * 2.0f;
            if (w1 <= 0.001f) {
                return;
            }
            if (fade) {
                Draw.color((Color)Tmp.c1.set(color).mulA(Perspective.alpha(this.lastX, this.lastY, this.lastZ)));
            } else {
                Draw.color((Color)color);
            }
            Draw.rect((String)"hcircle", (float)x2, (float)y2, (float)w, (float)w, (float)Angles.angle((float)x1, (float)y1, (float)x2, (float)y2));
            Draw.color();
        }
    }

    public void drawCap(Color color, float width) {
        this.drawCap(color, width, true);
    }

    public void draw(Color color, float width, boolean fade) {
        float lastAngle = 0.0f;
        float[] items = this.points.items;
        float size = width / (float)(this.points.size / 4);
        float vz = Perspective.viewportZ();
        boolean calcLast = true;
        for (int i = 0; i < this.points.size; i += 4) {
            float a1;
            float py2;
            float px2;
            float z2;
            float px1 = items[i];
            float py1 = items[i + 1];
            float z1 = items[i + 3];
            float f = z2 = i < this.points.size - 4 ? items[i + 4 + 3] : this.lastZ;
            if (z1 > vz && z2 > vz) {
                calcLast = true;
                continue;
            }
            if (z1 > vz) {
                Vec3 pos = Perspective.scaleToViewport(px1, py1, z1);
                px1 = pos.x;
                py1 = pos.y;
                z1 = pos.z;
            }
            Vec2 pos1 = Perspective.drawPos(px1, py1, z1);
            float x1 = pos1.x;
            float y1 = pos1.y;
            float w1 = Perspective.scale(items[i], items[i + 1], z1);
            if (i < this.points.size - 4) {
                px2 = items[i + 4];
                py2 = items[i + 4 + 1];
            } else {
                px2 = this.lastX;
                py2 = this.lastY;
            }
            if (z2 > vz) {
                Vec3 pos = Perspective.scaleToViewport(px2, py2, z2);
                px2 = pos.x;
                py2 = pos.y;
                z2 = pos.z;
            }
            Vec2 pos2 = Perspective.drawPos(px2, py2, z2);
            float x2 = pos2.x;
            float y2 = pos2.y;
            float w2 = Perspective.scale(px2, py2, z2);
            float a2 = -Angles.angleRad((float)x1, (float)y1, (float)x2, (float)y2);
            float f2 = a1 = calcLast ? a2 : lastAngle;
            if (w1 <= 0.001f || w2 <= 0.001f) continue;
            float cx = Mathf.sin((float)a1) * (float)i / 4.0f * size * w1;
            float cy = Mathf.cos((float)a1) * (float)i / 4.0f * size * w1;
            float nx = Mathf.sin((float)a2) * ((float)i / 4.0f + 1.0f) * size * w2;
            float ny = Mathf.cos((float)a2) * ((float)i / 4.0f + 1.0f) * size * w2;
            Tmp.c1.set(color);
            float c1 = Tmp.c1.toFloatBits();
            float c2 = Tmp.c1.toFloatBits();
            if (fade) {
                c1 = Tmp.c1.set(color).mulA(Perspective.alpha(px1, py1, z1)).toFloatBits();
                c2 = Tmp.c1.set(color).mulA(Perspective.alpha(px2, py2, z2)).toFloatBits();
            }
            Fill.quad((float)(x1 - cx), (float)(y1 - cy), (float)c1, (float)(x1 + cx), (float)(y1 + cy), (float)c1, (float)(x2 + nx), (float)(y2 + ny), (float)c2, (float)(x2 - nx), (float)(y2 - ny), (float)c2);
            lastAngle = a2;
            calcLast = false;
        }
        Draw.color();
    }

    public void draw(Color color, float width) {
        this.draw(color, width, true);
    }

    public void shorten() {
        float f;
        this.counter += Time.delta;
        if (f >= 1.0f) {
            if (this.points.size >= 4) {
                this.points.removeRange(0, 3);
            }
            this.counter %= 1.0f;
        }
    }

    public void update(float x, float y, float width) {
        this.update(x, y, width, 0.0f);
    }

    public void update(float x, float y, float width, float height) {
        float f;
        this.counter += Time.delta;
        if (f >= 1.0f) {
            if (this.points.size > this.length * 4) {
                this.points.removeRange(0, 3);
            }
            this.points.add(x, y, width, height);
            this.counter %= 1.0f;
        }
        this.lastX = x;
        this.lastY = y;
        this.lastW = width;
        this.lastZ = height;
    }
}

