/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.unit;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.gen.Unit;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import progressed.ai.SwordAI;
import progressed.gen.entities.SwordUnitc;
import progressed.graphics.PMPal;
import progressed.graphics.trails.DriftTrail;

public class SwordUnitType
extends UnitType {
    public float orbitRadius = -1.0f;
    public float orbitSpeed = 1.0f;
    public float attackRadius = 80.0f;
    public float attackTimeOffset = 20.0f;
    public float neutralSpeed = 2.0f;
    public float travelSpeed = -1.0f;
    public float curveRnd = -1.0f;
    public float baseY;
    public float tipY;
    public float damage = 1.0f;
    public Effect hitEffect = Fx.none;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 600.0f;
    public float heatupTime = 30.0f;
    public float cooldownTime = 60.0f;
    public Color heatColor = Color.red;
    public TextureRegion heatRegion;
    public float trailVel = 5.0f;
    public float trailInheritVel = 0.5f;
    public float trailAngle = 150.0f;
    public float trailY = Float.NEGATIVE_INFINITY;

    public SwordUnitType(String name) {
        super(name);
        this.aiController = SwordAI::new;
        this.isEnemy = false;
        this.playerControllable = false;
        this.logicControllable = false;
        this.allowedInPayloads = false;
        this.envDisabled = 0;
        this.payloadCapacity = 0.0f;
        this.useUnitCap = false;
        this.physics = false;
        this.targetable = false;
        this.hittable = false;
        this.flying = true;
        this.engineSize = -1.0f;
        this.hidden = true;
        this.drawCell = false;
        this.engineLayer = 110.0f;
        this.outlineColor = PMPal.outline;
        this.speed = 8.0f;
        this.rotateSpeed = 3.0f;
        this.accel = 0.05f;
        this.drag = 0.03f;
        this.trailColor = Color.red.cpy().a(0.25f);
        this.trailLength = 5;
        this.trailScl = 2.0f;
    }

    public void display(Unit unit, Table table) {
        table.table(t -> {
            t.left();
            t.add((Element)new Image(this.uiIcon)).size(32.0f).scaling(Scaling.fit);
            t.labelWrap(this.localizedName).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
    }

    public void init() {
        super.init();
        if (this.travelSpeed <= 0.0f) {
            this.travelSpeed = this.speed / 2.0f;
        }
        if (this.trailY == Float.NEGATIVE_INFINITY) {
            this.trailY = this.tipY - this.trailScl;
        }
        if (this.curveRnd < 0.0f) {
            this.curveRnd = this.rotateSpeed * 2.0f;
        }
    }

    public void load() {
        super.load();
        this.heatRegion = Core.atlas.find(this.name + "-heat");
    }

    public void drawBody(Unit unit) {
        SwordUnitc sunit;
        super.drawBody(unit);
        if (this.heatRegion.found() && unit instanceof SwordUnitc && (sunit = (SwordUnitc)unit).heat() > 0.01f) {
            Draw.color((Color)this.heatColor, (float)(this.heatColor.a * sunit.heat()));
            Draw.rect((TextureRegion)this.heatRegion, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
            Draw.color();
        }
    }

    public void drawTrail(Unit unit) {
        if (!(unit instanceof SwordUnitc)) {
            return;
        }
        SwordUnitc sword = (SwordUnitc)unit;
        if (this.trailLength > 0) {
            if (sword.driftTrails() == null) {
                sword.driftTrails(new DriftTrail[]{new DriftTrail(this.trailLength), new DriftTrail(this.trailLength)});
            }
            for (DriftTrail trail : sword.driftTrails()) {
                trail.draw(this.trailColor == null ? unit.team.color : this.trailColor, this.trailScl);
            }
        }
    }

    public void drawSoftShadow(float x, float y, float rotation, float alpha) {
    }
}

