/*
 * Decompiled with CFR 0.152.
 */
package progressed.ui;

import arc.Core;
import arc.Events;
import arc.func.Boolp;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.ui.fragments.HintsFragment;
import mindustry.world.Block;
import progressed.ProgMats;
import progressed.content.blocks.PMBlocks;
import progressed.content.blocks.PMErekirBlocks;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.blocks.production.UnitMinerDepot;

public class PMHints {
    ObjectSet<String> events = new ObjectSet();
    ObjectSet<Block> placedBlocks = new ObjectSet();

    public void load() {
        Seq hints = Vars.ui.hints.hints;
        hints.add((Object[])PMHint.values()).as();
        hints.removeAll(h -> !h.valid() || h.finished() || h.show() && h.complete());
        hints.sort(HintsFragment.Hint::order);
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking && event.unit == Vars.player.unit()) {
                this.placedBlocks.add((Object)event.tile.block());
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.placedBlocks.clear();
            this.events.clear();
        });
        Events.on(EventType.BuildingCommandEvent.class, e -> {
            if (e.building instanceof UnitMinerDepot.UnitMinerDepotBuild) {
                this.events.add((Object)"minercontrol");
            }
            if (e.building instanceof ModularTurret.ModularTurretBuild) {
                this.events.add((Object)"modularturret");
            }
        });
    }

    public static enum PMHint implements HintsFragment.Hint
    {
        minerControl(() -> Vars.state.rules.defaultTeam.data().getCount(PMBlocks.unitMinerDepot) > 0, () -> ProgMats.hints.events.contains((Object)"factorycontrol")),
        modularTurret(() -> Vars.state.rules.defaultTeam.data().getCount(PMErekirBlocks.matrix) > 0, () -> ProgMats.hints.events.contains((Object)"modularturret"));

        String text;
        int visibility = 3;
        HintsFragment.Hint[] dependencies = new HintsFragment.Hint[0];
        boolean finished;
        boolean cached;
        Boolp complete;
        Boolp shown = () -> true;

        private PMHint(Boolp complete) {
            this.complete = complete;
        }

        private PMHint(int visiblity, Boolp complete) {
            this(complete);
            this.visibility = visiblity;
        }

        private PMHint(Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
        }

        private PMHint(int visiblity, Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
            this.visibility = visiblity;
        }

        public boolean finished() {
            if (!this.cached) {
                this.cached = true;
                this.finished = Core.settings.getBool("pm-" + this.name() + "-hint-done", false);
            }
            return this.finished;
        }

        public void finish() {
            this.finished = true;
            Core.settings.put("pm-" + this.name() + "-hint-done", (Object)true);
        }

        public String text() {
            if (this.text == null) {
                String string = this.text = Vars.mobile && Core.bundle.has("hint.pm-" + this.name() + ".mobile") ? Core.bundle.get("hint.pm-" + this.name() + ".mobile") : Core.bundle.get("hint.pm-" + this.name());
                if (!Vars.mobile) {
                    this.text = this.text.replace("tap", "click").replace("Tap", "Click");
                }
            }
            return this.text;
        }

        public boolean complete() {
            return this.complete.get();
        }

        public boolean show() {
            return this.shown.get() && (this.dependencies.length == 0 || !Structs.contains((Object[])this.dependencies, d -> !d.finished()));
        }

        public int order() {
            return this.ordinal();
        }

        public boolean valid() {
            return Vars.mobile && (this.visibility & 2) != 0 || !Vars.mobile && (this.visibility & 1) != 0;
        }
    }
}

