/*
 * Decompiled with CFR 0.152.
 */
package progressed.ui.dialogs;

import arc.Core;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Cell;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import progressed.ui.PMStyles;
import progressed.ui.ShiftedStack;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.module.ModuleModule;

public class ModuleSwapDialog
extends BaseDialog {
    public short selFirst = (short)-1;
    public ModuleModule.ModuleSize selSize;
    protected short[][] swaps = new short[ModuleModule.ModuleSize.values().length][];
    protected ModularTurret.ModularTurretBuild base;

    public ModuleSwapDialog() {
        super("@pm-swap.title");
        this.buttons.defaults().size(210.0f, 64.0f);
        this.buttons.button("@cancel", (Drawable)Icon.cancel, () -> ((ModuleSwapDialog)this).hide());
        this.buttons.button("@confirm", (Drawable)Icon.flipX, () -> {
            this.hide();
            for (ModuleModule.ModuleSize size : ModuleModule.ModuleSize.values()) {
                short[] swapSize = this.swaps[size.ordinal()];
                for (short i = 0; i < swapSize.length; i = (short)((short)(i + 1))) {
                    TurretModule mount;
                    short ii = i;
                    if (swapSize[i] == i || (mount = (TurretModule)this.base.modules.find(m -> m.checkSize(size) && m.checkLastNumber(ii))) == null) continue;
                    this.base.configure(Point2.pack((int)this.base.modules.indexOf((Object)mount), (int)swapSize[i]));
                }
            }
            this.base.configure(true);
        });
        this.shown(this::rebuild);
    }

    public Dialog show(ModularTurret.ModularTurretBuild base) {
        this.base = base;
        for (ModuleModule.ModuleSize size : ModuleModule.ModuleSize.values()) {
            int s = size.ordinal();
            int amount = base.getMountCapacity(size);
            this.swaps[s] = new short[amount];
            for (int i = 0; i < amount; i = (int)((short)(i + 1))) {
                this.swaps[s][i] = i;
            }
        }
        return this.show();
    }

    public void rebuild() {
        this.cont.clear();
        this.selSize = ModuleModule.ModuleSize.small;
        this.deselect();
        for (ModuleModule.ModuleSize mSize : ModuleModule.ModuleSize.values()) {
            if (this.base.getMountPos(mSize) == null) continue;
            this.cont.label(mSize::fullTitle).top().right();
            this.cont.table(b -> {
                int c = 0;
                for (short i = 0; i < this.base.getMaxMounts(mSize); i = (short)(i + 1)) {
                    short ii = i;
                    Cell button = b.button(Tex.clear, PMStyles.squareTogglei, 48.0f, () -> {
                        if (this.selSize != mSize) {
                            this.deselect();
                        }
                        this.selSize = mSize;
                        if (this.selFirst != ii) {
                            this.select(ii);
                        } else {
                            this.deselect();
                        }
                    }).update(ib -> ib.setChecked(this.selSize == mSize && this.selFirst == ii)).size(64.0f).left();
                    ShiftedStack pos = new ShiftedStack();
                    Vec2 p = this.base.getMountPos(mSize)[i];
                    pos.setStackPos(p.x * 4.0f, p.y * 4.0f);
                    pos.add((Element)new Image(this.base.block.fullIcon));
                    short mNum = this.swaps[mSize.ordinal()][i];
                    TurretModule mount = (TurretModule)this.base.modules.find(m -> m.checkSize(mSize) && m.checkNumber(mNum));
                    String num = " (" + (mNum + 1) + ")";
                    if (mount != null) {
                        pos.add((Element)new Image(mount.block().fullIcon));
                        ((ImageButton)button.get()).getStyle().imageUp = new TextureRegionDrawable(mount.icon());
                        button.tooltip(t -> {
                            t.background(Styles.black6).margin(4.0f);
                            t.label(() -> mount.name() + num);
                            t.row();
                            t.add((Element)pos);
                        });
                    } else {
                        Image m2 = new Image(((ModularTurret)this.base.block).mountBases[mSize.ordinal()]);
                        m2.setColor(((ModularTurret)this.base.block).mountColor);
                        pos.add((Element)m2);
                        ((ImageButton)button.get()).clearChildren();
                        ((ImageButton)button.get()).label(() -> String.valueOf(mNum + 1));
                        button.tooltip(t -> {
                            t.background(Styles.black6).margin(4.0f);
                            t.label(() -> Core.bundle.get("empty") + num);
                            t.row();
                            t.add((Element)pos);
                        });
                    }
                    if (c++ % 4 != 3) continue;
                    b.row();
                }
            }).left().padLeft(16.0f);
            this.cont.row();
        }
    }

    private void select(short sel) {
        if (this.selFirst < 0) {
            this.selFirst = sel;
        } else {
            short[] swapSize = this.swaps[this.selSize.ordinal()];
            short s1 = swapSize[this.selFirst];
            short s2 = swapSize[sel];
            swapSize[sel] = s1;
            swapSize[this.selFirst] = s2;
            this.rebuild();
        }
    }

    private void deselect() {
        this.selFirst = (short)-1;
    }
}

