/*
 * Decompiled with CFR 0.152.
 */
package progressed.util;

import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.UI;
import mindustry.gen.Building;
import mindustry.mod.Mods;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Tile;

public class PMUtls {
    public static final Rand rand = new Rand();
    static final Seq<ItemStack> rawStacks = new Seq();
    static final Seq<Item> items = new Seq();
    static final IntSeq amounts = new IntSeq();

    public static String stringsFixed(float value) {
        return Strings.autoFixed((float)value, (int)2);
    }

    public static ItemStack[] researchRequirements(ItemStack[] requirements, float mul) {
        ItemStack[] out = new ItemStack[requirements.length];
        for (int i = 0; i < out.length; ++i) {
            int quantity = 60 + Mathf.round((float)(Mathf.pow((float)requirements[i].amount, (float)1.1f) * 20.0f * mul), (int)10);
            out[i] = new ItemStack(requirements[i].item, UI.roundAmount((int)quantity));
        }
        return out;
    }

    public static ItemStack[] addItemStacks(Seq<ItemStack[]> stacks) {
        rawStacks.clear();
        items.clear();
        amounts.clear();
        stacks.each(s -> {
            for (ItemStack stack : s) {
                rawStacks.add((Object)stack);
            }
        });
        rawStacks.sort(s -> s.item.id);
        rawStacks.each(s -> {
            if (!items.contains((Object)s.item)) {
                items.add((Object)s.item);
                amounts.add(s.amount);
            } else {
                amounts.incr(items.indexOf((Object)s.item), s.amount);
            }
        });
        ItemStack[] result = new ItemStack[PMUtls.items.size];
        for (int i = 0; i < PMUtls.items.size; ++i) {
            result[i] = new ItemStack((Item)items.get(i), amounts.get(i));
        }
        return result;
    }

    public static int relativeDirection(Building from, Building to) {
        if (from == null || to == null) {
            return -1;
        }
        if (from.x == to.x && from.y > to.y) {
            return (7 - from.rotation) % 4;
        }
        if (from.x == to.x && from.y < to.y) {
            return (5 - from.rotation) % 4;
        }
        if (from.x > to.x && from.y == to.y) {
            return (6 - from.rotation) % 4;
        }
        if (from.x < to.x && from.y == to.y) {
            return (4 - from.rotation) % 4;
        }
        return -1;
    }

    public static Item oreDrop(Tile tile) {
        if (tile == null) {
            return null;
        }
        if (tile.block() != Blocks.air) {
            return tile.wallDrop();
        }
        return tile.drop();
    }

    public static String round(float f) {
        if (f >= 1.0E9f) {
            return Strings.autoFixed((float)(f / 1.0E9f), (int)1) + UI.billions;
        }
        if (f >= 1000000.0f) {
            return Strings.autoFixed((float)(f / 1000000.0f), (int)1) + UI.millions;
        }
        if (f >= 1000.0f) {
            return Strings.autoFixed((float)(f / 1000.0f), (int)1) + UI.thousands;
        }
        return Strings.autoFixed((float)f, (int)2);
    }

    public static boolean modEnabled(String name) {
        Mods.LoadedMod mod = Vars.mods.getMod(name);
        return mod != null && mod.isSupported() && mod.enabled();
    }

    public static void uhOhSpeghettiOh(String ohno) {
        throw new RuntimeException(ohno);
    }
}

