/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence;

import arc.Core;
import arc.func.Boolp;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.gen.entities.SwordUnitc;
import progressed.graphics.draw3d.Fill3D;

public class EffectZone
extends Block {
    public final int timerSearch;
    public float searchInterval;
    protected static final Seq<Unit> all = new Seq();
    public float reload;
    public float range;
    public boolean affectEnemyTeam;
    public boolean affectOwnTeam;
    public Color baseColor;
    public Color topColor;
    public float height;
    public float zoneLayer;
    public float ringLayer;
    public Cons<EffectZoneBuild> zoneEffect;
    public Boolp activate;
    public TextureRegion topRegion;

    public EffectZone(String name) {
        super(name);
        this.timerSearch = this.timers++;
        this.searchInterval = 20.0f;
        this.reload = 20.0f;
        this.range = 80.0f;
        this.affectOwnTeam = true;
        this.baseColor = Pal.lancerLaser;
        this.height = 64.0f;
        this.zoneLayer = -1.0f;
        this.ringLayer = 115.5f;
        this.zoneEffect = tile -> {};
        this.activate = () -> all.any();
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.canOverdrive = false;
        this.emitLight = true;
        this.lightRadius = -1.0f;
        this.envEnabled |= 2;
    }

    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
    }

    public void init() {
        if (this.lightRadius < 0.0f) {
            this.lightRadius = this.range * 2.0f;
        }
        super.init();
        if (this.topColor == null) {
            this.topColor = this.baseColor.cpy().a(0.0f);
        }
        if (this.zoneLayer < 0.0f) {
            this.zoneLayer = this.ringLayer - 0.1f;
        }
        this.clipSize = Math.max(this.clipSize, (this.range + 4.0f) * 2.0f);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)this.baseColor);
    }

    public class EffectZoneBuild
    extends Building {
        public float heat;
        public float activeHeat;
        public float activeHeight;
        public float charge;
        public float smoothEfficiency;
        public boolean active;

        public EffectZoneBuild() {
            this.charge = Mathf.random((float)EffectZone.this.reload);
        }

        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.08f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)Mathf.num((boolean)this.canConsume()), (float)0.08f);
            this.activeHeat = Mathf.lerpDelta((float)this.activeHeat, (float)Mathf.num((this.canConsume() && this.active ? 1 : 0) != 0), (float)0.08f);
            this.activeHeight = Mathf.lerpDelta((float)this.activeHeight, (float)((float)Mathf.num((this.canConsume() && this.active ? 1 : 0) != 0) * this.smoothEfficiency), (float)0.08f);
            this.charge += this.heat * Time.delta * this.smoothEfficiency;
            if (this.timer(EffectZone.this.timerSearch, EffectZone.this.searchInterval)) {
                this.findUnits();
                this.active = EffectZone.this.activate.get();
            }
            if (this.charge >= EffectZone.this.reload) {
                this.charge = 0.0f;
                this.findUnits();
                EffectZone.this.zoneEffect.get((Object)this);
            }
        }

        protected void findUnits() {
            all.clear();
            Units.nearby((Team)(EffectZone.this.affectEnemyTeam ? null : this.team), (float)this.x, (float)this.y, (float)EffectZone.this.range, other -> {
                if (!other.dead && !(other instanceof SwordUnitc) && (EffectZone.this.affectOwnTeam && other.team == this.team || EffectZone.this.affectEnemyTeam && this.team != other.team)) {
                    all.add(other);
                }
            });
        }

        public boolean shouldConsume() {
            return this.active;
        }

        public void draw() {
            float a;
            super.draw();
            float scl = Mathf.absin((float)Time.time, (float)7.957747f, (float)0.125f);
            float opacity = (float)Core.settings.getInt("pm-zone-opacity", 100) / 100.0f;
            Draw.color((Color)EffectZone.this.baseColor);
            Draw.alpha((float)(this.heat * scl * 0.5f));
            Draw.rect((TextureRegion)EffectZone.this.topRegion, (float)this.x, (float)this.y);
            Draw.color();
            Draw.alpha((float)1.0f);
            if (this.activeHeat > 0.01f) {
                Draw.z((float)EffectZone.this.zoneLayer);
                a = this.activeHeat * this.smoothEfficiency * opacity;
                Tmp.c1.set(EffectZone.this.baseColor).mulA(scl * a);
                Tmp.c2.set(EffectZone.this.baseColor).mulA((0.25f + scl) * a);
                Fill.light((float)this.x, (float)this.y, (int)Lines.circleVertices((float)EffectZone.this.range), (float)EffectZone.this.range, (Color)Tmp.c1, (Color)Tmp.c2);
            }
            if (this.smoothEfficiency > 0.01f) {
                Draw.z((float)EffectZone.this.ringLayer);
                a = this.smoothEfficiency * opacity;
                Tmp.c1.set(EffectZone.this.baseColor).mulA(a);
                Tmp.c2.set(EffectZone.this.topColor).mulA(a);
                Lines.stroke((float)1.0f, (Color)Tmp.c1);
                Lines.circle((float)this.x, (float)this.y, (float)EffectZone.this.range);
                Fill3D.tube(this.x, this.y, EffectZone.this.range, this.realHeight(), Tmp.c1, Tmp.c2);
            }
            Draw.color();
            Draw.alpha((float)1.0f);
        }

        public float realHeight() {
            return EffectZone.this.height * this.activeHeight;
        }

        public void drawLight() {
            super.drawLight();
            if (this.activeHeat < 0.01f) {
                return;
            }
            Drawf.light((float)this.x, (float)this.y, (float)EffectZone.this.lightRadius, (Color)EffectZone.this.baseColor, (float)(0.8f * this.activeHeat * this.smoothEfficiency));
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.charge);
            write.f(this.heat);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.charge = read.f();
            this.heat = read.f();
        }
    }
}

