/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BuildVisibility;
import progressed.content.effects.OtherFx;

public class IgneousPillar
extends Block {
    public float growTime = 10.0f;
    public float minDelay = 60.0f;
    public float maxDelay = 90.0f;
    public float damage = 70.0f;
    public float radius = 24.0f;
    public boolean damageAll;
    public boolean damageGround = true;
    public boolean damageAir;
    public StatusEffect status = StatusEffects.burning;
    public float statusDuration = 600.0f;
    public int glowVariants = 1;
    public int[] glowWeights;
    public TextureRegion[] glowRegions;
    public Color glowColorFrom = Pal.darkerGray;
    public Color glowColorTo = Pal.lightPyraFlame;
    Seq<TextureRegion> weightedGlowRegions = new Seq();

    public IgneousPillar(String name) {
        super(name);
        this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.empty);
        this.update = true;
        this.solid = true;
        this.targetable = false;
        this.rebuildable = false;
        this.alwaysReplace = false;
        this.breakable = false;
        this.destructible = false;
        this.destroyEffect = OtherFx.pillarBlast;
    }

    public boolean synthetic() {
        return false;
    }

    public boolean canBeBuilt() {
        return false;
    }

    public boolean canBreak(Tile tile) {
        return false;
    }

    public void load() {
        int i;
        super.load();
        this.glowRegions = new TextureRegion[this.glowVariants];
        for (i = 0; i < this.glowVariants; ++i) {
            this.glowRegions[i] = Core.atlas.find(this.name + "-glow-" + i);
        }
        if (this.glowWeights != null) {
            this.weightedGlowRegions.clear();
            for (i = 0; i < this.glowRegions.length; ++i) {
                for (int j = 0; j < this.glowWeights[i]; ++j) {
                    this.weightedGlowRegions.add((Object)this.glowRegions[i]);
                }
            }
        }
    }

    public class IgneousPillarBuild
    extends Building {
        public TextureRegion glowRegion;
        public float delay;
        public float growTimer;
        public float boomTimer;

        public void created() {
            super.created();
            this.delay = Mathf.random((float)IgneousPillar.this.minDelay, (float)IgneousPillar.this.maxDelay);
            int seed = this.id + this.pos();
            this.glowRegion = IgneousPillar.this.glowWeights != null ? (TextureRegion)IgneousPillar.this.weightedGlowRegions.get(Mathf.randomSeed((long)seed, (int)0, (int)(IgneousPillar.this.weightedGlowRegions.size - 1))) : IgneousPillar.this.glowRegions[Mathf.randomSeed((long)seed, (int)0, (int)(IgneousPillar.this.glowRegions.length - 1))];
        }

        public void draw() {
            Draw.alpha((float)this.growf());
            super.draw();
            Draw.color((Color)IgneousPillar.this.glowColorFrom, (Color)IgneousPillar.this.glowColorTo, (float)this.timerf());
            Draw.rect((TextureRegion)this.glowRegion, (float)this.x, (float)this.y, (float)(this.block.rotate ? this.rotdeg() : 0.0f));
            Draw.reset();
        }

        public void updateTile() {
            super.updateTile();
            this.growTimer += Time.delta;
            if (this.growTimer >= IgneousPillar.this.growTime) {
                this.boomTimer += Time.delta;
                if (this.boomTimer >= this.delay) {
                    this.kill();
                }
            }
        }

        public void onDestroyed() {
            if (IgneousPillar.this.status != StatusEffects.none) {
                Damage.status((Team)(IgneousPillar.this.damageAll ? null : this.team), (float)this.x, (float)this.y, (float)IgneousPillar.this.radius, (StatusEffect)IgneousPillar.this.status, (float)IgneousPillar.this.statusDuration, (boolean)IgneousPillar.this.damageAir, (boolean)IgneousPillar.this.damageGround);
            }
            Damage.damage((Team)(IgneousPillar.this.damageAll ? null : this.team), (float)this.x, (float)this.y, (float)IgneousPillar.this.radius, (float)IgneousPillar.this.damage, (boolean)IgneousPillar.this.damageAir, (boolean)IgneousPillar.this.damageGround);
            IgneousPillar.this.destroyEffect.at(this.x, this.y);
        }

        public float growf() {
            return Mathf.clamp((float)(this.growTimer / IgneousPillar.this.growTime));
        }

        public float timerf() {
            return Mathf.clamp((float)(this.boomTimer / this.delay));
        }

        public boolean canPickup() {
            return false;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.delay);
            write.f(this.boomTimer);
            write.f(this.growTimer);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.delay = read.f();
            this.boomTimer = read.f();
            if (revision >= 1) {
                this.growTimer = read.f();
            }
        }

        public byte version() {
            return 1;
        }
    }
}

