/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.core.Renderer;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.content.effects.LightningFx;
import progressed.content.effects.OtherFx;
import progressed.entities.LightningEffect;
import progressed.entities.PMDamage;
import progressed.world.meta.PMStatValues;

public class StaticNode
extends Block {
    protected static BuildPlan otherReq;
    protected static int returnInt;
    public final int shockTimer;
    public int laserRange;
    public float damage;
    public float reload;
    public float cooldown;
    public float powerPerLink;
    public int maxNodes;
    public boolean hitAir;
    public boolean hitGround;
    public StatusEffect status;
    public float statusDuration;
    public LightningEffect lightningEffect;
    public Effect shockEffect;
    public float minValue;
    public TextureRegion laser;
    public TextureRegion laserEnd;

    public StaticNode(String name) {
        super(name);
        this.shockTimer = this.timers++;
        this.laserRange = 20;
        this.reload = 5.0f;
        this.cooldown = 0.1f;
        this.maxNodes = 2;
        this.hitAir = true;
        this.hitGround = true;
        this.status = StatusEffects.shocked;
        this.statusDuration = 600.0f;
        this.lightningEffect = LightningFx.staticLightning;
        this.shockEffect = OtherFx.staticSpark;
        this.minValue = 0.75f;
        this.consumesPower = true;
        this.hasPower = true;
        this.configurable = true;
        this.outputsPower = false;
        this.canOverdrive = false;
        this.solid = true;
        this.update = true;
        this.drawDisabled = false;
        this.noUpdateDisabled = false;
        this.swapDiagonalPlacement = true;
        this.config(Integer.class, (entity, value) -> {
            boolean valid;
            IntSeq links = ((StaticNodeBuild)entity).links;
            StaticNodeBuild other = (StaticNodeBuild)Vars.world.build(value.intValue());
            boolean contains = links.contains(value.intValue());
            boolean bl = valid = other != null;
            if (contains) {
                links.removeValue(value.intValue());
                if (valid) {
                    other.links.removeValue(entity.pos());
                }
            } else if (this.linkValid((Building)entity, other) && valid && links.size < this.maxNodes) {
                if (!links.contains(other.pos())) {
                    links.add(other.pos());
                }
                if (other.team == entity.team && !other.links.contains(entity.pos())) {
                    other.links.add(entity.pos());
                }
            }
        });
        this.config(Point2[].class, (tile, value) -> {
            StaticNodeBuild t = (StaticNodeBuild)((Object)tile);
            t.links.clear();
            IntSeq old = new IntSeq(t.links);
            for (int i = 0; i < old.size; ++i) {
                int cur = old.get(i);
                ((Cons2)this.configurations.get(Integer.class)).get(tile, (Object)cur);
            }
            for (Point2 p : value) {
                int newPos = Point2.pack((int)(p.x + tile.tileX()), (int)(p.y + tile.tileY()));
                ((Cons2)this.configurations.get(Integer.class)).get(tile, (Object)newPos);
            }
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.powerRange, (float)this.laserRange, StatUnit.blocks);
        this.stats.add(Stat.powerConnections, (float)this.maxNodes, StatUnit.none);
        this.stats.remove(Stat.powerUse);
        this.stats.add(Stat.powerUse, Core.bundle.format("stat.pm-static-power", new Object[]{Float.valueOf(this.powerPerLink * 60.0f)}), new Object[0]);
        this.stats.add(Stat.targetsAir, this.hitAir);
        this.stats.add(Stat.targetsGround, this.hitGround);
        this.stats.add(Stat.ammo, PMStatValues.staticDamage(this.damage, this.reload, this.status));
    }

    public void init() {
        this.consumePowerDynamic(b -> ((StaticNodeBuild)((Object)b)).powerUse());
        this.clipSize = Math.max(this.clipSize, ((float)this.laserRange + 1.0f) * 8.0f * 2.0f);
        super.init();
    }

    public void load() {
        super.load();
        this.laser = Core.atlas.find(this.name + "-laser", "prog-mats-static-laser");
        this.laserEnd = Core.atlas.find(this.name + "-laser-end", "prog-mats-static-laser-end");
    }

    public void setBars() {
        super.setBars();
        this.addBar("connections", entity -> new Bar(() -> Core.bundle.format("bar.powerlines", new Object[]{entity.links.size, this.maxNodes}), () -> entity.team.color, () -> (float)entity.links.size / (float)this.maxNodes));
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Lines.stroke((float)1.0f);
        Draw.color((Color)Pal.placing);
        Drawf.circles((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.laserRange * 8));
        this.getPotentialLinks(tile, Vars.player.team(), (Cons<Building>)((Cons)other -> {
            Draw.color((Color)Tmp.c1.set(Vars.player.team().color), (float)Renderer.laserOpacity);
            this.staticLine(tile.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size, true, false);
            Drawf.square((float)other.x, (float)other.y, (float)((float)(other.block.size * 8) / 2.0f + 2.0f), (Color)Pal.place);
        }));
        Draw.reset();
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    public boolean staticLine(Team team, float x1, float y1, float x2, float y2, int size1, int size2, boolean drawLaser, boolean drawOther, boolean attack) {
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float len1 = (float)(size1 * 8) / 2.0f - 1.5f;
        float len2 = (float)(size2 * 8) / 2.0f - 1.5f;
        Tmp.v1.trns(angle1, len1);
        Tmp.v2.trns(angle1, len2);
        float space = Math.min(size1, size2);
        float scale = 0.25f;
        if (drawLaser) {
            Tmp.v3.trns(angle1 - 90.0f, space);
            Drawf.laser((TextureRegion)this.laser, (TextureRegion)this.laserEnd, (float)(x1 + Tmp.v1.x + Tmp.v3.x), (float)(y1 + Tmp.v1.y + Tmp.v3.y), (float)(x2 - Tmp.v2.x + Tmp.v3.x), (float)(y2 - Tmp.v2.y + Tmp.v3.y), (float)scale);
            if (drawOther) {
                Tmp.v3.trns(angle1 + 90.0f, space);
                Drawf.laser((TextureRegion)this.laser, (TextureRegion)this.laserEnd, (float)(x2 - Tmp.v2.x + Tmp.v3.x), (float)(y2 - Tmp.v2.y + Tmp.v3.y), (float)(x1 + Tmp.v1.x + Tmp.v3.x), (float)(y1 + Tmp.v1.y + Tmp.v3.y), (float)scale);
            }
        }
        if (attack) {
            Tmp.v3.trns(angle1 - 90.0f, space);
            float bx = x1 + Tmp.v1.x;
            float by = y1 + Tmp.v1.y;
            float dst = Mathf.dst((float)(bx + Tmp.v3.x), (float)(by + Tmp.v3.y), (float)(x2 - Tmp.v2.x + Tmp.v3.x), (float)(y2 - Tmp.v2.y + Tmp.v3.y));
            boolean hit = PMDamage.collideLine(this.damage, team, this.shockEffect, this.status, this.statusDuration, bx + Tmp.v3.x, by + Tmp.v3.y, angle1, dst, this.hitGround, this.hitAir);
            if (hit) {
                Tmp.v4.trns(angle1, dst).add(bx, by);
                this.lightningEffect.at(bx + Tmp.v3.x, by + Tmp.v3.y, Tmp.v4.x, Tmp.v4.y, team.color);
            }
            return hit;
        }
        return false;
    }

    public boolean staticLine(Team team, float x1, float y1, float x2, float y2, int size1, int size2, boolean drawLaser, boolean attack) {
        return this.staticLine(team, x1, y1, x2, y2, size1, size2, drawLaser, true, attack);
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, Block otherBlock, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)Tmp.r1.setCentered(other.worldx() + otherBlock.offset, other.worldy() + otherBlock.offset, (float)(otherBlock.size * 8), (float)(otherBlock.size * 8)));
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Building src, Building other, float range) {
        return this.overlaps(src.x, src.y, other.tile, range);
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps((Circle)Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, (float)(this.laserRange * 8)), (Rect)Tmp.r1.setSize((float)(this.size * 8)).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    protected void getPotentialLinks(Tile tile, Team team, Cons<Building> others) {
        Boolf valid = other -> {
            if (other == null) return false;
            if (other.tile == tile) return false;
            if (other.block != this) return false;
            if (!this.overlaps((float)(tile.x * 8) + this.offset, (float)(tile.y * 8) + this.offset, other.tile, this.laserRange * 8)) return false;
            if (other.team != team) return false;
            if (other instanceof StaticNodeBuild) {
                StaticNodeBuild obuild = (StaticNodeBuild)((Object)other);
                if (obuild.links.size >= ((StaticNode)obuild.block).maxNodes) return false;
            }
            if (Structs.contains((Object[])Edges.getEdges((int)this.size), p -> {
                Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
                return t != null && t.build == other;
            })) return false;
            return true;
        };
        tempBuilds.clear();
        Geometry.circle((int)tile.x, (int)tile.y, (int)(this.laserRange + 2), (x, y) -> {
            Building other = Vars.world.build(x, y);
            if (valid.get((Object)other) && !tempBuilds.contains((Object)other)) {
                tempBuilds.add((Object)other);
            }
        });
        tempBuilds.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof StaticNode, b.block instanceof StaticNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2((Position)tile), b.dst2((Position)tile));
        });
        returnInt = 0;
        tempBuilds.each(valid, t -> {
            if (returnInt++ < this.maxNodes) {
                others.get(t);
            }
        });
    }

    public void drawPlanConfigTop(BuildPlan req, Eachable<BuildPlan> list) {
        Point2[] point2Array = req.config;
        if (point2Array instanceof Point2[]) {
            Point2[] ps = point2Array;
            Draw.color((Color)Tmp.c1.set(Vars.player.team().color), (float)Renderer.laserOpacity);
            for (Point2 point : ps) {
                int px = req.x + point.x;
                int py = req.y + point.y;
                otherReq = null;
                list.each(other -> {
                    if (other.block != null && px >= other.x - (other.block.size - 1) / 2 && py >= other.y - (other.block.size - 1) / 2 && px <= other.x + other.block.size / 2 && py <= other.y + other.block.size / 2 && other != req && other.block.hasPower) {
                        otherReq = other;
                    }
                });
                if (otherReq == null || StaticNode.otherReq.block == null) continue;
                this.staticLine(Vars.player == null ? Team.sharded : Vars.player.team(), req.drawx(), req.drawy(), otherReq.drawx(), otherReq.drawy(), this.size, StaticNode.otherReq.block.size, true, false);
            }
            Draw.color();
        }
    }

    public boolean linkValid(Building tile, Building link) {
        return this.linkValid(tile, link, true);
    }

    public boolean linkValid(Building tile, Building link, boolean checkMaxNodes) {
        StaticNode node;
        block6: {
            block5: {
                Block block;
                if (tile == link || link == null || !((block = link.block) instanceof StaticNode)) break block5;
                node = (StaticNode)block;
                if (tile.team == link.team && tile.block == link.block) break block6;
            }
            return false;
        }
        if (this.overlaps(tile, link, (float)(this.laserRange * 8)) || this.overlaps(link, tile, (float)(node.laserRange * 8))) {
            if (checkMaxNodes) {
                StaticNodeBuild n = (StaticNodeBuild)link;
                return n.links.size < node.maxNodes || n.links.contains(tile.pos());
            }
            return true;
        }
        return false;
    }

    static {
        returnInt = 0;
    }

    public class StaticNodeBuild
    extends Building {
        public IntSeq links = new IntSeq();
        public boolean active;

        public void placed() {
            if (Vars.net.client()) {
                return;
            }
            StaticNode.this.getPotentialLinks(this.tile, this.team, (Cons<Building>)((Cons)other -> {
                if (!this.links.contains(other.pos())) {
                    this.configureAny(other.pos());
                }
            }));
            super.placed();
        }

        public void dropped() {
            this.links.clear();
        }

        public void onRemoved() {
            while (this.links.size > 0) {
                this.configure(this.links.get(0));
            }
            super.onRemoved();
        }

        public void updateTile() {
            super.updateTile();
            if (this.canConsume() && Groups.unit.contains(u -> u.team != this.team) && this.timer(StaticNode.this.shockTimer, StaticNode.this.reload / this.efficiency)) {
                for (int i : this.links.items) {
                    Building link = Vars.world.build(i);
                    if (!this.linked(link)) continue;
                    this.active = StaticNode.this.staticLine(this.team, this.x, this.y, link.x, link.y, StaticNode.this.size, link.block.size, false, true);
                }
            }
        }

        public float powerUse() {
            if (!this.active || this.links.size <= 0) {
                return 0.0f;
            }
            return StaticNode.this.powerPerLink * (float)this.links.size;
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (StaticNode.this.linkValid(this, other)) {
                this.configure(other.pos());
                return false;
            }
            if (this == other) {
                if (((StaticNodeBuild)other).links.size == 0) {
                    int[] total = new int[]{0};
                    StaticNode.this.getPotentialLinks(this.tile, this.team, (Cons<Building>)((Cons)link -> {
                        int n = total[0];
                        total[0] = n + 1;
                        if (n < StaticNode.this.maxNodes) {
                            this.configure(link.pos());
                        }
                    }));
                } else {
                    while (this.links.size > 0) {
                        this.configure(this.links.get(0));
                    }
                }
                this.deselect();
                return false;
            }
            return true;
        }

        public void drawSelect() {
            super.drawSelect();
            Lines.stroke((float)1.0f);
            Draw.color((Color)this.team.color);
            Drawf.circles((float)this.x, (float)this.y, (float)(StaticNode.this.laserRange * 8));
            Draw.reset();
        }

        public void drawConfigure() {
            Drawf.circles((float)this.x, (float)this.y, (float)((float)(this.tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin((float)Time.time, (float)4.0f, (float)1.0f)));
            Drawf.circles((float)this.x, (float)this.y, (float)(StaticNode.this.laserRange * 8));
            Draw.color((Color)this.team.color);
            for (int i : this.links.items) {
                Building link = Vars.world.build(i);
                if (link == this || !StaticNode.this.linkValid(this, link, false) || !this.linked(link)) continue;
                Drawf.square((float)link.x, (float)link.y, (float)((float)(link.block.size * 8) / 2.0f + 1.0f), (Color)Pal.place);
            }
            Draw.reset();
        }

        public void draw() {
            super.draw();
            if (Mathf.zero((float)Renderer.laserOpacity)) {
                return;
            }
            Draw.z((float)70.0f);
            for (int i : this.links.items) {
                Building link = Vars.world.build(i);
                if (!StaticNode.this.linkValid(this, link) || !this.linked(link)) continue;
                Draw.color((Color)Tmp.c1.set(this.team.color).mul(StaticNode.this.minValue + this.efficiency * (1.0f - StaticNode.this.minValue)), (float)Renderer.laserOpacity);
                StaticNode.this.staticLine(this.team, this.x, this.y, link.x, link.y, StaticNode.this.size, link.block.size, true, false, false);
            }
            Draw.reset();
        }

        protected boolean linked(Building other) {
            return other != null && this.links.contains(other.pos());
        }

        public Point2[] config() {
            Point2[] out = new Point2[this.links.size];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Point2.unpack((int)this.links.get(i)).sub((int)this.tile.x, (int)this.tile.y);
            }
            return out;
        }

        public void write(Writes write) {
            write.s(this.links.size);
            for (int i = 0; i < this.links.size; ++i) {
                write.i(this.links.get(i));
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.links.clear();
                int amount = read.s();
                for (int i = 0; i < amount; ++i) {
                    this.links.add(read.i());
                }
            }
        }

        public byte version() {
            return 1;
        }
    }
}

