/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.graphics.Color;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.Effect;
import mindustry.entities.Predict;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.meta.Stat;
import progressed.content.effects.EnergyFx;
import progressed.content.effects.LightningFx;
import progressed.entities.LightningEffect;
import progressed.graphics.PMPal;
import progressed.world.meta.PMStatValues;

public class EruptorTurret
extends PowerTurret {
    public final int beamTimer;
    public float beamInterval;
    public Color beamColor;
    public LightningEffect beamEffect;
    public Effect endEffect;
    public float shootDuration;

    public EruptorTurret(String name) {
        super(name);
        this.beamTimer = this.timers++;
        this.beamInterval = 2.0f;
        this.beamColor = PMPal.magma;
        this.beamEffect = LightningFx.flameBeam;
        this.endEffect = EnergyFx.eruptorBurn;
        this.shootDuration = 60.0f;
        this.targetAir = false;
        this.shootSound = Sounds.none;
        this.loopSound = Sounds.beam;
        this.loopSoundVolume = 2.0f;
        this.heatColor = Color.valueOf((String)"f08913");
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public class EruptorTurretBuild
    extends PowerTurret.PowerTurretBuild {
        protected Bullet bullet;
        protected float bulletLife;
        protected float lengthScl;

        public EruptorTurretBuild() {
            super((PowerTurret)EruptorTurret.this);
        }

        public void targetPosition(Posc pos) {
            if (!this.hasAmmo() || pos == null) {
                return;
            }
            Vec2 offset = Tmp.v1.setZero();
            if (EruptorTurret.this.accurateDelay && pos instanceof Hitboxc) {
                Hitboxc h = (Hitboxc)pos;
                offset.set(h.deltaX(), h.deltaY()).scl(EruptorTurret.this.shoot.firstShotDelay / Time.delta);
            }
            this.targetPos.set(Predict.intercept((Position)this, (Position)pos, (float)offset.x, (float)offset.y, (float)(EruptorTurret.this.range / EruptorTurret.this.shootDuration)));
            if (this.targetPos.isZero()) {
                this.targetPos.set((Position)pos);
            }
        }

        public boolean shouldConsume() {
            return this.bullet != null || this.isActive() || this.isShooting();
        }

        public boolean isShooting() {
            return super.isShooting() || this.bullet != null;
        }

        public void updateTile() {
            super.updateTile();
            if (this.bulletLife > 0.0f && this.bullet != null) {
                this.wasShooting = true;
                this.curRecoil = 1.0f;
                this.heat = 1.0f;
                Tmp.v1.trns(this.rotation, this.lengthScl * EruptorTurret.this.range, 0.0f);
                this.bullet.set(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
                this.bullet.time(0.0f);
                this.bulletLife -= Time.delta / Math.max(this.efficiency, 1.0E-5f);
                this.lengthScl += Time.delta / EruptorTurret.this.shootDuration;
                if (this.timer(EruptorTurret.this.beamTimer, EruptorTurret.this.beamInterval)) {
                    Tmp.v1.trns(this.rotation, EruptorTurret.this.shootY - this.curRecoil);
                    EruptorTurret.this.beamEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.bullet.x, this.bullet.y, EruptorTurret.this.beamColor);
                    EruptorTurret.this.endEffect.at((Position)this.bullet, this.rotation);
                }
                if (this.bulletLife <= 0.0f) {
                    this.bullet = null;
                    this.lengthScl = 0.0f;
                }
            }
        }

        public boolean shouldTurn() {
            return this.lengthScl < 0.001f;
        }

        protected void updateReload() {
            if (this.bulletLife > 0.0f && this.bullet != null) {
                return;
            }
            super.updateReload();
        }

        protected void updateCooling() {
            if (this.bulletLife > 0.0f && this.bullet != null) {
                return;
            }
            super.updateCooling();
        }

        protected void updateShooting() {
            if (this.bulletLife > 0.0f && this.bullet != null) {
                return;
            }
            super.updateShooting();
        }

        protected void handleBullet(Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                this.bullet = bullet;
                this.lengthScl = 0.0f;
                this.bulletLife = EruptorTurret.this.shootDuration;
            }
        }

        public boolean shouldActiveSound() {
            return this.bullet != null;
        }
    }
}

