/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Bullet;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import progressed.util.PMMathf;
import progressed.world.draw.DrawSwingTurret;

public class SwingContinuousTurret
extends ContinuousTurret {
    public float rotateSpeedAccel = 0.5f;
    public float rotateSpeedDrag = 0.3f;
    public float aimChangeSpeedAccel = 0.5f;
    public float aimChangeSpeedDrag = 0.3f;
    public float rotateSpeedfSpeed = 0.1f;

    public SwingContinuousTurret(String name) {
        super(name);
        this.drawer = new DrawSwingTurret();
    }

    public static class SwingBulletEntry
    extends Turret.BulletEntry {
        public float aimChangeSpeed;

        public SwingBulletEntry(Bullet bullet, float x, float y, float rotation, float life) {
            super(bullet, x, y, rotation, life);
        }
    }

    public class SwingContinuousTurretBuild
    extends ContinuousTurret.ContinuousTurretBuild {
        public float realRotateSpeed;
        public float rotateSpeedf;
        public boolean slowing;

        public SwingContinuousTurretBuild() {
            super((ContinuousTurret)SwingContinuousTurret.this);
        }

        public void updateTile() {
            super.updateTile();
            this.realRotateSpeed *= Math.max(1.0f - SwingContinuousTurret.this.rotateSpeedDrag * Time.delta, 0.0f);
            this.rotation = Mathf.mod((float)(this.rotation + this.realRotateSpeed * Time.delta), (float)360.0f);
            this.rotateSpeedf = Mathf.approachDelta((float)this.rotateSpeedf, (float)(this.slowing && this.isShooting() && this.hasAmmo() ? 1.0f - Math.abs(this.realRotateSpeed / SwingContinuousTurret.this.rotateSpeed) : 0.0f), (float)SwingContinuousTurret.this.rotateSpeedfSpeed);
        }

        protected void turnToTarget(float targetRot) {
            float targetSpeed = SwingContinuousTurret.this.rotateSpeed * (float)PMMathf.angleMoveDirection(this.rotation, targetRot);
            this.realRotateSpeed = Mathf.approachDelta((float)this.realRotateSpeed, (float)targetSpeed, (float)(SwingContinuousTurret.this.rotateSpeedAccel * this.efficiency));
            this.slowing = Mathf.sign((float)targetSpeed) != Mathf.sign((float)this.realRotateSpeed);
        }

        protected void updateBullet(Turret.BulletEntry entry) {
            float resultLength;
            if (!(entry instanceof SwingBulletEntry)) {
                return;
            }
            SwingBulletEntry s = (SwingBulletEntry)entry;
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(SwingContinuousTurret.this.shootX + entry.x), (float)(SwingContinuousTurret.this.shootY + entry.y));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(SwingContinuousTurret.this.shootX + entry.x), (float)(SwingContinuousTurret.this.shootY + entry.y));
            float angle = this.rotation + entry.rotation;
            entry.bullet.rotation(angle);
            entry.bullet.set(bulletX, bulletY);
            float shootLength = Math.min(this.dst((Position)this.targetPos), SwingContinuousTurret.this.range);
            float curLength = this.dst(entry.bullet.aimX, entry.bullet.aimY);
            if (SwingContinuousTurret.this.aimChangeSpeed == Float.POSITIVE_INFINITY) {
                resultLength = Math.max(shootLength, SwingContinuousTurret.this.shootY);
            } else {
                float targetSpeed = SwingContinuousTurret.this.aimChangeSpeed * (float)Mathf.sign((float)(shootLength - curLength));
                s.aimChangeSpeed = Mathf.approachDelta((float)s.aimChangeSpeed, (float)targetSpeed, (float)(SwingContinuousTurret.this.aimChangeSpeedAccel * this.efficiency));
                s.aimChangeSpeed *= Math.max(1.0f - SwingContinuousTurret.this.aimChangeSpeedDrag * Time.delta, 0.0f);
                resultLength = Math.max(curLength + s.aimChangeSpeed, SwingContinuousTurret.this.shootY);
            }
            this.lastLength = resultLength;
            Tmp.v1.trns(this.rotation, this.lastLength).add(this.x, this.y);
            entry.bullet.aimX = Tmp.v1.x;
            entry.bullet.aimY = Tmp.v1.y;
            if (this.isShooting() && this.hasAmmo()) {
                entry.bullet.time = entry.bullet.lifetime * entry.bullet.type.optimalLifeFract * this.shootWarmup;
                entry.bullet.keepAlive = true;
            }
        }

        protected void handleBullet(Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                this.bullets.add((Object)new SwingBulletEntry(bullet, offsetX, offsetY, angleOffset, 0.0f));
                Tmp.v1.trns(this.rotation, SwingContinuousTurret.this.shootY + this.lastLength).add(this.x, this.y);
                bullet.aimX = Tmp.v1.x;
                bullet.aimY = Tmp.v1.y;
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.realRotateSpeed);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 4) {
                this.realRotateSpeed = read.f();
            }
        }

        public byte version() {
            return 4;
        }
    }
}

