/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Posc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.logic.LAccess;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.UnitTetherBlock;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.meta.Stat;
import progressed.content.PMUnitTypes;
import progressed.gen.entities.SwordUnitc;
import progressed.graphics.PMDrawf;
import progressed.type.unit.SwordUnitType;

public class SwordTurret
extends BaseTurret {
    public static final float logicControlCooldown = 120.0f;
    public final int timerTarget;
    public float targetInterval;
    public SwordUnitType swordType;
    public int maxSwords;
    public float constructTime;
    public float buildPowerUse;
    public float attackPowerUse;
    public float buildY;
    public float buildWaveOffset;
    public float elevation;
    public float attackWarmupSpeed;
    public boolean linearWarmup;
    public float targetRad;
    public float targetLayer;
    public float targetY;
    public Color swordColor;
    public Color targetColor;
    public Units.Sortf unitSort;
    public Boolf<Unit> unitFilter;
    public Boolf<Building> buildingFilter;
    public TextureRegion baseRegion;

    public SwordTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.targetInterval = 20.0f;
        this.swordType = (SwordUnitType)PMUnitTypes.danceSword;
        this.maxSwords = 1;
        this.constructTime = 300.0f;
        this.buildY = Float.NEGATIVE_INFINITY;
        this.buildWaveOffset = 0.1f;
        this.elevation = -1.0f;
        this.attackWarmupSpeed = 0.1f;
        this.linearWarmup = false;
        this.targetRad = 4.0f;
        this.targetLayer = 100.0f;
        this.targetY = Float.NEGATIVE_INFINITY;
        this.unitSort = UnitSorts.closest;
        this.unitFilter = u -> true;
        this.buildingFilter = b -> !b.block.underBullets;
        this.outlinedIcon = 1;
        this.canOverdrive = false;
        this.consumePowerDynamic(SwordTurretBuild::powerUse);
    }

    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base", "block-" + this.size);
        if (!this.baseRegion.found() && this.minfo.mod != null) {
            this.baseRegion = Core.atlas.find(this.minfo.mod.name + "-block-" + this.size);
        }
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.weapons, table -> {
            table.row();
            table.image(this.swordType.fullIcon).padRight(4.0f).right().top();
            table.add((CharSequence)("[lightgray]x" + this.maxSwords)).padRight(10.0f).left().bottom();
            ((Table)table.table(s -> {
                if (this.swordType.damage > 0.0f) {
                    s.add((CharSequence)Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(this.swordType.damage)}));
                }
                s.row();
                s.add((CharSequence)"@bullet.infinitepierce");
                if (this.swordType.status != StatusEffects.none) {
                    s.row();
                    s.add((CharSequence)((this.swordType.status.minfo.mod == null ? this.swordType.status.emoji() : "") + "[stat]" + this.swordType.status.localizedName));
                }
            }).left().top().get()).background(Tex.underline);
        });
    }

    public void init() {
        super.init();
        if (this.swordType.orbitRadius == -1.0f) {
            this.swordType.orbitRadius = this.size * 8;
            if (this.buildY == Float.NEGATIVE_INFINITY) {
                this.buildY = this.swordType.orbitRadius;
            }
        }
        if (this.buildY == Float.NEGATIVE_INFINITY) {
            this.buildY = (float)(this.size * 8) / 2.0f;
        }
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
        if (!Vars.headless) {
            this.clipSize = Math.max(this.clipSize, Math.abs(this.buildY) + (float)this.swordType.fullIcon.height / 4.0f);
        }
        if (this.targetColor != null) {
            this.clipSize = Math.max(this.clipSize, this.range + this.targetRad);
        }
        if (this.targetY == Float.NEGATIVE_INFINITY) {
            this.targetY = (float)(this.size * 8) / 2.0f;
        }
    }

    public class SwordTurretBuild
    extends BaseTurret.BaseTurretBuild
    implements ControlBlock,
    UnitTetherBlock {
        public IntSeq readUnitIds;
        public Seq<SwordUnitc> swords;
        public float buildProgress;
        public float totalProgress;
        public float attackWarmup;
        public float logicControlTime;
        public boolean logicShooting;
        public Posc target;
        public Vec2 targetPos;
        public BlockUnitc unit;
        public boolean wasShooting;

        public SwordTurretBuild() {
            super((BaseTurret)SwordTurret.this);
            this.readUnitIds = new IntSeq(SwordTurret.this.maxSwords);
            this.swords = new Seq(SwordTurret.this.maxSwords);
            this.logicControlTime = -1.0f;
            this.targetPos = new Vec2();
            this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
        }

        public Unit unit() {
            this.unit.tile((Building)this);
            this.unit.team(this.team);
            return (Unit)this.unit;
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.shoot && !this.unit.isPlayer()) {
                this.targetPos.set(World.unconv((float)((float)p1)), World.unconv((float)((float)p2))).sub((Position)this).limit(SwordTurret.this.range).add((Position)this);
                this.logicControlTime = 120.0f;
                this.logicShooting = !Mathf.zero((double)p3);
            }
            super.control(type, p1, p2, p3, p4);
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            if (!(type != LAccess.shootp || this.unit != null && this.unit.isPlayer())) {
                this.logicControlTime = 120.0f;
                boolean bl = this.logicShooting = !Mathf.zero((double)p2);
                if (p1 instanceof Posc) {
                    Posc pos = (Posc)p1;
                    this.targetPosition(pos);
                }
            }
            super.control(type, p1, p2, p3, p4);
        }

        public boolean isAttacking() {
            return this.isControlled() ? this.unit.isShooting() : (this.logicControlled() ? this.logicShooting : this.target != null);
        }

        public boolean logicControlled() {
            return this.logicControlTime > 0.0f;
        }

        public boolean isActive() {
            return this.isAttacking() && this.enabled && this.canConsume();
        }

        public void targetPosition(Posc pos) {
            if (pos == null) {
                return;
            }
            this.targetPos.set((Position)pos).sub((Position)this).limit(SwordTurret.this.range).add((Position)this);
            if (this.targetPos.isZero()) {
                this.targetPos.set((Position)pos);
            }
        }

        public float drawrot() {
            return this.rotation - 90.0f;
        }

        public void draw() {
            Draw.rect((TextureRegion)SwordTurret.this.baseRegion, (float)this.x, (float)this.y);
            Draw.z((float)49.98f);
            Drawf.shadow((TextureRegion)SwordTurret.this.region, (float)(this.x - SwordTurret.this.elevation), (float)(this.y - SwordTurret.this.elevation), (float)this.drawrot());
            Draw.z((float)50.0f);
            Draw.rect((TextureRegion)SwordTurret.this.region, (float)this.x, (float)this.y, (float)this.drawrot());
            if (this.swordCount() < SwordTurret.this.maxSwords && this.buildProgress > 0.001f) {
                float swordX = this.x + Angles.trnsx((float)this.rotation, (float)SwordTurret.this.buildY);
                float swordY = this.y + Angles.trnsy((float)this.rotation, (float)SwordTurret.this.buildY);
                float z = 89.0f;
                Draw.draw((float)Math.min(80.0f, z - 1.0f), () -> PMDrawf.materialize(swordX + -12.0f, swordY + -13.0f, SwordTurret.this.swordType.fullIcon, SwordTurret.this.swordColor == null ? this.team.color : SwordTurret.this.swordColor, this.drawrot(), SwordTurret.this.buildWaveOffset, this.buildProgress, true));
                Draw.draw((float)z, () -> PMDrawf.materialize(swordX, swordY, SwordTurret.this.swordType.fullIcon, SwordTurret.this.swordColor == null ? this.team.color : SwordTurret.this.swordColor, this.drawrot(), SwordTurret.this.buildWaveOffset, this.buildProgress));
            }
            if (SwordTurret.this.targetColor != null && SwordTurret.this.targetRad > 0.0f && this.attackWarmup > 0.01f) {
                Lines.stroke((float)this.attackWarmup, (Color)SwordTurret.this.targetColor);
                Draw.z((float)SwordTurret.this.targetLayer);
                float rad = SwordTurret.this.targetRad * (1.0f + Mathf.absin((float)4.0f, (float)0.5f));
                Lines.square((float)this.targetPos.x, (float)this.targetPos.y, (float)rad, (float)45.0f);
                Tmp.v1.trns(this.rotation, SwordTurret.this.targetY).add((Position)this);
                float ang = this.targetPos.angleTo((Position)Tmp.v1);
                float calc = 1.0f + (1.0f - Mathf.sinDeg((float)(Mathf.mod((float)ang, (float)90.0f) * 2.0f))) * (Mathf.sqrt2 - 1.0f);
                Tmp.v2.trns(ang, rad / Mathf.sqrt2 * calc).add(this.targetPos);
                Fill.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)this.attackWarmup);
                Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
            }
        }

        public void updateTile() {
            SwordUnitc u;
            for (int i = 0; i < Math.min(this.readUnitIds.size, SwordTurret.this.maxSwords); ++i) {
                int id = this.readUnitIds.get(i);
                if (id == -1) continue;
                u = (SwordUnitc)Groups.unit.getByID(id);
                if (this.unit == null && Vars.net.client()) continue;
                u.orbitPos(i);
                this.swords.add((Object)u);
                this.readUnitIds.set(i, -1);
            }
            int s = 0;
            int prev = this.swords.size;
            while (s < this.swords.size) {
                u = (SwordUnitc)this.swords.get(s);
                if (u == null || u.dead() || !u.isAdded()) {
                    this.swords.remove(s);
                    continue;
                }
                ++s;
            }
            if (this.swords.size != prev) {
                for (int i = 0; i < this.swords.size; ++i) {
                    ((SwordUnitc)this.swords.get(i)).orbitPos(i);
                }
            }
            if (this.shouldConsume() && this.swordCount() < SwordTurret.this.maxSwords) {
                this.buildProgress += this.edelta() / SwordTurret.this.constructTime;
                this.totalProgress += this.edelta();
                if (this.buildProgress >= 1.0f) {
                    SwordUnitc u2 = (SwordUnitc)SwordTurret.this.swordType.create(this.team);
                    u2.building((Building)this);
                    u2.orbitPos(this.swordCount());
                    float spawnX = this.x + Angles.trnsx((float)this.rotation, (float)SwordTurret.this.buildY);
                    float spawnY = this.y + Angles.trnsy((float)this.rotation, (float)SwordTurret.this.buildY);
                    u2.set(spawnX, spawnY);
                    u2.rotation(this.rotation);
                    u2.add();
                    this.swords.add((Object)u2);
                    Fx.spawn.at(u2.x(), u2.y());
                    Call.unitTetherBlockSpawned((Tile)this.tile, (int)u2.id());
                }
            }
            if (!this.validateTarget()) {
                this.target = null;
            }
            float warmupTarget = Mathf.num((boolean)this.isAttacking());
            this.attackWarmup = SwordTurret.this.linearWarmup ? Mathf.approachDelta((float)this.attackWarmup, (float)warmupTarget, (float)SwordTurret.this.attackWarmupSpeed) : Mathf.lerpDelta((float)this.attackWarmup, (float)warmupTarget, (float)SwordTurret.this.attackWarmupSpeed);
            this.unit.tile((Building)this);
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            this.wasShooting = false;
            if (this.swordCount() > 0) {
                if (this.timer(SwordTurret.this.timerTarget, SwordTurret.this.targetInterval)) {
                    this.findTarget();
                }
                if (this.validateTarget()) {
                    this.wasShooting = true;
                    if (this.isControlled()) {
                        this.targetPos.set(this.unit.aimX(), this.unit.aimY()).sub((Position)this).limit(SwordTurret.this.range).add((Position)this);
                        this.wasShooting = this.unit.isShooting();
                    } else if (this.logicControlled()) {
                        this.wasShooting = this.logicShooting;
                    } else {
                        this.targetPosition(this.target);
                        if (Float.isNaN(this.rotation)) {
                            this.rotation = 0.0f;
                        }
                    }
                    this.turnToTarget(this.angleTo((Position)this.targetPos));
                }
            }
        }

        public int swordCount() {
            return this.swords.size;
        }

        public void spawned(int id) {
            this.buildProgress = 0.0f;
            if (Vars.net.client()) {
                this.readUnitIds.add(id);
            }
        }

        protected boolean validateTarget() {
            return !Units.invalidateTarget((Posc)this.target, (Team)this.team, (float)this.x, (float)this.y) || this.isControlled() || this.logicControlled();
        }

        public void findTarget() {
            SwordUnitType u = SwordTurret.this.swordType;
            this.target = u.targetAir && !u.targetGround ? Units.bestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)SwordTurret.this.range, e -> !e.dead() && !e.isGrounded() && SwordTurret.this.unitFilter.get(e), (Units.Sortf)SwordTurret.this.unitSort) : Units.bestTarget((Team)this.team, (float)this.x, (float)this.y, (float)SwordTurret.this.range, e -> !(e.dead() || !SwordTurret.this.unitFilter.get(e) || !e.isGrounded() && !u.targetAir || e.isGrounded() && !u.targetGround), b -> u.targetGround && SwordTurret.this.buildingFilter.get(b), (Units.Sortf)SwordTurret.this.unitSort);
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(SwordTurret.this.rotateSpeed * this.delta() * this.potentialEfficiency));
        }

        public boolean shouldConsume() {
            return this.swordCount() < SwordTurret.this.maxSwords || this.isAttacking();
        }

        public float progress() {
            return this.buildProgress;
        }

        public float totalProgress() {
            return this.totalProgress;
        }

        public float powerUse() {
            return (this.swordCount() < SwordTurret.this.maxSwords ? SwordTurret.this.buildPowerUse : 0.0f) + (this.isAttacking() ? SwordTurret.this.attackPowerUse : 0.0f);
        }

        public void created() {
            super.created();
            Arrays.fill(this.readUnitIds.items, -1);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
            write.f(this.buildProgress);
            write.i(this.swords.size);
            this.swords.each(u -> write.i(u == null ? -1 : u.id()));
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 2) {
                this.rotation = read.f();
                this.buildProgress = read.f();
                int size = read.i();
                for (int i = 0; i < size; ++i) {
                    this.readUnitIds.add(read.i());
                }
            }
        }

        public byte version() {
            return 2;
        }
    }
}

