/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular;

import arc.func.Func;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Reflect;
import mindustry.audio.SoundLoop;
import mindustry.gen.Building;
import mindustry.ui.Bar;
import mindustry.world.Block;
import progressed.graphics.PMDrawf;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.module.ModuleModule;

public interface TurretModule {
    public ModuleModule module();

    public ModuleModule.ModuleSize size();

    public Building build();

    public Iterable<Func<Building, Bar>> listModuleBars();

    default public float x() {
        return this.build().x;
    }

    default public float y() {
        return this.build().y;
    }

    default public Block block() {
        return this.build().block;
    }

    default public String name() {
        return this.build().block.localizedName;
    }

    default public TextureRegion icon() {
        return this.build().block.fullIcon;
    }

    default public ModularTurret.ModularTurretBuild parent() {
        return this.module().parent;
    }

    default public float deployTime() {
        return 60.0f;
    }

    default public void moduleUpdate() {
        this.module().moduleUpdate();
        if (this.isDeployed()) {
            this.build().update();
        }
    }

    default public void moduleDraw() {
        Draw.z((float)50.0f);
        if (!this.isDeployed()) {
            this.drawDeploy();
            return;
        }
        this.build().draw();
        if (this.module().highlight) {
            Draw.z((float)120.0f);
            this.module().highlight();
            this.build().drawSelect();
            Draw.z((float)50.0f);
        }
    }

    default public void drawDeploy() {
        float elevation = (float)this.block().size / 2.0f;
        Draw.draw((float)Draw.z(), () -> {
            PMDrawf.materialize(this.x() - elevation, this.y() - elevation, this.icon(), this.build().team.color, 0.0f, 0.1f, this.module().progress, true);
            PMDrawf.materialize(this.x(), this.y(), this.icon(), this.build().team.color, 0.0f, 0.1f, this.module().progress);
        });
    }

    default public void swap(short number) {
    }

    default public boolean isSmall() {
        return this.size() == ModuleModule.ModuleSize.small;
    }

    default public boolean isMedium() {
        return this.size() == ModuleModule.ModuleSize.medium;
    }

    default public boolean isLarge() {
        return this.size() == ModuleModule.ModuleSize.large;
    }

    default public boolean checkSize(ModuleModule.ModuleSize size) {
        return size == this.size();
    }

    default public boolean checkNumber(short number) {
        return this.module().mountNumber == number;
    }

    default public boolean checkLastNumber(short number) {
        return this.module().lastNumber == number;
    }

    default public void moduleRemoved() {
        SoundLoop loop = (SoundLoop)Reflect.get(Building.class, (Object)this.build(), (String)"sound");
        if (loop != null) {
            loop.stop();
        }
    }

    default public boolean isModule() {
        return this.module().parent != null;
    }

    default public boolean isDeployed() {
        return this.module().progress >= 0.999f;
    }

    default public boolean isActive() {
        return this.isDeployed();
    }

    default public boolean acceptModule(TurretModule module) {
        return true;
    }
}

