/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import progressed.entities.PMDamage;
import progressed.entities.bullet.pseudo3d.ArcMissileBulletType;
import progressed.util.Math3D;
import progressed.util.PMMathf;
import progressed.util.PMUtls;
import progressed.world.blocks.defence.turret.payload.modular.modules.ItemTurretModule;
import progressed.world.draw.DrawTurretModule;

public class ArcModule
extends ItemTurretModule {
    public float accelRnd = 0.0f;

    public ArcModule(String name) {
        super(name);
        this.consumeAmmoOnce = false;
        this.recoil = 0.0f;
        this.shootY = 0.0f;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.connectedPower = false;
        this.drawer = new DrawTurretModule();
    }

    @Override
    public void init() {
        for (Item c : this.ammoTypes.keys()) {
            Object object = this.ammoTypes.get((Object)c);
            if (!(object instanceof ArcMissileBulletType)) {
                PMUtls.uhOhSpeghettiOh("Arc missile turret " + this.name + " has a non-arc missle bullet!");
                continue;
            }
            ArcMissileBulletType aType = (ArcMissileBulletType)((Object)object);
            aType.initDrawSize(this.range);
        }
        super.init();
    }

    public class ArcModuleBuild
    extends ItemTurretModule.ItemTurretModuleBuild {
        protected Seq<Posc> targets;

        public ArcModuleBuild() {
            super(ArcModule.this);
            this.targets = new Seq();
        }

        public void targetPosition(Posc pos) {
            if (!this.hasAmmo() || pos == null) {
                return;
            }
            ArcMissileBulletType bullet = (ArcMissileBulletType)this.peekAmmo();
            if (ArcModule.this.predictTarget && pos instanceof Hitboxc) {
                Hitboxc h = (Hitboxc)pos;
                this.targetPos.set(Math3D.intercept((Position)this, (Position)h, bullet.accel, bullet.speed));
            } else {
                this.targetPos.set((Position)pos);
            }
            if (!bullet.scaleLife) {
                this.targetPos.sub((Position)this).setLength(ArcModule.this.range).add((Position)this);
            }
            if (this.targetPos.isZero()) {
                this.targetPos.set((Position)pos);
            }
        }

        protected void updateReload() {
            if (this.queuedBullets > 0) {
                return;
            }
            super.updateReload();
        }

        @Override
        public void drawSelect() {
            if (!this.isModule()) {
                return;
            }
            super.drawSelect();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)ArcModule.this.minRange, (Color)Pal.accentBack);
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = targetRot;
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            if (!this.isControlled() && !this.logicControlled()) {
                this.targets.clear();
                PMDamage.allNearbyEnemies(this.team, this.x, this.y, ArcModule.this.range, (Cons<Healthc>)((Cons)h -> {
                    if (h instanceof Unit) {
                        Unit u = (Unit)h;
                        if (!u.dead() && ArcModule.this.unitFilter.get((Object)u) && (u.isGrounded() || ArcModule.this.targetAir) && (!u.isGrounded() || ArcModule.this.targetGround) && this.dst((Position)u) >= ArcModule.this.minRange) {
                            this.targets.add((Object)u);
                        }
                    } else if (h instanceof Building) {
                        Building b = (Building)h;
                        if (ArcModule.this.targetGround && ArcModule.this.buildingFilter.get((Object)b) && this.dst((Position)b) >= ArcModule.this.minRange) {
                            this.targets.add((Object)b);
                        }
                    }
                }));
                if (!this.targets.isEmpty()) {
                    this.target = (Posc)this.targets.random();
                    this.targetPosition(this.target);
                }
            }
            this.turnToTarget(this.angleTo((Position)this.targetPos));
            --this.queuedBullets;
            if (this.dead || !ArcModule.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)ArcModule.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(ArcModule.this.shootX + xOffset + xSpread), (float)(ArcModule.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(ArcModule.this.shootX + xOffset + xSpread), (float)(ArcModule.this.shootY + yOffset));
            float shootAngle = this.rotation + angleOffset + Mathf.range((float)(ArcModule.this.inaccuracy + type.inaccuracy));
            float accScl = 1.0f + Mathf.range((float)(ArcModule.this.accelRnd / 2.0f));
            float velScl = 1.0f + Mathf.range((float)(ArcModule.this.velocityRnd / 2.0f));
            float dst = Math.max(Math.min(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y), this.range()), ArcModule.this.minRange);
            ArcMissileBulletType m = (ArcMissileBulletType)type;
            float time = PMMathf.quadPos(m.accel / 2.0f, m.speed, -dst);
            float zVel = -0.5f * -m.gravity * time;
            this.handleBullet(m.create3DVel((Entityc)this, this.team, bulletX, bulletY, 0.0f, shootAngle, zVel, m.accel * accScl, m.speed * velScl, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            (ArcModule.this.shootEffect == null ? type.shootEffect : ArcModule.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (ArcModule.this.smokeEffect == null ? type.smokeEffect : ArcModule.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            ArcModule.this.shootSound.at(bulletX, bulletY, Mathf.random((float)ArcModule.this.soundPitchMin, (float)ArcModule.this.soundPitchMax));
            ArcModule.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)ArcModule.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)ArcModule.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (ArcModule.this.shake > 0.0f) {
                Effect.shake((float)ArcModule.this.shake, (float)ArcModule.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (ArcModule.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % ArcModule.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!ArcModule.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        public float drawrot() {
            return 0.0f;
        }
    }
}

