/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.func.Func;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import progressed.content.blocks.PMModules;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.draw.DrawTurretModule;
import progressed.world.meta.PMStatValues;
import progressed.world.module.ModuleModule;

public class PowerTurretModule
extends PowerTurret {
    public ModuleModule.ModuleSize moduleSize = ModuleModule.ModuleSize.small;
    OrderedMap<String, Func<Building, Bar>> moduleBarMap = new OrderedMap();

    public PowerTurretModule(String name) {
        super(name);
        this.update = false;
        this.destructible = true;
        this.rebuildable = false;
        this.breakable = false;
        this.group = BlockGroup.turrets;
        this.connectedPower = false;
        this.drawer = new DrawTurretModule();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
    }

    public void init() {
        super.init();
        PMModules.setClip(this.clipSize);
        this.fogRadius = -1;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public void setBars() {
        super.setBars();
        this.moduleBarMap.putAll((ObjectMap)this.barMap);
        this.moduleBarMap.remove((Object)"health");
        this.removeBar("power");
        this.removeBar("heat");
    }

    public <T extends Building> void addModuleBar(String name, Func<T, Bar> sup) {
        this.moduleBarMap.put((Object)name, sup);
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor() || Vars.state.rules.infiniteResources;
    }

    public class PowerTurretModuleBuild
    extends PowerTurret.PowerTurretBuild
    implements TurretModule {
        public ModuleModule module;

        public PowerTurretModuleBuild() {
            super((PowerTurret)PowerTurretModule.this);
        }

        public Building create(Block block, Team team) {
            super.create(block, team);
            this.module = new ModuleModule((TurretModule)this.self(), PowerTurretModule.this.hasPower);
            return (Building)this.self();
        }

        public Unit unit() {
            if (this.parent() != null && this.canControl()) {
                this.unit = (BlockUnitc)this.parent().unit();
                return (Unit)this.unit;
            }
            return super.unit();
        }

        public boolean canControl() {
            return super.canControl() && this.isDeployed();
        }

        public void updateTile() {
            if (!this.isDeployed()) {
                return;
            }
            super.updateTile();
        }

        public void drawSelect() {
            if (!this.isModule()) {
                return;
            }
            super.drawSelect();
        }

        @Override
        public void moduleRemoved() {
            TurretModule.super.moduleRemoved();
            this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
        }

        @Override
        public ModuleModule module() {
            return this.module;
        }

        @Override
        public ModuleModule.ModuleSize size() {
            return PowerTurretModule.this.moduleSize;
        }

        @Override
        public Building build() {
            return (Building)this.self();
        }

        @Override
        public Iterable<Func<Building, Bar>> listModuleBars() {
            return PowerTurretModule.this.moduleBarMap.values();
        }

        public void pickedUp() {
            this.module.progress = 0.0f;
            this.reloadCounter = 0.0f;
            this.rotation = 90.0f;
        }

        public boolean isValid() {
            return super.isValid() || this.parent() != null && this.parent().isValid();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) && (this.liquids.current() == null || this.liquids.currentAmount() < PowerTurretModule.this.liquidCapacity);
        }

        public void write(Writes write) {
            super.write(write);
            this.module.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            (this.module == null ? new ModuleModule((TurretModule)this.self(), PowerTurretModule.this.hasPower) : this.module).read(read);
        }
    }
}

