/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.type.Liquid;
import progressed.util.PMMathf;
import progressed.world.blocks.defence.turret.payload.modular.modules.PowerTurretModule;
import progressed.world.draw.DrawTurretModule;

public class SweepLaserTurretModule
extends PowerTurretModule {
    public float angleRnd = 30.0f;
    public float endDst = 80.0f;
    public float endRad = 16.0f;
    public float handleAngleRnd = 60.0f;
    public float handleLengthMin = 16.0f;
    public float handleLengthMax = 64.0f;
    public float sweepDuration = 60.0f;

    public SweepLaserTurretModule(String name) {
        super(name);
        this.canOverdrive = false;
        this.shootSound = Sounds.none;
        this.loopSoundVolume = 0.5f;
        this.loopSound = Sounds.laserbeam;
        this.drawer = new DrawTurretModule();
    }

    public class SweepLaserTurretModuleBuild
    extends PowerTurretModule.PowerTurretModuleBuild {
        public float dst;
        public float life;
        public float time;
        public Bullet bullet;

        public boolean shouldConsume() {
            return this.bullet != null || this.isActive() || this.isShooting();
        }

        @Override
        public void updateTile() {
            if (!this.isDeployed()) {
                return;
            }
            super.updateTile();
            if (this.bullet != null) {
                this.updateBullet();
            } else if (this.reloadCounter < SweepLaserTurretModule.this.reload) {
                this.wasShooting = true;
                if (SweepLaserTurretModule.this.coolant != null) {
                    Liquid liquid = this.liquids.current();
                    float maxUsed = SweepLaserTurretModule.this.coolant.amount;
                    float used = (this.cheating() ? maxUsed : Math.min(this.liquids.get(liquid), maxUsed)) * this.delta();
                    this.reloadCounter += used * liquid.heatCapacity * SweepLaserTurretModule.this.coolantMultiplier;
                    this.liquids.remove(liquid, used);
                    if (Mathf.chance((double)(0.06 * (double)used))) {
                        SweepLaserTurretModule.this.coolEffect.at(this.x + Mathf.range((float)((float)(SweepLaserTurretModule.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(SweepLaserTurretModule.this.size * 8) / 2.0f)));
                    }
                } else {
                    this.reloadCounter += this.edelta();
                }
            }
        }

        protected void updateBullet() {
            if (this.life <= 0.0f || !this.bullet.isAdded() || this.bullet.owner != this) {
                this.bullet = null;
                return;
            }
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)SweepLaserTurretModule.this.shootX, (float)SweepLaserTurretModule.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)SweepLaserTurretModule.this.shootX, (float)SweepLaserTurretModule.this.shootY);
            this.bullet.set(bulletX, bulletY);
            Tmp.v1.trns(this.rotation, this.dst);
            float bx = this.x + Tmp.v1.x;
            float by = this.y + Tmp.v1.y;
            this.path(Interp.smooth.apply(this.time), bx, by, this.rotation);
            this.bullet.aimX = Tmp.v1.x;
            this.bullet.aimY = Tmp.v1.y;
            this.bullet.time = Math.min(this.bullet.time + Time.delta, this.bullet.lifetime * this.bullet.type.optimalLifeFract);
            this.bullet.keepAlive = true;
            this.time += Time.delta / SweepLaserTurretModule.this.sweepDuration;
            this.life -= Time.delta / Math.max(this.efficiency, 1.0E-5f);
            this.wasShooting = true;
            this.heat = 1.0f;
            this.curRecoil = 1.0f;
        }

        protected void updateCooling() {
        }

        protected void updateReload() {
        }

        protected void updateShooting() {
            if (this.bullet != null) {
                return;
            }
            if (this.reloadCounter >= SweepLaserTurretModule.this.reload && this.efficiency > 0.0f && !this.charging() && this.shootWarmup >= SweepLaserTurretModule.this.minWarmup) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter = 0.0f;
            }
        }

        protected void turnToTarget(float targetRot) {
            if (this.bullet != null) {
                return;
            }
            this.rotation = targetRot;
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            super.bullet(type, xOffset, yOffset, angleOffset, mover);
            this.dst = Mathf.clamp((float)this.dst((Position)this.targetPos), (float)SweepLaserTurretModule.this.minRange, (float)this.range());
        }

        protected void handleBullet(Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            this.bullet = bullet;
            this.time = 0.0f;
            this.life = SweepLaserTurretModule.this.sweepDuration;
        }

        public void path(float t, float bx, float by, float rot) {
            Mathf.rand.setSeed((long)(this.id + this.pos() + this.totalShots));
            float pathRot = rot + 90.0f + Mathf.rand.range(SweepLaserTurretModule.this.angleRnd);
            PMMathf.randomCirclePoint(Tmp.v2, SweepLaserTurretModule.this.endRad);
            Tmp.v1.trns(pathRot, SweepLaserTurretModule.this.endDst / 2.0f).add(Tmp.v2);
            float x1 = Tmp.v1.x + bx;
            float y1 = Tmp.v1.y + by;
            Tmp.v1.trns(pathRot, -SweepLaserTurretModule.this.endDst / 2.0f).sub(Tmp.v2);
            float x2 = Tmp.v1.x + bx;
            float y2 = Tmp.v1.y + by;
            int flip = Mathf.randomSign();
            float len = Mathf.rand.random(SweepLaserTurretModule.this.handleLengthMin, SweepLaserTurretModule.this.handleLengthMax);
            Tmp.v3.trns(pathRot + 180.0f + Mathf.rand.random(SweepLaserTurretModule.this.handleAngleRnd) * (float)flip, len);
            Tmp.v4.trns(pathRot + Mathf.rand.random(SweepLaserTurretModule.this.handleAngleRnd) * (float)flip, len);
            Tmp.v1.set(PMMathf.bezier(t, x1, y1, x2, y2, Tmp.v3, Tmp.v4));
        }

        @Override
        public void pickedUp() {
            super.pickedUp();
            this.bullet = null;
        }

        public float activeSoundVolume() {
            return 1.0f;
        }

        public boolean shouldActiveSound() {
            return this.bullet != null;
        }
    }
}

