/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.testing;

import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.gen.Entityc;
import progressed.entities.bullet.pseudo3d.ArcBoltBulletType;
import progressed.graphics.draw3d.Draw3D;
import progressed.world.blocks.defence.turret.testing.ArcBulletTestTurret;

public class ArcBulletScatterTestTurret
extends ArcBulletTestTurret {
    public float bAccel = 0.0f;

    public ArcBulletScatterTestTurret(String name) {
        super(name);
        this.shootType = new ArcBoltBulletType(15.0f, 30.0f){
            {
                this.trailLength = 40;
            }
        };
        this.reload = 1.0f;
        this.shotTilt = -90.0f;
        this.inaccuracy = 60.0f;
        this.shoot = new ShootPattern(){
            {
                this.shots = 5;
            }
        };
        this.shotZ = 360.0f;
    }

    public class ArcBulletScatterTestTurretBuild
    extends ArcBulletTestTurret.ArcBulletTestTurretBuild {
        public ArcBulletScatterTestTurretBuild() {
            super(ArcBulletScatterTestTurret.this);
        }

        @Override
        public void drawAimDebug() {
            if (!ArcBulletScatterTestTurret.this.drawAimDebug) {
                return;
            }
            Draw.z((float)147.0f);
            Draw3D.drawAimDebug(this.x, this.y, ArcBulletScatterTestTurret.this.shotZ, ArcBulletScatterTestTurret.this.shootType.speed * 8.0f, 0.0f, -90.0f, ArcBulletScatterTestTurret.this.inaccuracy);
        }

        @Override
        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !ArcBulletScatterTestTurret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)ArcBulletScatterTestTurret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(ArcBulletScatterTestTurret.this.shootX + xOffset + xSpread), (float)(ArcBulletScatterTestTurret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(ArcBulletScatterTestTurret.this.shootX + xOffset + xSpread), (float)(ArcBulletScatterTestTurret.this.shootY + yOffset));
            float shootAngle = Mathf.random((int)360);
            float velScl = 1.0f + Mathf.range((float)(ArcBulletScatterTestTurret.this.velocityRnd / 2.0f));
            ArcBoltBulletType aType = (ArcBoltBulletType)type;
            this.handleBullet(aType.create3DStraight((Entityc)this, this.team, this.x, this.y, ArcBulletScatterTestTurret.this.shotZ, shootAngle, Mathf.random((float)-90.0f, (float)(-90.0f + ArcBulletScatterTestTurret.this.inaccuracy)), aType.speed * velScl, ArcBulletScatterTestTurret.this.bAccel), xOffset, yOffset, shootAngle - this.rotation);
            (ArcBulletScatterTestTurret.this.shootEffect == null ? type.shootEffect : ArcBulletScatterTestTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (ArcBulletScatterTestTurret.this.smokeEffect == null ? type.smokeEffect : ArcBulletScatterTestTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            ArcBulletScatterTestTurret.this.shootSound.at(bulletX, bulletY, Mathf.random((float)ArcBulletScatterTestTurret.this.soundPitchMin, (float)ArcBulletScatterTestTurret.this.soundPitchMax));
            ArcBulletScatterTestTurret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)ArcBulletScatterTestTurret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)ArcBulletScatterTestTurret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (ArcBulletScatterTestTurret.this.shake > 0.0f) {
                Effect.shake((float)ArcBulletScatterTestTurret.this.shake, (float)ArcBulletScatterTestTurret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (ArcBulletScatterTestTurret.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % ArcBulletScatterTestTurret.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!ArcBulletScatterTestTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }
    }
}

