/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.distribution;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.OrderedSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.content.bullets.PMBullets;

public class BurstDriver
extends Block {
    public float range;
    public float rotateSpeed = 0.04f;
    public float shootY = 7.0f;
    public int minDistribute = 10;
    public float recoil = 4.0f;
    public float restitution = 0.03f;
    public float elevation = -1.0f;
    public float reload = 100.0f;
    public float speed = 6.5f;
    public float lifetime = 100.0f;
    public Effect shootEffect = Fx.shootSmall;
    public Effect smokeEffect = Fx.shootSmallSmoke;
    public Effect receiveEffect = Fx.mine;
    public Sound shootSound = Sounds.shoot;
    public float shake = 1.0f;
    public int shots = 10;
    public float delay = 1.0f;
    public float xRand = 3.0f;
    public TextureRegion baseRegion;
    protected Vec2 tr = new Vec2();
    protected Vec2 recoilOffset = new Vec2();

    public BurstDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.hasItems = true;
        this.hasPower = true;
        this.outlineIcon = true;
        this.sync = true;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack((int)(point.x + tile.tileX()), (int)(point.y + tile.tileY()));
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / (this.reload + 1.0f) * (float)this.shots, StatUnit.none);
    }

    public void init() {
        super.init();
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
    }

    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base", "mass-driver-base");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8), (float)(y * 8), (float)this.range, (Color)Pal.accent);
        if (!Vars.control.input.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.config.getSelected();
        if (selected == null || selected.block != this || !selected.within((float)(x * 8), (float)(y * 8), this.range)) {
            return;
        }
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst((float)(x * 8), (float)(y * 8)) / 8.0f);
        Lines.stroke((float)4.0f, (Color)Pal.gray);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Lines.stroke((float)2.0f, (Color)Pal.placing);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Draw.reset();
    }

    public class BurstDriverBuild
    extends Building {
        public int link = -1;
        public float rotation = 90.0f;
        public float reloadCounter;
        public float curRecoil;
        public MassDriver.DriverState state = MassDriver.DriverState.idle;
        public OrderedSet<Tile> waitingShooters = new OrderedSet();

        public Tile currentShooter() {
            return this.waitingShooters.isEmpty() ? null : (Tile)this.waitingShooters.first();
        }

        public void updateTile() {
            Building link = Vars.world.build(this.link);
            boolean hasLink = this.linkValid();
            this.curRecoil = Mathf.lerpDelta((float)this.curRecoil, (float)0.0f, (float)BurstDriver.this.restitution);
            if (hasLink) {
                this.link = link.pos();
            }
            if (this.reloadCounter > 0.0f) {
                this.reloadCounter = Mathf.clamp((float)(this.reloadCounter - this.edelta() / BurstDriver.this.reload));
            }
            if (!this.shooterValid(this.currentShooter())) {
                this.waitingShooters.remove((Object)this.currentShooter());
            }
            if (this.state == MassDriver.DriverState.idle) {
                if (!this.waitingShooters.isEmpty() && BurstDriver.this.itemCapacity - this.items.total() >= BurstDriver.this.minDistribute) {
                    this.state = MassDriver.DriverState.accepting;
                } else if (hasLink) {
                    this.state = MassDriver.DriverState.shooting;
                }
            }
            if (this.state == MassDriver.DriverState.idle || this.state == MassDriver.DriverState.accepting) {
                this.dump();
            }
            if (this.efficiency <= 0.0f) {
                return;
            }
            if (this.state == MassDriver.DriverState.accepting) {
                if (this.currentShooter() == null || BurstDriver.this.itemCapacity - this.items.total() < BurstDriver.this.minDistribute && !this.sandy()) {
                    this.state = MassDriver.DriverState.idle;
                    return;
                }
                this.rotation = Mathf.slerpDelta((float)this.rotation, (float)this.tile.angleTo((Position)this.currentShooter()), (float)(BurstDriver.this.rotateSpeed * this.efficiency));
            } else if (this.state == MassDriver.DriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && BurstDriver.this.itemCapacity - this.items.total() >= BurstDriver.this.minDistribute) {
                    this.state = MassDriver.DriverState.idle;
                    return;
                }
                float targetRotation = this.tile.angleTo((Position)link);
                if ((this.items.total() >= BurstDriver.this.minDistribute || this.sandy()) && link.block.itemCapacity - link.items.total() >= BurstDriver.this.minDistribute) {
                    BurstDriverBuild other = (BurstDriverBuild)link;
                    other.waitingShooters.add((Object)this.tile);
                    if (this.reloadCounter <= 1.0E-4f) {
                        this.rotation = Mathf.slerpDelta((float)this.rotation, (float)targetRotation, (float)(BurstDriver.this.rotateSpeed * this.efficiency));
                        if (other.currentShooter() == this.tile && other.state == MassDriver.DriverState.accepting && Angles.near((float)this.rotation, (float)targetRotation, (float)2.0f) && Angles.near((float)other.rotation, (float)(targetRotation + 180.0f), (float)2.0f)) {
                            this.fire(other);
                            float timeToArrive = Math.min(BurstDriver.this.lifetime, this.dst((Position)other) / BurstDriver.this.speed);
                            Time.run((float)timeToArrive, () -> {
                                other.waitingShooters.remove((Object)this.tile);
                                other.state = MassDriver.DriverState.idle;
                            });
                            this.state = MassDriver.DriverState.idle;
                        }
                    }
                }
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)BurstDriver.this.baseRegion, (float)this.x, (float)this.y);
            Draw.z((float)50.0f);
            BurstDriver.this.recoilOffset.trns(this.rotation, -this.curRecoil);
            Drawf.shadow((TextureRegion)BurstDriver.this.region, (float)(this.x + BurstDriver.this.recoilOffset.x - BurstDriver.this.elevation), (float)(this.y + BurstDriver.this.recoilOffset.y - BurstDriver.this.elevation), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)BurstDriver.this.region, (float)(this.x + BurstDriver.this.recoilOffset.x), (float)(this.y + BurstDriver.this.recoilOffset.y), (float)(this.rotation - 90.0f));
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            for (Tile shooter : this.waitingShooters) {
                Drawf.circles((float)shooter.drawx(), (float)shooter.drawy(), (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)shooter.drawx(), (float)shooter.drawy(), (float)this.x, (float)this.y, (float)((float)(BurstDriver.this.size * 8) + sin), (float)(4.0f + sin), (Color)Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles((float)target.x, (float)target.y, (float)(((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)this.x, (float)this.y, (float)target.x, (float)target.y, (float)((float)(BurstDriver.this.size * 8) + sin), (float)(4.0f + sin));
            }
            Drawf.dashCircle((float)this.x, (float)this.y, (float)BurstDriver.this.range, (Color)Pal.accent);
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block instanceof BurstDriver && other.dst((Position)this.tile) <= BurstDriver.this.range && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < BurstDriver.this.itemCapacity && this.linkValid() && !this.sandy();
        }

        protected void fire(BurstDriverBuild target) {
            this.reloadCounter = 1.0f;
            for (int i = 0; i < Math.min(BurstDriver.this.shots, this.sandy() ? BurstDriver.this.shots : this.items.total()); ++i) {
                Time.run((float)((float)i * BurstDriver.this.delay), () -> {
                    if (!this.isValid() || this.efficiency <= 0.0f) {
                        return;
                    }
                    BurstDriverData data = (BurstDriverData)Pools.obtain(BurstDriverData.class, () -> new BurstDriverData());
                    boolean canShoot = false;
                    data.from = this;
                    data.to = target;
                    if (this.sandy()) {
                        data.item = (Item)Vars.content.items().random();
                        canShoot = true;
                    } else {
                        Item item = this.items.take();
                        if (item != null) {
                            data.item = item;
                            canShoot = true;
                        }
                    }
                    if (canShoot) {
                        float angle = this.tile.angleTo((Position)target);
                        BurstDriver.this.tr.trns(angle, BurstDriver.this.shootY, Mathf.range((float)BurstDriver.this.xRand));
                        PMBullets.burstDriverOrb.create((Entityc)this, this.team, this.x + BurstDriver.this.tr.x, this.y + BurstDriver.this.tr.y, angle, -1.0f, BurstDriver.this.speed, BurstDriver.this.lifetime, (Object)data);
                        BurstDriver.this.shootEffect.at(this.x + BurstDriver.this.tr.x, this.y + BurstDriver.this.tr.y, angle);
                        BurstDriver.this.smokeEffect.at(this.x + BurstDriver.this.tr.x, this.y + BurstDriver.this.tr.y, angle);
                        Effect.shake((float)BurstDriver.this.shake, (float)BurstDriver.this.shake, (Position)this);
                        BurstDriver.this.shootSound.at((Position)this.tile, Mathf.random((float)0.9f, (float)1.1f));
                        this.curRecoil = 1.0f;
                    }
                });
            }
        }

        public void handleBurstItem(Bullet bullet, BurstDriverData data) {
            int maxAdd = Math.min(1, BurstDriver.this.itemCapacity * 2 - this.items.total());
            this.items.add(data.item, maxAdd);
            this.dump(data.item);
            Effect.shake((float)BurstDriver.this.shake, (float)BurstDriver.this.shake, (Position)this);
            BurstDriver.this.receiveEffect.at((Position)bullet);
            this.reloadCounter = 1.0f;
            this.curRecoil = 1.0f;
            bullet.remove();
        }

        protected boolean shooterValid(Tile other) {
            if (other == null) {
                return true;
            }
            Building building = other.build;
            if (!(building instanceof BurstDriverBuild)) {
                return false;
            }
            BurstDriverBuild entity = (BurstDriverBuild)building;
            return entity.link == this.tile.pos() && this.tile.dst((Position)other) <= BurstDriver.this.range;
        }

        protected boolean linkValid() {
            if (this.link == -1) {
                return false;
            }
            Building link = Vars.world.build(this.link);
            return link instanceof BurstDriverBuild && link.team == this.team && this.within((Position)link, BurstDriver.this.range);
        }

        public Point2 config() {
            return Point2.unpack((int)this.link).sub((int)this.tile.x, (int)this.tile.y);
        }

        public boolean sandy() {
            return false;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.rotation);
            write.b((int)((byte)this.state.ordinal()));
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.rotation = read.f();
            this.state = MassDriver.DriverState.all[read.b()];
        }
    }

    public class BurstDriverData
    implements Pool.Poolable {
        public BurstDriverBuild from;
        public BurstDriverBuild to;
        public Item item;

        public void reset() {
            this.from = null;
            this.to = null;
        }
    }
}

