/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.distribution;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.graphics.Drawf;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.meta.BuildVisibility;
import progressed.world.blocks.distribution.BurstDriver;

public class SandDriver
extends BurstDriver {
    public TextureRegion baseRainbow;
    public TextureRegion rainbow;

    public SandDriver(String name) {
        super(name);
        this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.empty);
        this.alwaysUnlocked = true;
    }

    @Override
    public void load() {
        super.load();
        this.baseRainbow = Core.atlas.find(this.name + "-base-rainbow");
        this.rainbow = Core.atlas.find(this.name + "-rainbow");
    }

    public class SandDriverBuild
    extends BurstDriver.BurstDriverBuild {
        @Override
        public void draw() {
            Draw.rect((TextureRegion)SandDriver.this.baseRegion, (float)this.x, (float)this.y);
            float speed = (float)Core.settings.getInt("pm-strobespeed") / 2.0f;
            Draw.color((Color)Tmp.c1.set(Color.red).shiftHue(Time.time * speed));
            Draw.rect((TextureRegion)SandDriver.this.baseRainbow, (float)this.x, (float)this.y);
            Draw.color();
            Draw.z((float)50.0f);
            SandDriver.this.recoilOffset.trns(this.rotation, -this.curRecoil);
            Drawf.shadow((TextureRegion)SandDriver.this.region, (float)(this.x + SandDriver.this.recoilOffset.x - SandDriver.this.elevation), (float)(this.y + SandDriver.this.recoilOffset.y - SandDriver.this.elevation), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)SandDriver.this.region, (float)(this.x + SandDriver.this.recoilOffset.x), (float)(this.y + SandDriver.this.recoilOffset.y), (float)(this.rotation - 90.0f));
            Draw.color((Color)Tmp.c1.set(Color.red).shiftHue(Time.time * speed));
            Draw.rect((TextureRegion)SandDriver.this.rainbow, (float)(this.x + SandDriver.this.recoilOffset.x), (float)(this.y + SandDriver.this.recoilOffset.y), (float)(this.rotation - 90.0f));
            Draw.color();
        }

        @Override
        public boolean sandy() {
            return true;
        }
    }
}

