/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.payloads;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.logic.LAccess;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import progressed.world.blocks.payloads.Missile;
import progressed.world.meta.PMStat;
import progressed.world.meta.PMStatValues;

public class Sentry
extends Missile {
    public UnitType unit;

    public Sentry(String name) {
        super(name);
        this.rotate = true;
        this.configurable = true;
        this.breakSound = this.destroySound = Sounds.none;
    }

    @Override
    public void init() {
        super.init();
        this.health = (int)this.unit.health;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(PMStat.sentry, s -> {
            s.defaults().left().top();
            s.add((CharSequence)this.unit.localizedName);
            PMStatValues.infoButton(s, (UnlockableContent)this.unit, 32.0f);
        });
    }

    @Override
    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.unit.fullIcon};
    }

    public void onUnlock() {
        super.onUnlock();
        this.unit.unlock();
    }

    public void drawPlanRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.unit.fullIcon, (float)req.drawx(), (float)req.drawy(), (float)((float)(req.rotation * 90) - 90.0f));
    }

    public void drawBase(Tile tile) {
        if (tile.build != null) {
            tile.build.draw();
        }
    }

    public class SentryBuild
    extends Missile.MissileBuild {
        public Unit unitDrawer;
        public boolean activated;

        public Building create(Block block, Team team) {
            Building b = super.create(block, team);
            this.unitDrawer = Sentry.this.unit.create(team);
            this.unitDrawer.elevation = 0.0f;
            this.unitDrawer.set(this.x, this.y);
            this.unitDrawer.rotation(this.drawRot() + 90.0f);
            return b;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.unitDrawer.rotation(this.drawRot() + 90.0f);
        }

        public void remove() {
            super.remove();
            if (this.activated) {
                return;
            }
            this.unitDrawer.remove();
        }

        public void updateTile() {
            super.updateTile();
            if (this.activated) {
                return;
            }
            this.unitDrawer.health(this.health);
        }

        @Override
        public void draw() {
            this.unitDrawer.set(this.x, this.y);
            this.unitDrawer.rotation(this.drawRot() + 90.0f);
            Draw.z((float)28.5f);
            Drawf.shadow((TextureRegion)Sentry.this.unit.fullIcon, (float)(this.x - Sentry.this.elevation), (float)(this.y - Sentry.this.elevation), (float)this.drawRot());
            Draw.z((float)30.0f);
            this.unitDrawer.draw();
        }

        public float drawRot() {
            if (this.isPayload()) {
                return 0.0f;
            }
            return this.rotdeg() - 90.0f;
        }

        @Override
        public void drawCracks() {
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.enabled && !Mathf.zero((float)((float)p1))) {
                this.spawn();
            }
            super.control(type, p1, p2, p3, p4);
        }

        public void buildConfiguration(Table table) {
            Table cont = new Table();
            cont.defaults().size(40.0f);
            ImageButton button = (ImageButton)cont.button(Tex.whiteui, Styles.clearTogglei, 24.0f, this::spawn).get();
            button.getStyle().imageUp = Icon.upload;
            table.add((Element)cont);
        }

        public void spawn() {
            if (!this.activated) {
                this.unitDrawer.add();
                this.activated = true;
                this.kill();
            }
        }

        public void onDestroyed() {
            if (!this.activated) {
                Damage.dynamicExplosion((float)this.x, (float)this.y, (float)0.0f, (float)(this.block.baseExplosiveness * 3.5f), (float)0.0f, (float)((float)(8 * this.block.size) / 2.0f), (boolean)Vars.state.rules.damageExplosions, (Effect)this.block.destroyEffect);
                if (!this.floor().solid && !this.floor().isLiquid) {
                    Effect.rubble((float)this.x, (float)this.y, (int)this.block.size);
                }
            }
            if (Sentry.this.explosionBullet != null) {
                this.explode();
            }
        }
    }
}

