/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.storage;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import progressed.content.effects.OtherFx;
import progressed.graphics.PMDrawf;

public class CoreLink
extends Block {
    public float activationDelay = 60.0f;
    public float portalRad = -1.0f;
    public float innerRadScl = 0.75f;
    public int clouds;
    public float minCloudSize = 1.0f;
    public float maxCloudSize = 1.0f;
    public Effect activationEffect = OtherFx.linkActivation;

    public CoreLink(String name) {
        super(name);
        this.hasItems = true;
        this.solid = true;
        this.update = true;
        this.destructible = true;
        this.separateItemCapacity = true;
        this.group = BlockGroup.transportation;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.storage});
        this.envEnabled = -1;
        this.canOverdrive = false;
    }

    public void init() {
        super.init();
        if (this.portalRad < 0.0f) {
            this.portalRad = (float)(this.size * 8) / 2.0f * 0.625f;
        }
    }

    protected TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.teamRegion.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[2];
            textureRegionArray2[0] = this.region;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[1] = this.teamRegions[Team.sharded.id];
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[1];
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[0] = this.region;
        }
        return textureRegionArray;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
    }

    public boolean outputsItems() {
        return false;
    }

    public class LinkBuild
    extends Building {
        public Building linkedCore;
        public boolean activated;
        public boolean usePower;
        public float activationTime;

        public void created() {
            super.created();
            this.linkedCore = this.team.core();
            if (this.linkedCore != null) {
                this.items = this.linkedCore.items;
            }
        }

        public void updateTile() {
            ConsumePower cPower;
            if (this.linkedCore == null) {
                this.linkedCore = this.team.core();
            }
            if (this.linkedCore != null) {
                this.items = this.linkedCore.items;
            }
            if ((cPower = (ConsumePower)CoreLink.this.findConsumer(c -> c instanceof ConsumePower)) != null) {
                float u = cPower.usage * Time.delta;
                this.usePower = this.power.graph.getBatteryStored() >= u || this.power.graph.getPowerBalance() >= u;
            } else {
                this.usePower = true;
            }
            this.activationTime += Time.delta * (float)Mathf.sign((boolean)this.shouldConsume());
            this.activationTime = Mathf.clamp((float)this.activationTime, (float)0.0f, (float)CoreLink.this.activationDelay);
            if (!this.activated && this.isActive()) {
                this.activated = true;
                CoreLink.this.activationEffect.at(this.x, this.y, this.team.color);
            }
            if (this.activated && !this.isActive()) {
                this.activated = false;
            }
        }

        public void draw() {
            super.draw();
            if (this.activef() > 0.01f) {
                Draw.z((float)99.9999f);
                float scl = Interp.pow2Out.apply(this.activef());
                float rad = CoreLink.this.portalRad * scl;
                Draw.color((Color)this.team.color);
                if (CoreLink.this.clouds > 0) {
                    for (int i = 0; i < CoreLink.this.clouds; ++i) {
                        float angle = Time.time * 4.0f + Mathf.randomSeed((long)((long)(this.id + i) * 37L), (float)360.0f);
                        float cRad = Mathf.randomSeed((long)((long)(this.id + i) * 52L), (float)CoreLink.this.minCloudSize, (float)CoreLink.this.maxCloudSize) * scl;
                        Tmp.v1.trns(angle, rad).add(this.x, this.y);
                        Fill.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)cRad);
                    }
                }
                PMDrawf.spinningCircle(this.id, Time.time * 3.0f, Time.time, this.x, this.y, rad, 3, 60.0f, 30.0f, 20.0f, rad * 1.125f, -40.0f);
                PMDrawf.spinningCircle(this.id * 2, Time.time * 6.0f, Time.time, this.x, this.y, rad, 3, 60.0f, 20.0f, 30.0f, rad * 1.25f, -60.0f);
                Draw.color((Color)Color.black);
                Fill.circle((float)this.x, (float)this.y, (float)(rad * CoreLink.this.innerRadScl));
            }
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && this.usePower;
        }

        public boolean isActive() {
            return this.activationTime >= CoreLink.this.activationDelay;
        }

        public float activef() {
            return Mathf.clamp((float)(this.activationTime / CoreLink.this.activationDelay));
        }

        public boolean acceptItem(Building source, Item item) {
            return this.isActive() && this.linkedCore != null && this.linkedCore.acceptItem(source, item);
        }

        public void handleItem(Building source, Item item) {
            if (this.linkedCore != null) {
                if (this.linkedCore.items.get(item) >= ((CoreBlock.CoreBuild)this.linkedCore).storageCapacity && Mathf.chance((double)0.3)) {
                    Fx.coreBurn.at((Position)this);
                }
                ((CoreBlock.CoreBuild)this.linkedCore).noEffect = true;
                this.linkedCore.handleItem(source, item);
            }
        }

        public boolean canUnload() {
            return super.canUnload() && this.linkedCore != null && this.canConsume() && this.isActive();
        }

        public void itemTaken(Item item) {
            if (this.linkedCore != null) {
                this.linkedCore.itemTaken(item);
            }
        }

        public int removeStack(Item item, int amount) {
            if (this.linkedCore != null) {
                int result = super.removeStack(item, amount);
                if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                    Vars.state.rules.sector.info.handleCoreItem(item, -result);
                }
                return result;
            }
            return 0;
        }

        public int getMaximumAccepted(Item item) {
            return this.linkedCore != null ? this.linkedCore.getMaximumAccepted(item) : 0;
        }

        public int explosionItemCap() {
            return 0;
        }

        public void drawSelect() {
            if (this.linkedCore != null) {
                this.linkedCore.drawSelect();
            }
            Draw.color((Color)Pal.darkMetal, (Color)Pal.accent, (float)this.activef());
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float offset = (float)(-Math.max(this.block.size - 1, 0)) / 2.0f * 8.0f;
                Draw.rect((String)"block-select", (float)(this.x + offset * (float)p.x), (float)(this.y + offset * (float)p.y), (float)(i * 90));
            }
        }

        public boolean canPickup() {
            return false;
        }
    }
}

