/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.storage;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.graphics.BlockRenderer;
import mindustry.world.blocks.storage.CoreBlock;
import progressed.content.effects.MissileFx;

public class CrashCore
extends CoreBlock {
    public float crashHealth = -1.0f;
    public Sound explosionSound = Sounds.titanExplosion;
    public float explosionSoundPitchMin = 0.9f;
    public float explosionSoundPitchMax = 1.1f;
    public float explosionSoundVolume = 1.0f;
    public Effect landExplosion = MissileFx.missileExplosion;
    public TextureRegion squareShadow;

    public CrashCore(String name) {
        super(name);
        this.hasShadow = false;
    }

    public void init() {
        super.init();
        if (this.crashHealth < 0.0f) {
            this.crashHealth = (float)this.health / 10.0f;
        }
    }

    public void load() {
        super.load();
        this.squareShadow = Core.atlas.find("square-shadow");
    }

    protected TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.teamRegion.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[2];
            textureRegionArray2[0] = this.region;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[1] = this.teamRegions[Team.sharded.id];
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[1];
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[0] = this.region;
        }
        return textureRegionArray;
    }

    public void explode(CrashCoreBuild core) {
        this.landExplosion.at((Position)core);
        this.explosionSound.at(core.x, core.y, Mathf.random((float)this.explosionSoundPitchMin, (float)this.explosionSoundPitchMax), this.explosionSoundVolume);
        core.health = this.crashHealth;
        core.landed = true;
        core.tile.getLinkedTiles(t -> {
            float ang = core.angleTo(t.worldx(), t.worldy()) / 8.0f - 22.5f;
            for (int i = 0; i < 8; ++i) {
                if (!Mathf.chance((double)0.8f)) continue;
                Fx.coreLandDust.at(t.worldx(), t.worldy(), ang + Mathf.range((float)15.0f), Tmp.c1.set(t.floor().mapColor).mul(1.5f + Mathf.range((float)0.15f)));
            }
        });
    }

    static {
        Events.run((Object)EventType.Trigger.newGame, () -> {
            CoreBlock.CoreBuild patt1019$temp = Vars.player.bestCore();
            if (patt1019$temp instanceof CrashCoreBuild) {
                CrashCoreBuild c = (CrashCoreBuild)patt1019$temp;
                c.landed = false;
                if (Core.settings.getBool("skipcoreanimation") || Vars.state.rules.pvp) {
                    ((CrashCore)c.block).explode(c);
                }
            }
        });
    }

    public class CrashCoreBuild
    extends CoreBlock.CoreBuild {
        boolean landed;

        public CrashCoreBuild() {
            super((CoreBlock)CrashCore.this);
            this.landed = true;
        }

        public void draw() {
            if (!this.landed) {
                return;
            }
            Draw.z((float)29.0f);
            Draw.color((Color)BlockRenderer.shadowColor);
            float rad = 1.6f;
            float size = this.block.size * 8;
            Draw.rect((TextureRegion)CrashCore.this.squareShadow, (float)this.x, (float)this.y, (float)(size * rad * Draw.xscl), (float)(size * rad * Draw.yscl));
            Draw.color();
            Draw.z((float)30.0f);
            super.draw();
        }

        public void drawLight() {
            if (!this.landed) {
                return;
            }
            super.drawLight();
        }

        public void updateTile() {
            if (this.thrusterTime == 1.0f) {
                CrashCore.this.explode(this);
            }
            super.updateTile();
        }

        public void updateLaunch() {
        }

        public void drawLanding(float x, float y) {
            float fin = Vars.renderer.getLandTimeIn();
            fin = Mathf.curve((float)fin, (float)0.875f, (float)1.0f);
            float fout = 1.0f - fin;
            float scl = Scl.scl((float)4.0f) / Vars.renderer.getDisplayScale();
            float dst = 400.0f * fout;
            float ang = Mathf.randomSeed((long)this.id, (float)112.5f, (float)157.5f);
            Tmp.v1.trns(ang, dst);
            Draw.scl((float)scl);
            Draw.alpha((float)(1.0f - fout));
            Draw.rect((TextureRegion)CrashCore.this.region, (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y));
            if (CrashCore.this.teamRegions[this.team.id] == CrashCore.this.teamRegion) {
                Draw.color((Color)this.team.color);
                Draw.alpha((float)(1.0f - fout));
            }
            Draw.rect((TextureRegion)CrashCore.this.teamRegions[this.team.id], (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y));
            Draw.color();
            Draw.scl();
            Draw.reset();
        }
    }
}

