/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.draw;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.part.DrawPart;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.PayloadAmmoTurret;
import mindustry.world.draw.DrawBlock;
import progressed.graphics.PMDrawf;

public class DrawPayloadAmmo
extends DrawBlock {
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public DrawPart.PartProgress matProgress = DrawPart.PartProgress.warmup;
    public boolean materialize = true;
    public boolean fade = true;
    public float layer = 49.995f;
    public float x;
    public float y;
    public float xScl = 1.0f;
    public float yScl = 1.0f;
    public float rotation;
    public float moveX;
    public float moveY;
    public float growX;
    public float growY;
    public Seq<DrawPart.PartMove> moves = new Seq();

    public void draw(Building build) {
        PayloadAmmoTurret.PayloadTurretBuild tb = (PayloadAmmoTurret.PayloadTurretBuild)build;
        UnlockableContent pAmmo = tb.currentAmmo();
        if (pAmmo == null) {
            return;
        }
        float tProgress = tb.progress();
        DrawPart.PartParams params = DrawPart.params.set(build.warmup(), 1.0f - tProgress, 1.0f - tProgress, tb.heat, tb.curRecoil, tb.charge, tb.x + tb.recoilOffset.x, tb.y + tb.recoilOffset.y, tb.rotation);
        float prog = this.progress.getClamp(params);
        float mx = this.moveX * prog;
        float my = this.moveY * prog;
        float gx = this.xScl + this.growX * prog;
        float gy = this.yScl + this.growY * prog;
        if (this.moves.size > 0) {
            for (int i = 0; i < this.moves.size; ++i) {
                DrawPart.PartMove move = (DrawPart.PartMove)this.moves.get(i);
                float p = move.progress.getClamp(params);
                mx += move.x * p;
                my += move.y * p;
            }
        }
        Tmp.v1.set((this.x + mx) * Draw.xscl, (this.y + my) * Draw.yscl).rotateRadExact((params.rotation - 90.0f) * ((float)Math.PI / 180));
        float rx = params.x + Tmp.v1.x;
        float ry = params.y + Tmp.v1.y;
        float rot = params.rotation - 90.0f + this.rotation;
        Draw.scl((float)gx, (float)gy);
        if (this.materialize) {
            float matProg = this.matProgress.getClamp(params);
            Draw.draw((float)this.layer, () -> PMDrawf.materialize(rx, ry, pAmmo.fullIcon, tb.team.color, rot, 0.1f, matProg, -Time.time / 4.0f));
        } else {
            Draw.z((float)this.layer);
            if (this.fade) {
                Draw.alpha((float)this.matProgress.getClamp(params));
            }
            Draw.rect((TextureRegion)pAmmo.fullIcon, (float)rx, (float)ry, (float)rot);
            Draw.alpha((float)1.0f);
        }
        Draw.scl();
    }

    public void load(Block block) {
        if (!(block instanceof PayloadAmmoTurret)) {
            throw new ClassCastException("This drawer can only be used on payload ammo turrets.");
        }
    }
}

