/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.draw.DrawTurret;
import progressed.world.blocks.defence.turret.payload.SinglePayloadAmmoTurret;

public class DrawPayloadTurret
extends DrawTurret {
    public String paySuffix = "";
    public boolean drawTurret;
    public TextureRegion in;
    public TextureRegion cover;

    public DrawPayloadTurret(boolean drawTurret, String basePrefix) {
        this.drawTurret = drawTurret;
        this.basePrefix = basePrefix;
    }

    public DrawPayloadTurret(boolean drawTurret) {
        this.drawTurret = drawTurret;
    }

    public void draw(Building build) {
        SinglePayloadAmmoTurret turret = (SinglePayloadAmmoTurret)build.block;
        SinglePayloadAmmoTurret.SinglePayloadAmmoTurretBuild tb = (SinglePayloadAmmoTurret.SinglePayloadAmmoTurretBuild)build;
        Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
        for (int i = 0; i < 4; ++i) {
            if (!PayloadBlock.blends((Building)tb, (int)i)) continue;
            Draw.rect((TextureRegion)this.in, (float)tb.x, (float)tb.y, (float)(i * 90 - 180));
        }
        this.drawPayload(tb);
        Draw.z((float)35.1f);
        if (this.drawTurret) {
            Draw.rect((TextureRegion)this.top, (float)build.x, (float)build.y);
            Draw.color();
            Draw.z((float)49.5f);
            Drawf.shadow((TextureRegion)this.preview, (float)(build.x + tb.recoilOffset.x - turret.elevation), (float)(build.y + tb.recoilOffset.y - turret.elevation), (float)tb.drawrot());
            Draw.z((float)50.0f);
            this.drawTurret((Turret)turret, (Turret.TurretBuild)tb);
            this.drawHeat((Turret)turret, (Turret.TurretBuild)tb);
        } else {
            if (this.top.found()) {
                Draw.rect((TextureRegion)this.top, (float)build.x, (float)build.y);
            }
            Draw.rect((TextureRegion)turret.region, (float)build.x, (float)build.y);
            this.drawHeat((Turret)turret, (Turret.TurretBuild)tb);
            Draw.z((float)50.0f);
        }
        if (this.parts.size > 0) {
            if (this.drawTurret && this.outline.found()) {
                Draw.z((float)49.95f);
                Draw.rect((TextureRegion)this.outline, (float)(build.x + tb.recoilOffset.x), (float)(build.y + tb.recoilOffset.y), (float)tb.drawrot());
                Draw.z((float)50.0f);
            }
            float progress = tb.progress();
            DrawPart.PartParams params = DrawPart.params.set(build.warmup(), 1.0f - progress, 1.0f - progress, tb.heat, tb.curRecoil, tb.charge, tb.x + tb.recoilOffset.x, tb.y + tb.recoilOffset.y, tb.rotation);
            for (DrawPart part : this.parts) {
                part.draw(params);
            }
        }
    }

    public void drawPayload(SinglePayloadAmmoTurret.SinglePayloadAmmoTurretBuild build) {
        if (build.payload != null) {
            build.updatePayload();
            Payload p = build.payload;
            Draw.z((float)35.0f);
            Draw.scl((float)build.payloadf());
            Drawf.shadow((float)p.x(), (float)p.y(), (float)(p.size() * 2.0f));
            Draw.rect((TextureRegion)p.content().fullIcon, (float)p.x(), (float)p.y(), (float)p.rotation());
            Draw.scl();
        }
    }

    public void drawTurret(Turret block, Turret.TurretBuild build) {
        if (block.region.found()) {
            Draw.rect((TextureRegion)block.region, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
        if (this.liquid.found()) {
            Liquid toDraw = this.liquidDraw == null ? build.liquids.current() : this.liquidDraw;
            Drawf.liquid((TextureRegion)this.liquid, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)(build.liquids.get(toDraw) / block.liquidCapacity), (Color)toDraw.color.write(Tmp.c1).a(1.0f), (float)build.drawrot());
        }
        if (this.cover.found()) {
            Draw.rect((TextureRegion)this.cover, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
    }

    public void drawHeat(Turret block, Turret.TurretBuild build) {
        if (build.heat <= 1.0E-5f || !this.heat.found()) {
            return;
        }
        if (this.drawTurret) {
            Drawf.additive((TextureRegion)this.heat, (Color)block.heatColor.write(Tmp.c1).a(build.heat), (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot(), (float)50.1f);
        } else {
            Drawf.additive((TextureRegion)this.heat, (Color)block.heatColor.write(Tmp.c1).a(build.heat), (float)build.x, (float)build.y, (float)0.0f, (float)50.1f);
        }
    }

    public void load(Block block) {
        if (!(block instanceof SinglePayloadAmmoTurret)) {
            throw new ClassCastException("This drawer can only be used on single payload ammo turrets.");
        }
        super.load(block);
        this.in = Core.atlas.find(block.name + "-in", "factory-in-" + block.size + this.paySuffix);
        this.top = Core.atlas.find(block.name + "-top", this.drawTurret ? "factory-top-" + block.size + this.paySuffix : "");
        if (this.drawTurret) {
            this.cover = Core.atlas.find(block.name + "-cover");
        }
    }

    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (this.drawTurret) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[4];
            textureRegionArray2[0] = this.base;
            textureRegionArray2[1] = this.in;
            textureRegionArray2[2] = this.top;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[3] = this.preview;
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[3];
            textureRegionArray3[0] = this.base;
            textureRegionArray3[1] = this.in;
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[2] = this.preview;
        }
        return textureRegionArray;
    }
}

