/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawBlock;

public class DrawTurretModule
extends DrawBlock {
    public Seq<DrawPart> parts = new Seq();
    public Liquid liquidDraw;
    public TextureRegion base;
    public TextureRegion liquid;
    public TextureRegion top;
    public TextureRegion heat;
    public TextureRegion preview;
    public TextureRegion outline;

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        for (DrawPart part : this.parts) {
            part.getOutlines(out);
        }
        if (block.region.found() && (block.outlinedIcon <= 0 || !block.getGeneratedIcons()[block.outlinedIcon].equals(block.region))) {
            out.add((Object)block.region);
        }
    }

    public void draw(Building build) {
        Turret turret = (Turret)build.block;
        Turret.TurretBuild tb = (Turret.TurretBuild)build;
        float z = tb.isPayload() ? Draw.z() : 50.0f;
        Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
        Draw.color();
        Draw.z((float)(z - 0.5f));
        Drawf.shadow((TextureRegion)this.preview, (float)(build.x + tb.recoilOffset.x - turret.elevation), (float)(build.y + tb.recoilOffset.y - turret.elevation), (float)tb.drawrot());
        Draw.z((float)z);
        this.drawTurret(turret, tb);
        this.drawHeat(turret, tb);
        if (this.parts.size > 0) {
            if (this.outline.found()) {
                Draw.z((float)(z - 0.01f));
                Draw.rect((TextureRegion)this.outline, (float)(build.x + tb.recoilOffset.x), (float)(build.y + tb.recoilOffset.y), (float)tb.drawrot());
                Draw.z((float)z);
            }
            float progress = tb.progress();
            DrawPart.PartParams params = DrawPart.params.set(build.warmup(), 1.0f - progress, 1.0f - progress, tb.heat, tb.curRecoil, tb.charge, tb.x + tb.recoilOffset.x, tb.y + tb.recoilOffset.y, tb.rotation);
            for (DrawPart part : this.parts) {
                part.draw(params);
            }
        }
    }

    public void drawTurret(Turret block, Turret.TurretBuild build) {
        if (block.region.found()) {
            Draw.rect((TextureRegion)block.region, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
        if (this.liquid.found()) {
            Liquid toDraw = this.liquidDraw == null ? build.liquids.current() : this.liquidDraw;
            Drawf.liquid((TextureRegion)this.liquid, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)(build.liquids.get(toDraw) / block.liquidCapacity), (Color)toDraw.color.write(Tmp.c1).a(1.0f), (float)build.drawrot());
        }
        if (this.top.found()) {
            Draw.rect((TextureRegion)this.top, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
    }

    public void drawHeat(Turret block, Turret.TurretBuild build) {
        if (build.heat <= 1.0E-5f || !this.heat.found()) {
            return;
        }
        Drawf.additive((TextureRegion)this.heat, (Color)block.heatColor.write(Tmp.c1).a(build.heat), (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot(), (float)50.1f);
    }

    public void load(Block block) {
        if (!(block instanceof Turret)) {
            throw new ClassCastException("This drawer can only be used on turrets.");
        }
        this.preview = Core.atlas.find(block.name + "-preview", block.region);
        this.outline = Core.atlas.find(block.name + "-outline");
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
        this.heat = Core.atlas.find(block.name + "-heat");
        this.base = Core.atlas.find(block.name + "-base");
        for (DrawPart part : this.parts) {
            part.turretShading = true;
            part.load(block.name);
        }
        if (!this.base.found()) {
            this.base = Core.atlas.find("prog-mats-blank-" + block.size);
        }
    }

    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (this.top.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[3];
            textureRegionArray2[0] = this.base;
            textureRegionArray2[1] = this.preview;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[2] = this.top;
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[2];
            textureRegionArray3[0] = this.base;
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[1] = this.preview;
        }
        return textureRegionArray;
    }
}

