/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.meta;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import blackhole.entities.bullet.BlackHoleBulletType;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.maps.Map;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.StatValues;
import progressed.entities.bullet.PillarFieldBulletType;
import progressed.entities.bullet.TargetBulletType;
import progressed.entities.bullet.energy.MagmaBulletType;
import progressed.entities.bullet.energy.SparkingBulletType;
import progressed.entities.bullet.physical.CritBulletType;
import progressed.entities.bullet.physical.InjectorBulletType;
import progressed.entities.bullet.physical.MagnetBulletType;
import progressed.entities.bullet.unit.SentryBulletType;
import progressed.entities.bullet.unit.SignalFlareBulletType;
import progressed.type.unit.SignalFlareUnitType;
import progressed.ui.NamelessLiquidDisplay;
import progressed.util.PMUtls;
import progressed.world.blocks.crafting.FuelCrafter;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.blocks.payloads.Missile;
import progressed.world.blocks.payloads.Recipe;
import progressed.world.module.ModuleModule;

public class PMStatValues {
    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map) {
        return PMStatValues.ammo(map, 0, false);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean showUnit) {
        return PMStatValues.ammo(map, 0, showUnit);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, int indent, boolean showUnit) {
        return table -> {
            table.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean payload;
                boolean compact = t instanceof UnitType && !showUnit || indent > 0;
                boolean bl = payload = t instanceof Block || t instanceof UnitType && !showUnit;
                if (payload && t instanceof Missile) {
                    Missile m = (Missile)t;
                    if (!m.displayCampaign && Vars.state.isCampaign()) continue;
                }
                BulletType type = (BulletType)map.get((Object)t);
                if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                    PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{t, ((Weapon)type.spawnUnit.weapons.first()).bullet}), indent, false).display(table);
                    continue;
                }
                table.table(compact ? null : Styles.grayPanel, bt -> {
                    Collapser coll;
                    block50: {
                        block51: {
                            Object stype;
                            bt.left().top().defaults().padRight(3.0f).left();
                            if (!compact && !(t instanceof PowerTurret)) {
                                bt.table(title -> {
                                    if (payload) {
                                        if (t.unlockedNow()) {
                                            title.image(PMStatValues.icon(t)).size(96.0f).padRight(4.0f).right().top();
                                            title.table(n -> {
                                                n.add((CharSequence)t.localizedName);
                                                n.row();
                                                PMStatValues.infoButton(n, t, 32.0f).padTop(4.0f);
                                            }).padRight(10.0f).left().top();
                                        } else {
                                            title.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f).padRight(4.0f).right().top();
                                            title.add((CharSequence)"@pm-missing-research").left().colspan(2);
                                        }
                                    } else {
                                        title.image(PMStatValues.icon(t)).size(24.0f).padRight(4.0f).right().scaling(Scaling.fit).top();
                                        title.add((CharSequence)t.localizedName).padRight(10.0f).left().top();
                                    }
                                });
                                if (payload && !t.unlockedNow()) {
                                    return;
                                }
                                bt.row();
                            }
                            if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                                if (type instanceof BlackHoleBulletType) {
                                    stype = (BlackHoleBulletType)type;
                                    bt.add((CharSequence)Core.bundle.format("bullet.pm-continuous-splash-damage", new Object[]{Float.valueOf(stype.continuousDamage()), Float.valueOf(((BlackHoleBulletType)stype).damageRadius / 8.0f)}));
                                    PMStatValues.sep(bt, Core.bundle.format("bullet.pm-suction-radius", new Object[]{Float.valueOf(((BlackHoleBulletType)stype).suctionRadius / 8.0f)}));
                                } else if (type instanceof PillarFieldBulletType) {
                                    PillarFieldBulletType stype2 = (PillarFieldBulletType)type;
                                    bt.add((CharSequence)Core.bundle.format("bullet.pm-multi-splash", new Object[]{stype2.amount, Float.valueOf(stype2.pillar.damage), Float.valueOf(stype2.pillar.radius / 8.0f)}));
                                } else if (type instanceof MagmaBulletType) {
                                    MagmaBulletType stype3 = (MagmaBulletType)type;
                                    bt.add((CharSequence)Core.bundle.format("bullet.pm-continuous-splash-damage", new Object[]{Float.valueOf(stype3.continuousDamage()), Float.valueOf(stype3.radius / 8.0f)}));
                                } else if (type.continuousDamage() > 0.0f) {
                                    bt.add((CharSequence)(Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.continuousDamage())}) + StatUnit.perSecond.localized()));
                                } else {
                                    bt.add((CharSequence)Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.damage)}));
                                    if (type instanceof MagnetBulletType) {
                                        MagnetBulletType stype4 = (MagnetBulletType)type;
                                        PMStatValues.sep(bt, Core.bundle.format("bullet.pm-attraction-radius", new Object[]{Float.valueOf(stype4.force), Float.valueOf(stype4.attractRange / 8.0f)}));
                                    }
                                }
                            }
                            if (type instanceof CritBulletType) {
                                stype = (CritBulletType)type;
                                PMStatValues.sep(bt, Core.bundle.format("bullet.pm-crit-chance", new Object[]{(int)(stype.critChance * 100.0f)}));
                                PMStatValues.sep(bt, Core.bundle.format("bullet.pm-crit-multiplier", new Object[]{(int)stype.critMultiplier}));
                            }
                            if (type instanceof SignalFlareBulletType) {
                                stype = (SignalFlareBulletType)type;
                                UnitType patt5706$temp = ((SignalFlareBulletType)((Object)((Object)((Object)stype)))).spawn;
                                if (patt5706$temp instanceof SignalFlareUnitType) {
                                    SignalFlareUnitType u = (SignalFlareUnitType)patt5706$temp;
                                    PMStatValues.sep(bt, Core.bundle.format("bullet.pm-flare-health", new Object[]{Float.valueOf(u.health)}));
                                    PMStatValues.sep(bt, Core.bundle.format("bullet.pm-flare-attraction", new Object[]{Float.valueOf(u.attraction)}));
                                    PMStatValues.sep(bt, Core.bundle.format("bullet.pm-flare-lifetime", new Object[]{(int)(u.lifetime / 60.0f)}));
                                }
                            }
                            if (type.buildingDamageMultiplier != 1.0f) {
                                int val = (int)(type.buildingDamageMultiplier * 100.0f - 100.0f);
                                PMStatValues.sep(bt, Core.bundle.format("bullet.buildingdamage", new Object[]{PMStatValues.ammoStat(val)}));
                            }
                            if (type.rangeChange != 0.0f && !compact) {
                                PMStatValues.sep(bt, Core.bundle.format("bullet.range", new Object[]{PMStatValues.ammoStat(type.rangeChange / 8.0f)}));
                            }
                            if (type.splashDamage > 0.0f) {
                                PMStatValues.sep(bt, Core.bundle.format("bullet.splashdamage", new Object[]{(int)type.splashDamage, Strings.fixed((float)(type.splashDamageRadius / 8.0f), (int)1)}));
                            }
                            if (compact || Mathf.equal((float)type.ammoMultiplier, (float)1.0f) || !type.displayAmmoMultiplier) break block50;
                            if (!(t instanceof Turret)) break block51;
                            Turret turret = (Turret)t;
                            if (!turret.displayAmmoMultiplier) break block50;
                        }
                        PMStatValues.sep(bt, Core.bundle.format("bullet.multiplier", new Object[]{(int)type.ammoMultiplier}));
                    }
                    if (!compact && !Mathf.equal((float)type.reloadMultiplier, (float)1.0f)) {
                        int val = (int)(type.reloadMultiplier * 100.0f - 100.0f);
                        PMStatValues.sep(bt, Core.bundle.format("bullet.reload", new Object[]{PMStatValues.ammoStat(val)}));
                    }
                    if (type.knockback > 0.0f) {
                        PMStatValues.sep(bt, Core.bundle.format("bullet.knockback", new Object[]{Strings.autoFixed((float)type.knockback, (int)2)}));
                    }
                    if (type.healPercent > 0.0f) {
                        PMStatValues.sep(bt, Core.bundle.format("bullet.healpercent", new Object[]{(int)type.healPercent}));
                    }
                    if (type.pierce || type.pierceCap != -1) {
                        PMStatValues.sep(bt, type.pierceCap == -1 ? "@bullet.infinitepierce" : Core.bundle.format("bullet.pierce", new Object[]{type.pierceCap}));
                    }
                    if (type.incendAmount > 0) {
                        PMStatValues.sep(bt, "@bullet.incendiary");
                    }
                    if (type.homingPower > 0.01f) {
                        PMStatValues.sep(bt, "@bullet.homing");
                    }
                    if (type.lightning > 0) {
                        PMStatValues.sep(bt, Core.bundle.format("bullet.lightning", new Object[]{type.lightning, Float.valueOf(type.lightningDamage < 0.0f ? type.damage : type.lightningDamage)}));
                    }
                    if (type.pierceArmor) {
                        PMStatValues.sep(bt, "@bullet.armorpierce");
                    }
                    if (type.suppressionRange > 0.0f) {
                        PMStatValues.sep(bt, Core.bundle.format("bullet.suppression", new Object[]{Strings.autoFixed((float)(type.suppressionDuration / 60.0f), (int)2), Strings.fixed((float)(type.suppressionRange / 8.0f), (int)1)}));
                    }
                    if (type.status != StatusEffects.none) {
                        PMStatValues.sep(bt, (type.status.minfo.mod == null ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + (type.status.reactive ? "" : "[lightgray] ~ [stat]" + (int)(type.statusDuration / 60.0f) + "[lightgray] " + Core.bundle.get("unit.seconds")));
                    }
                    if (type instanceof PillarFieldBulletType) {
                        PillarFieldBulletType stype = (PillarFieldBulletType)type;
                        if (stype.pillar.status != StatusEffects.none) {
                            PMStatValues.sep(bt, (stype.pillar.status.minfo.mod == null ? stype.pillar.status.emoji() : "") + "[stat]" + stype.pillar.status.localizedName);
                        }
                    }
                    if (type instanceof InjectorBulletType) {
                        StatusEffect s;
                        InjectorBulletType stype = (InjectorBulletType)type;
                        InjectorBulletType.Vaccine[] v = stype.vaccines;
                        StringBuilder str = new StringBuilder();
                        str.append("[lightgray]");
                        if (v.length == 1) {
                            s = v[0].status;
                            str.append(s.minfo.mod == null ? s.emoji() : "").append("[stat]").append(s.localizedName);
                        } else if (v.length == 2) {
                            s = v[0].status;
                            str.append(s.minfo.mod == null ? s.emoji() : "").append("[stat]").append(s.localizedName).append("[] or ");
                            s = v[1].status;
                            str.append(s.minfo.mod == null ? s.emoji() : "").append("[stat]").append(s.localizedName);
                        } else if (v.length > 2) {
                            for (int i = 0; i < v.length - 1; ++i) {
                                StatusEffect s2 = v[i].status;
                                str.append(s2.minfo.mod == null ? s2.emoji() : "").append("[stat]").append(s2.localizedName).append("[], ");
                            }
                            StatusEffect s3 = v[v.length - 1].status;
                            str.append("or ").append(s3.minfo.mod == null ? s3.emoji() : "").append("[stat]").append(s3.localizedName);
                        }
                        PMStatValues.sep(bt, str.toString());
                        if (stype.nanomachines) {
                            bt.row();
                            bt.image((TextureRegion)Core.atlas.find("prog-mats-nanomachines")).padTop(8.0f).scaling(Scaling.fit);
                        }
                    }
                    if (type instanceof SentryBulletType) {
                        bt.row();
                        bt.table(ut -> {
                            ut.add((CharSequence)"@bullet.pm-sentry-spawn");
                            ut.image(PMStatValues.icon((UnlockableContent)type.despawnUnit)).size(24.0f);
                            ut.add((CharSequence)("[lightgray]" + type.despawnUnit.localizedName)).padLeft(6.0f);
                            PMStatValues.infoButton(ut, (UnlockableContent)type.despawnUnit, 32.0f).padLeft(6.0f);
                        });
                    }
                    if (type instanceof CritBulletType) {
                        CritBulletType stype = (CritBulletType)type;
                        if (stype.bouncing) {
                            PMStatValues.sep(bt, "@bullet.pm-bouncing");
                        }
                    }
                    if (type instanceof TargetBulletType) {
                        TargetBulletType stype = (TargetBulletType)type;
                        PMStatValues.sep(bt, "@bullet.pm-target");
                        if (stype.tDamage > 0.0f) {
                            PMStatValues.sep(bt, Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(stype.tDamage)})).padLeft(8.0f);
                        }
                        if (stype.tStatus != StatusEffects.none) {
                            PMStatValues.sep(bt, (stype.tStatus.minfo.mod == null ? stype.tStatus.emoji() : "") + "[stat]" + stype.tStatus.localizedName).padLeft(8.0f);
                        }
                    }
                    if (type instanceof SparkingBulletType) {
                        SparkingBulletType stype = (SparkingBulletType)type;
                        PMStatValues.sep(bt, Core.bundle.format("bullet.pm-sparking", new Object[]{Strings.autoFixed((float)(60.0f / stype.empInterval), (int)2)}));
                    }
                    if (type.intervalBullet != null) {
                        bt.row();
                        Table ic = new Table();
                        PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{t, type.intervalBullet}), indent + 1, false).display(ic);
                        coll = new Collapser(ic, true);
                        coll.setDuration(0.1f);
                        bt.table(it -> {
                            it.left().defaults().left();
                            it.add((CharSequence)Core.bundle.format("bullet.interval", new Object[]{Strings.autoFixed((float)((float)type.intervalBullets / type.bulletInterval * 60.0f), (int)2)}));
                            it.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                            }).size(8.0f).padLeft(16.0f).expandX();
                        });
                        bt.row();
                        bt.add((Element)coll);
                    }
                    if (type.fragBullet != null) {
                        bt.row();
                        Table fc = new Table();
                        PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{t, type.fragBullet}), indent + 1, false).display(fc);
                        coll = new Collapser(fc, true);
                        coll.setDuration(0.1f);
                        bt.table(ft -> {
                            ft.left().defaults().left();
                            ft.add((CharSequence)Core.bundle.format("bullet.frags", new Object[]{type.fragBullets}));
                            ft.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                            }).size(8.0f).padLeft(16.0f).expandX();
                        });
                        bt.row();
                        bt.add((Element)coll);
                    }
                }).padLeft((float)(indent * 5)).padTop(5.0f).padBottom(compact ? 0.0f : 5.0f).growX().margin(compact ? 0.0f : 10.0f);
                table.row();
            }
        };
    }

    public static StatValue statusEffect(StatusEffect effect) {
        return table -> table.add((CharSequence)((effect.minfo.mod == null ? effect.emoji() : "") + "[white]" + effect.localizedName));
    }

    public static StatValue fuelEfficiency(Floor floor, float multiplier) {
        return table -> table.stack(new Element[]{new Image(floor.uiIcon).setScaling(Scaling.fit), new Table(t -> t.top().right().add((CharSequence)((multiplier < 0.0f ? "[accent]" : "[scarlet]+") + PMUtls.stringsFixed(multiplier * 100.0f))).style((Style)Styles.outlineLabel))});
    }

    public static StatValue fuel(FuelCrafter crafter) {
        return table -> table.table(t -> {
            t.image(PMStatValues.icon((UnlockableContent)crafter.fuelItem)).size(24.0f).padRight(4.0f).right().top();
            t.add((CharSequence)crafter.fuelItem.localizedName).padRight(10.0f).left().top();
            ((Table)t.table(ft -> {
                ft.clearChildren();
                ft.left().defaults().padRight(3.0f).left();
                ft.add((CharSequence)Core.bundle.format("stat.pm-fuel.input", new Object[]{crafter.fuelPerItem}));
                PMStatValues.sep(ft, Core.bundle.format("stat.pm-fuel.use", new Object[]{crafter.fuelPerCraft}));
                PMStatValues.sep(ft, Core.bundle.format("stat.pm-fuel.capacity", new Object[]{crafter.fuelCapacity}));
                if (crafter.attribute != null) {
                    ft.row();
                    ft.table(at -> {
                        Runnable[] rebuild = new Runnable[]{null};
                        Map[] lastMap = new Map[]{null};
                        rebuild[0] = () -> {
                            at.clearChildren();
                            at.left();
                            at.add((CharSequence)"@stat.pm-fuel.affinity");
                            if (Vars.state.isGame()) {
                                Seq blocks = Vars.content.blocks().select(block -> {
                                    if (!(block instanceof Floor)) return false;
                                    Floor f = (Floor)block;
                                    if (!Vars.indexer.isBlockPresent(block)) return false;
                                    if (f.attributes.get(crafter.attribute) == 0.0f) return false;
                                    if (!f.isLiquid) return true;
                                    if (!crafter.floating) return false;
                                    return true;
                                }).as().with(s -> s.sort(f -> f.attributes.get(crafter.attribute)));
                                if (blocks.any()) {
                                    int i = 0;
                                    for (Floor block2 : blocks) {
                                        PMStatValues.fuelEfficiency(block2, block2.attributes.get(crafter.attribute) * crafter.fuelUseReduction / -100.0f).display(at);
                                        if (++i % 5 != 0) continue;
                                        at.row();
                                    }
                                } else {
                                    at.add((CharSequence)"@none.inmap");
                                }
                            } else {
                                at.add((CharSequence)"@stat.showinmap");
                            }
                        };
                        rebuild[0].run();
                        at.update(() -> {
                            Map current;
                            Map map = current = Vars.state.isGame() ? Vars.state.map : null;
                            if (current != lastMap[0]) {
                                rebuild[0].run();
                                lastMap[0] = current;
                            }
                        });
                    });
                }
            }).left().get()).background(Tex.underline);
        });
    }

    public static StatValue payloadProducts(Seq<Recipe> products) {
        return table -> {
            table.row();
            for (Recipe recipe : products) {
                table.table(Styles.grayPanel, t -> {
                    Block out = recipe.outputBlock;
                    if (Vars.state.rules.bannedBlocks.contains((Object)out)) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    if (recipe.unlocked()) {
                        if (recipe.hasInputBlock()) {
                            t.table(i -> {
                                i.left();
                                i.image(recipe.inputBlock.fullIcon).size(40.0f).left().scaling(Scaling.fit);
                                i.add((CharSequence)recipe.inputBlock.localizedName).padLeft(8.0f).left();
                                PMStatValues.infoButton(i, (UnlockableContent)recipe.inputBlock, 32.0f).padLeft(8.0f).left();
                                i.image((Drawable)Icon.right).color(Pal.darkishGray).size(40.0f).pad(8.0f).center();
                                i.image(out.fullIcon).size(40.0f).right().scaling(Scaling.fit);
                                i.add((CharSequence)out.localizedName).padLeft(8.0f).right();
                                PMStatValues.infoButton(i, (UnlockableContent)out, 32.0f).padLeft(8.0f).right();
                            }).left().padTop(5.0f).padBottom(5.0f);
                            t.row();
                            t.add((CharSequence)(Strings.autoFixed((float)(recipe.craftTime / 60.0f), (int)1) + " " + StatUnit.seconds.localized())).color(Color.lightGray).padLeft(10.0f).left();
                            if (recipe.powerUse > 0.0f) {
                                t.row();
                                t.add((CharSequence)(Strings.autoFixed((float)(recipe.powerUse * 60.0f), (int)1) + " " + StatUnit.powerSecond.localized())).color(Color.lightGray).padLeft(10.0f).left();
                            }
                            t.row();
                        } else {
                            t.image(out.uiIcon).size(40.0f).pad(10.0f).left().top();
                            t.table(info -> {
                                info.top().defaults().left();
                                info.add((CharSequence)out.localizedName);
                                PMStatValues.infoButton(info, (UnlockableContent)out, 32.0f).padLeft(8.0f).expandX();
                                info.row();
                                info.add((CharSequence)(Strings.autoFixed((float)(recipe.craftTime / 60.0f), (int)1) + " " + StatUnit.seconds.localized())).color(Color.lightGray).colspan(2);
                                if (recipe.powerUse > 0.0f) {
                                    info.row();
                                    info.add((CharSequence)(Strings.autoFixed((float)(recipe.powerUse * 60.0f), (int)1) + " " + StatUnit.powerSecond.localized())).color(Color.lightGray).colspan(2);
                                }
                            }).top();
                        }
                        if (recipe.showReqList()) {
                            t.table(req -> {
                                int i;
                                int col;
                                if (recipe.hasInputBlock()) {
                                    req.left().defaults().left();
                                } else {
                                    req.right().defaults().right();
                                }
                                int n = recipe.hasInputBlock() ? 12 : (col = recipe.powerUse > 0.0f ? 4 : 6);
                                if (recipe.itemRequirements.length > 0) {
                                    for (i = 0; i < recipe.itemRequirements.length; ++i) {
                                        if (i % col == 0) {
                                            req.row();
                                        }
                                        ItemStack stack = recipe.itemRequirements[i];
                                        req.add((Element)StatValues.displayItem((Item)stack.item, (int)stack.amount, (boolean)false)).pad(5.0f);
                                    }
                                }
                                if (recipe.liquidRequirements != null) {
                                    if (i % col == 0) {
                                        req.row();
                                    }
                                    req.add((Element)new NamelessLiquidDisplay(recipe.liquidRequirements.liquid, recipe.liquidRequirements.amount, false)).pad(5.0f);
                                }
                            }).right().top().grow().pad(10.0f);
                        }
                    } else {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f);
                        t.add((CharSequence)"@pm-missing-research");
                    }
                }).growX().pad(5.0f);
                table.row();
            }
        };
    }

    public static StatValue signalFlareHealth(float health, float attraction, float duration) {
        return table -> ((Table)table.table(ht -> {
            ht.left().defaults().padRight(3.0f).left();
            ht.add((CharSequence)Core.bundle.format("bullet.pm-flare-health", new Object[]{Float.valueOf(health)}));
            ht.row();
            ht.add((CharSequence)Core.bundle.format("bullet.pm-flare-attraction", new Object[]{Float.valueOf(attraction)}));
            ht.row();
            ht.add((CharSequence)Core.bundle.format("bullet.pm-flare-lifetime", new Object[]{(int)(duration / 60.0f)}));
        }).padTop(-9.0f).left().get()).background(Tex.underline);
    }

    public static StatValue staticDamage(float damage, float reload, StatusEffect status) {
        return table -> ((Table)table.table(t -> {
            t.left().defaults().padRight(3.0f).left();
            t.add((CharSequence)(Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(damage * 60.0f / reload)}) + StatUnit.perSecond.localized()));
            t.row();
            if (status != StatusEffects.none) {
                t.add((CharSequence)((status.minfo.mod == null ? status.emoji() : "") + "[stat]" + status.localizedName));
                t.row();
            }
        }).padTop(-9.0f).left().get()).background(Tex.underline);
    }

    public static StatValue teslaZapping(float damage, float maxTargets, StatusEffect status) {
        return table -> {
            table.row();
            ((Table)table.table(t -> {
                t.left().defaults().padRight(3.0f).left();
                t.add((CharSequence)Core.bundle.format("bullet.lightning", new Object[]{Float.valueOf(maxTargets), Float.valueOf(damage)}));
                t.row();
                if (status != StatusEffects.none) {
                    t.add((CharSequence)((status.minfo.mod == null ? status.emoji() : "") + "[stat]" + status.localizedName));
                }
            }).padTop(-9.0f).left().get()).background(Tex.underline);
        };
    }

    public static StatValue moduleCounts(ModularTurret.ModuleGroup[] groups) {
        return table -> {
            int[] mounts = new int[]{0, 0, 0};
            for (ModularTurret.ModuleGroup group : groups) {
                int n = group.size.ordinal();
                mounts[n] = mounts[n] + group.amount();
            }
            table.row();
            table.table(t -> {
                for (int i = 0; i < 3; ++i) {
                    if (mounts[i] <= 0) continue;
                    t.add((CharSequence)ModuleModule.ModuleSize.values()[i].amount(mounts[i])).left();
                    t.row();
                }
            }).padLeft(24.0f);
        };
    }

    public static StatValue content(UnlockableContent content) {
        return table -> {
            table.row();
            table.table(t -> {
                t.image(PMStatValues.icon(content)).size(24.0f);
                t.add((CharSequence)("[lightgray]" + content.localizedName)).padLeft(6.0f);
                PMStatValues.infoButton(t, content, 32.0f).padLeft(6.0f);
            });
        };
    }

    public static Cell<TextButton> infoButton(Table table, UnlockableContent content, float size) {
        return table.button("?", Styles.flatBordert, () -> Vars.ui.content.show(content)).size(size).left().name("contentinfo");
    }

    private static Cell<Label> sep(Table table, String text) {
        table.row();
        return table.add((CharSequence)text);
    }

    private static String ammoStat(float val) {
        return (val > 0.0f ? "[stat]+" : "[negstat]") + Strings.autoFixed((float)val, (int)1);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.fullIcon;
    }
}

