/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.module;

import arc.Core;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Locale;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.ui.Bar;
import mindustry.world.modules.BlockModule;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.meta.PMStatValues;

public class ModuleModule
extends BlockModule {
    public TurretModule module;
    public ModularTurret.ModularTurretBuild parent;
    public float progress = 0.0f;
    public float hAlpha;
    public short mountNumber;
    public short lastNumber;
    public boolean highlight;
    public boolean hasPower;

    public ModuleModule(TurretModule module, boolean hasPower) {
        this.module = module;
        this.hasPower = hasPower;
    }

    public void moduleAdded(ModularTurret.ModularTurretBuild parent, short pos) {
        this.parent = parent;
        this.mountNumber = this.lastNumber = pos;
        if (this.hasPower) {
            parent.power.graph.add(this.module.build());
        }
    }

    public void highlight() {
        if (this.hAlpha > 0.001f) {
            Draw.mixcol((Color)this.parent.team.color, (float)(Mathf.absin((float)7.0f, (float)1.0f) * this.hAlpha));
            Draw.rect((TextureRegion)this.module.block().fullIcon, (float)this.module.x(), (float)this.module.y(), (float)this.module.build().drawrot());
            Draw.mixcol();
        }
    }

    public void moduleUpdate() {
        if (this.hasPower && this.module.build().power.graph != this.parent.power.graph) {
            this.module.build().power.graph.remove(this.module.build());
            this.parent.power.graph.add(this.module.build());
        }
        this.hAlpha = Mathf.approachDelta((float)this.hAlpha, (float)Mathf.num((boolean)this.highlight), (float)0.15f);
        this.progress = this.module.deployTime() > 0.0f ? Mathf.approachDelta((float)this.progress, (float)1.0f, (float)(1.0f / this.module.deployTime())) : 1.0f;
    }

    public void moduleRemoved() {
        this.parent = null;
        this.highlight = false;
        this.hAlpha = 0.0f;
        if (this.hasPower) {
            this.module.build().power.graph.remove(this.module.build());
        }
        this.module.moduleRemoved();
    }

    public void moduleDisplay(Table table) {
        table.table(t -> {
            t.left();
            t.image(this.module.icon()).scaling(Scaling.fit).size(40.0f);
            t.label(() -> this.module.name() + " (" + (this.mountNumber + 1) + ")").left().growX().padLeft(5.0f);
            PMStatValues.infoButton(t, (UnlockableContent)this.module.block(), 40.0f).left().padLeft(5.0f);
            t.button((Drawable)new TextureRegionDrawable(Icon.upload), 20.0f, () -> this.tryPickUp(this.parent)).size(40.0f).left().padLeft(5.0f).tooltip("@pm-pickup.label");
        }).growX().top();
        table.row();
        table.table(bars -> {
            bars.defaults().growX().height(18.0f).pad(4.0f);
            this.displayModuleBars((Table)bars);
        }).growX().top();
    }

    public void displayModuleBars(Table table) {
        if (this.module.listModuleBars() == null) {
            return;
        }
        for (Func<Building, Bar> bar : this.module.listModuleBars()) {
            Bar result = (Bar)bar.get((Object)this.module.build());
            if (result == null) continue;
            table.add((Element)result).growX();
            table.row();
        }
    }

    public void tryPickUp(ModularTurret.ModularTurretBuild parent) {
        if (this.canPickUp()) {
            Payloadc p = (Payloadc)Vars.player.unit();
            p.pickup(this.module.build());
            parent.removeMount(this.module);
            parent.setSelection(this.module.size());
            boolean has = parent.modules.contains(m -> m.checkSize(this.module.size()));
            parent.rebuild(true, !has, has);
        } else {
            this.showPickupFail();
        }
    }

    public boolean canPickUp() {
        Unit u = Vars.player.unit();
        if (!(u instanceof Payloadc)) {
            return false;
        }
        Payloadc p = (Payloadc)u;
        return p.canPickup(this.module.build()) && u.within(this.module.x(), this.module.y(), (float)(8 * this.module.block().size) * 1.2f);
    }

    public void showPickupFail() {
        Unit u = Vars.player.unit();
        if (!(u instanceof Payloadc)) {
            Vars.ui.showInfoToast("@pm-pickup.invalid", 2.0f);
        } else {
            Payloadc p = (Payloadc)u;
            if (!Vars.player.unit().within(this.module.x(), this.module.y(), (float)(this.module.block().size * 8) * 1.2f)) {
                Vars.ui.showInfoToast("@pm-pickup.toofar", 2.0f);
            } else if (p.payloadUsed() + (float)(this.module.block().size * this.module.block().size) * 64.0f > u.type.payloadCapacity + 0.01f) {
                Vars.ui.showInfoToast("@pm-pickup.full", 2.0f);
            }
        }
    }

    public void updatePos(ModularTurret.ModularTurretBuild parent) {
        this.parent = parent;
        if (this.mountNumber != this.lastNumber) {
            this.lastNumber = this.mountNumber;
            this.progress = 0.0f;
        }
        Vec2 offset = parent.getMountPos(this.module.size())[this.mountNumber];
        this.module.build().x = parent.x + offset.x;
        this.module.build().y = parent.y + offset.y;
    }

    public void write(Writes write) {
        write.s((int)this.mountNumber);
        write.f(this.progress);
    }

    public void read(Reads read) {
        this.mountNumber = this.lastNumber = read.s();
        this.progress = read.f();
    }

    public static enum ModuleSize {
        small,
        medium,
        large;


        public String title() {
            return Core.bundle.get("pm-size." + this.name().toLowerCase(Locale.ROOT) + ".short");
        }

        public String fullTitle() {
            return Core.bundle.get("pm-size." + this.name().toLowerCase(Locale.ROOT) + ".full");
        }

        public String amount(int amount) {
            return Core.bundle.format("pm-size." + this.name().toLowerCase(Locale.ROOT) + ".amount", new Object[]{amount});
        }
    }
}

