/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.AssemblerAI;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.CargoAI;
import mindustry.ai.types.MissileAI;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.abilities.EnergyFieldAbility;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.abilities.MoveLightningAbility;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.entities.abilities.SuppressionFieldAbility;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BombBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.EmpBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.LaserBoltBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.FlarePart;
import mindustry.entities.part.HaloPart;
import mindustry.entities.part.HoverPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.part.ShapePart;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.BuildingTetherPayloadUnit;
import mindustry.gen.Bullet;
import mindustry.gen.EntityMapping;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Sounds;
import mindustry.gen.TankUnit;
import mindustry.gen.TimedKillUnit;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.ammo.PowerAmmoType;
import mindustry.type.unit.MissileUnitType;
import mindustry.type.weapons.RepairBeamWeapon;
import mindustry.world.meta.BlockFlag;
import subvoyage.content.ost.SvSounds;
import subvoyage.core.draw.SvFx;
import subvoyage.core.draw.SvPal;
import subvoyage.core.draw.part.SpinningBlurRegionPart;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.bullet.BallisticBulletType;
import subvoyage.type.bullet.DecayingBulletType;
import subvoyage.type.shoot.ShootLeeft;
import subvoyage.type.shoot.ShootSpreadForwardBackwards;
import subvoyage.type.shoot.ShootStunt;
import subvoyage.type.shoot.ShootUpsurge;
import subvoyage.type.unit.ability.LegionfieldAbility;
import subvoyage.type.unit.ai.DefenderDroneAI;
import subvoyage.type.unit.ai.HelicopterBoostAI;
import subvoyage.type.unit.ai.OffloadDemolisherAI;
import subvoyage.type.unit.ai.StraightMissileAI;
import subvoyage.type.unit.custom.HydromechState;
import subvoyage.type.unit.custom.HydromechStateStats;
import subvoyage.type.unit.custom.HydromechWeaponStateStats;
import subvoyage.type.unit.entity.HelicopterUnitEntity;
import subvoyage.type.unit.entity.HydromechUnitEntity;
import subvoyage.type.unit.type.AtlacianUnitType;
import subvoyage.type.unit.type.HelicopterUnitType;
import subvoyage.type.unit.type.HydromechUnitType;
import subvoyage.type.unit.type.RoverUnitType;
import subvoyage.type.unit.weapon.DroneWeapon;
import subvoyage.type.unit.weapon.HydromechRepairBeam;
import subvoyage.type.unit.weapon.HydromechWeapon;

public class SvUnits {
    public static UnitType shift;
    public static UnitType distort;
    public static UnitType commute;
    public static UnitType demolish;
    public static UnitType lapetus;
    public static UnitType skath;
    public static UnitType charon;
    public static UnitType callees;
    public static UnitType ganymede;
    public static UnitType leeft;
    public static UnitType flagshi;
    public static UnitType vanguard;
    public static UnitType squadron;
    public static UnitType armada;
    public static UnitType stunt;
    public static UnitType zeal;
    public static UnitType gambit;
    public static UnitType covenant;
    public static UnitType bulker;
    public static UnitType pisun;
    public static UnitCommand boostCommand;
    public static int mapHelicopter;
    public static int mapHMech;

    public static void load() {
        SvUnits.helicopter("lapetus", "skath", "charon", "callees", "ganymede");
        SvUnits.hmech("leeft", "flagshi", "vanguard", "squadron", "armada");
        boostCommand = new UnitCommand("boost", "up", Binding.unit_command_boost, u -> new HelicopterBoostAI()){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
        shift = new AtlacianUnitType("shift"){
            {
                this.aiController = BuilderAI::new;
                this.constructor = PayloadUnit::create;
                this.isEnemy = false;
                this.coreUnitDock = true;
                this.lowAltitude = true;
                this.flying = true;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.targetPriority = -2.0f;
                this.targetable = false;
                this.hittable = false;
                this.mineWalls = true;
                this.mineFloor = true;
                this.mineSpeed = 8.0f;
                this.mineTier = 1;
                this.buildSpeed = 1.0f;
                this.drag = 0.05f;
                this.speed = 4.6f;
                this.rotateSpeed = 15.0f;
                this.accel = 0.1f;
                this.fogRadius = 0.0f;
                this.itemCapacity = 30;
                this.health = 400.0f;
                this.engineOffset = 6.5f;
                this.engineSize = 0.0f;
                this.hitSize = 8.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(4.75f, -6.0f, 2.5f, 315.0f), new UnitType.UnitEngine(5.5f, 5.0f, 2.5f, -315.0f)});
                this.ammoType = new PowerAmmoType(900.0f);
                this.weapons.add((Object)new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 3.1f;
                        this.fractionRepairSpeed = 0.06f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.targetUnits = false;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 60.0f;
                            }
                        };
                    }
                });
            }
        };
        distort = new AtlacianUnitType("distort"){
            {
                this.aiController = BuilderAI::new;
                this.constructor = PayloadUnit::create;
                this.isEnemy = false;
                this.coreUnitDock = true;
                this.lowAltitude = true;
                this.flying = true;
                this.targetPriority = -2.0f;
                this.targetable = false;
                this.hittable = false;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.mineWalls = true;
                this.mineFloor = true;
                this.itemCapacity = 60;
                this.mineSpeed = 10.0f;
                this.mineTier = 2;
                this.buildSpeed = 2.0f;
                this.drag = 0.05f;
                this.speed = 5.6f;
                this.rotateSpeed = 20.0f;
                this.accel = 0.1f;
                this.fogRadius = 0.0f;
                this.health = 600.0f;
                this.engineOffset = 6.5f;
                this.engineSize = 0.0f;
                this.hitSize = 10.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(5.0f, -7.0f, 2.5f, 315.0f), new UnitType.UnitEngine(6.0f, 3.0f, 2.5f, -315.0f)});
                this.ammoType = new PowerAmmoType(900.0f);
                this.weapons.add((Object)new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 3.3f;
                        this.fractionRepairSpeed = 0.06f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.targetUnits = false;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 60.0f;
                            }
                        };
                    }
                });
            }
        };
        commute = new AtlacianUnitType("commute"){
            {
                this.controller = u -> new BuilderAI(true, 300.0f){
                    {
                        super(arg0, arg1);
                        buildRadius = 240.0f;
                    }
                };
                this.constructor = PayloadUnit::create;
                this.isEnemy = false;
                this.coreUnitDock = true;
                this.lowAltitude = true;
                this.flying = true;
                this.targetPriority = -2.0f;
                this.targetable = false;
                this.hittable = false;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.mineWalls = true;
                this.mineFloor = true;
                this.itemCapacity = 30;
                this.mineSpeed = 5.0f;
                this.mineTier = 2;
                this.buildSpeed = 0.6f;
                this.drag = 0.05f;
                this.speed = 5.0f;
                this.rotateSpeed = 20.0f;
                this.accel = 0.1f;
                this.fogRadius = 0.0f;
                this.health = 600.0f;
                this.engineOffset = 6.5f;
                this.engineSize = 0.0f;
                this.hitSize = 10.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(7.5f, -3.0f, 3.0f, 315.0f), new UnitType.UnitEngine(5.0f, -9.0f, 3.0f, 315.0f)});
                this.ammoType = new PowerAmmoType(900.0f);
                this.weapons.add((Object)new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 3.3f;
                        this.fractionRepairSpeed = 0.06f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.targetUnits = true;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 90.0f;
                            }
                        };
                    }
                });
            }
        };
        demolish = new AtlacianUnitType("demolish"){
            {
                this.constructor = UnitEntity::create;
                this.playerControllable = false;
                this.logicControllable = false;
                this.controller = e -> new OffloadDemolisherAI();
                this.health = 855.0f;
                this.circleTarget = true;
                this.isEnemy = false;
                this.speed = 2.0f;
                this.rotateSpeed = 5.0f;
                this.omniMovement = false;
                this.faceTarget = true;
                this.rotateMoveFirst = true;
                this.lowAltitude = true;
                this.flying = true;
                this.engineSize = 2.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 20.0f;
                final float haloY = 8.0f;
                this.parts.addAll((Object[])new DrawPart[]{new ShapePart(){
                    {
                        this.circle = true;
                        this.hollow = true;
                        this.color = Pal.accent;
                        this.layer = 110.0f;
                        this.radius = 2.5f;
                        this.radiusTo = 5.0f;
                        this.stroke = 1.0f;
                        this.strokeTo = 1.5f;
                        this.y = haloY;
                    }
                }, new HaloPart(){
                    {
                        this.progress = DrawPart.PartProgress.constant((float)1.0f);
                        this.color = Pal.accent;
                        this.layer = 110.0f;
                        this.y = haloY;
                        this.haloRotateSpeed = -1.0f;
                        this.shapes = 4;
                        this.shapeRotation = 180.0f;
                        this.triLength = 0.0f;
                        this.triLengthTo = 2.0f;
                        this.haloRotation = 45.0f;
                        this.haloRadius = 2.5f;
                        this.tri = true;
                        this.radius = 1.0f;
                    }
                }, new HaloPart(){
                    {
                        this.progress = DrawPart.PartProgress.constant((float)1.0f);
                        this.color = Pal.accent;
                        this.layer = 110.0f;
                        this.y = haloY;
                        this.haloRotateSpeed = -1.0f;
                        this.shapes = 4;
                        this.shapeRotation = 180.0f;
                        this.triLength = 0.0f;
                        this.triLengthTo = 2.0f;
                        this.haloRotation = 45.0f;
                        this.haloRadius = 2.5f;
                        this.tri = true;
                        this.radius = 1.5f;
                    }
                }, new HaloPart(){
                    {
                        this.progress = DrawPart.PartProgress.constant((float)1.0f);
                        this.color = Pal.accent;
                        this.layer = 110.0f;
                        this.y = haloY;
                        this.shapes = 4;
                        this.triLength = 1.5f;
                        this.triLengthTo = 1.5f;
                        this.haloRadius = 2.8f;
                        this.haloRotation = 45.0f;
                        this.haloRotateSpeed = 2.0f;
                        this.sides = 4;
                        this.shapeRotation = 90.0f;
                        this.shapeMoveRot = 10.0f;
                        this.tri = true;
                        this.radius = 1.5f;
                    }
                }, new FlarePart(){
                    {
                        this.progress = DrawPart.PartProgress.warmup;
                        this.color1 = Pal.accent;
                        this.stroke = 3.0f;
                        this.radius = 0.0f;
                        this.radiusTo = 12.0f;
                        this.layer = 110.0f;
                        this.y = haloY;
                        this.x = 0.0f;
                        this.followRotation = true;
                        this.sides = 6;
                    }
                }});
                this.weapons.add((Object)new Weapon(){
                    ObjectMap<Unit, Float> time;
                    {
                        this.y = haloY;
                        this.x = 0.0f;
                        this.alternate = false;
                        this.mirror = false;
                        this.rotate = true;
                        this.shootWarmupSpeed = 0.005f;
                        this.minWarmup = 0.8f;
                        this.parentizeEffects = true;
                        this.bullet = new LaserBoltBulletType(1.0f, 0.0f){
                            {
                                super(arg0, arg1);
                                this.shootEffect = this.smokeEffect = Fx.none;
                            }

                            public void draw(Bullet b) {
                            }

                            public void update(Bullet b) {
                                b.remove();
                            }
                        };
                        this.time = ObjectMap.of((Object[])new Object[0]);
                    }

                    public void update(Unit unit, WeaponMount mount) {
                        super.update(unit, mount);
                        float t = ((Float)this.time.get((Object)unit, (Object)Float.valueOf(0.0f))).floatValue();
                        if (mount.warmup > 0.1f && t >= 30.0f) {
                            SvFx.shootShockwave.at(unit.x, unit.y, unit.rotation, Pal.accent, this.bullet.keepVelocity || this.parentizeEffects ? unit : null);
                            t %= 30.0f;
                        }
                        this.time.put((Object)unit, (Object)Float.valueOf(t += Time.delta));
                    }

                    protected void handleBullet(Unit unit, WeaponMount mount, Bullet bullet) {
                        super.handleBullet(unit, mount, bullet);
                        mount.warmup = 0.0f;
                    }
                });
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(4.0f, -7.0f, 1.8f, 315.0f), new UnitType.UnitEngine(7.25f, -5.0f, 1.5f, 315.0f)});
            }
        };
        lapetus = new HelicopterUnitType("lapetus"){
            {
                this.constructor = HelicopterUnitEntity::create;
                this.speed = 1.7f;
                this.rotateSpeed = 4.0f;
                this.accel = 0.1f;
                this.health = 450.0f;
                this.engineSize = 0.0f;
                this.hitSize = 16.0f;
                this.researchCostMultiplier = 0.0f;
                final float BPS = 1.0f;
                this.parts.add((Object)new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 1.0f;
                        this.yScl = 1.0f;
                        this.y = 2.0f;
                        this.rotationSpeed = 400.0f;
                    }
                });
                this.parts.add((Object)new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 0.5f;
                        this.yScl = 0.5f;
                        this.y = -5.5f;
                        this.rotationSpeed = 200.0f;
                    }
                });
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.x = 4.0f;
                        this.y = -1.75f;
                        this.reload = 60.0f;
                        this.recoil = 1.0f;
                        this.shootSound = Sounds.missileLaunch;
                        this.velocityRnd = 0.0f;
                        this.inaccuracy = 0.0f;
                        this.top = false;
                        this.alternate = false;
                        this.bullet = new BasicBulletType(3.0f, 67.32f / BPS){
                            {
                                super(arg0, arg1);
                                this.sprite = "missile-large";
                                this.width = 6.0f;
                                this.height = 13.0f;
                                this.lifetime = 40.0f;
                                this.hitSize = 6.0f;
                                this.backColor = this.trailColor = SvPal.heatGlow;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 2.0f;
                                this.trailLength = 8;
                                this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                                this.smokeEffect = SvFx.shootLauncher;
                                this.splashDamageRadius = 10.0f;
                                this.splashDamage = 25.0f;
                                this.trailEffect = SvFx.missileTrailSmokeSmall;
                                this.trailRotation = true;
                                this.trailInterval = 3.0f;
                            }
                        };
                    }
                });
            }
        };
        skath = new HelicopterUnitType("skath"){
            {
                this.constructor = HelicopterUnitEntity::create;
                this.speed = 1.6f;
                this.rotateSpeed = 3.0f;
                this.accel = 0.25f;
                this.health = 1260.0f;
                this.researchCostMultiplier = 0.0f;
                this.engineOffset = -7.5f;
                this.engineSize = 0.0f;
                this.hitSize = 20.0f;
                this.rotateMoveFirst = true;
                SpinningBlurRegionPart copter = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 1.35f;
                        this.yScl = 1.35f;
                        this.y = 4.47f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                SpinningBlurRegionPart tail = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 0.75f;
                        this.yScl = 0.75f;
                        this.y = -8.5f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                this.parts.addAll((Object[])new DrawPart[]{copter, tail});
                final float BPS = 2.24f;
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.x = 6.5f;
                        this.y = -0.25f;
                        this.reload = 160.0f;
                        this.recoil = 1.0f;
                        this.shootSound = Sounds.mediumCannon;
                        this.top = false;
                        this.alternate = true;
                        this.shoot = new ShootUpsurge();
                        this.shoot.shots = 6;
                        this.shoot.shotDelay = 15.0f;
                        this.bullet = new BasicBulletType(){
                            {
                                this.sprite = "shell";
                                this.height = 12.0f;
                                this.width = 12.0f;
                                this.maxRange = 50.0f;
                                ignoreRotation = true;
                                this.hitColor = this.trailColor = SvPal.heatGlow;
                                this.frontColor = Color.white;
                                this.trailWidth = 4.0f;
                                this.trailLength = 8;
                                this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                                this.smokeEffect = Fx.shootSmokeDisperse;
                                this.rotationOffset = 90.0f;
                                this.trailRotation = true;
                                this.trailEffect = SvFx.skathTrail;
                                this.trailChance = 0.44f;
                                this.weaveMag = 10.0f;
                                this.weaveScale = 60.0f;
                                this.weaveRandom = false;
                                this.hitSound = Sounds.plasmaboom;
                                this.backColor = SvPal.heatGlow;
                                this.mixColorFrom = SvPal.heatGlow;
                                this.mixColorTo = Color.white;
                                ejectEffect = Fx.none;
                                this.hitSize = 22.0f;
                                this.collidesAir = true;
                                this.lifetime = 30.0f;
                                this.pierce = true;
                                this.pierceCap = 1;
                                this.hitEffect = new MultiEffect(new Effect[]{Fx.blastExplosion, Fx.smokeCloud});
                                this.keepVelocity = false;
                                this.weaveMag = 2.0f;
                                this.weaveScale = 1.0f;
                                this.speed = 1.1f;
                                this.drag = -0.02f;
                                this.homingPower = 0.05f;
                                this.damage = this.splashDamage = 119.68001f / BPS;
                                this.splashDamageRadius = 20.0f;
                            }
                        };
                    }
                });
            }
        };
        charon = new HelicopterUnitType("charon"){
            {
                this.constructor = HelicopterUnitEntity::create;
                this.speed = 1.55f;
                this.rotateSpeed = 2.0f;
                this.accel = 0.45f;
                this.health = 2025.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 20.0f;
                this.engineOffset = -7.5f;
                this.engineSize = 0.0f;
                this.rotateMoveFirst = true;
                SpinningBlurRegionPart copter = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 1.5f;
                        this.yScl = 1.5f;
                        this.y = 7.0f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                SpinningBlurRegionPart tail = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 0.75f;
                        this.yScl = 0.75f;
                        this.y = -12.0f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                this.parts.addAll((Object[])new DrawPart[]{copter, tail});
                float BPS = 6.0f;
                float abilityDamage = 306.68f / BPS * 0.05f;
                final float weaponDamage = 306.68f / BPS * 0.95f;
                this.abilities.add((Object)new MoveLightningAbility(abilityDamage, 8, 0.1f, 22.0f, 1.0f, 2.0f, SvPal.heatGlow));
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.top = false;
                        this.alternate = false;
                        this.x = 0.0f;
                        this.shootY = 13.0f;
                        this.reload = 10.0f;
                        this.recoil = 2.0f;
                        this.shootSound = Sounds.bolt;
                        this.shoot = new ShootBarrel(){
                            {
                                this.barrels = new float[]{-4.0f, 1.0f, -10.0f, -2.0f, 0.5f, 10.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.5f, -10.0f, 4.0f, 1.0f, 10.0f};
                            }
                        };
                        this.bullet = new RailBulletType(){
                            {
                                this.length = 80.0f;
                                this.damage = weaponDamage;
                                this.hitColor = SvPal.heatGlow;
                                this.hitEffect = this.endEffect = Fx.hitBulletColor;
                                this.pierceDamageFactor = 1.05f;
                                this.pointEffectSpace = 60.0f;
                                this.smokeEffect = Fx.colorSpark;
                                this.endEffect = new Effect(14.0f, e -> {
                                    Draw.color((Color)e.color);
                                    Draw.z((float)100.0f);
                                    Drawf.tri((float)e.x, (float)e.y, (float)(e.fout() * 1.5f), (float)5.0f, (float)e.rotation);
                                });
                                this.shootEffect = new Effect(10.0f, e -> {
                                    Draw.color((Color)e.color);
                                    Draw.z((float)100.0f);
                                    float w = 1.2f + 7.0f * e.fout();
                                    Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(30.0f * e.fout()), (float)e.rotation);
                                    Draw.color((Color)e.color);
                                    for (int i : Mathf.signs) {
                                        Drawf.tri((float)e.x, (float)e.y, (float)(w * 0.9f), (float)(18.0f * e.fout()), (float)(e.rotation + (float)i * 90.0f));
                                    }
                                    Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(4.0f * e.fout()), (float)(e.rotation + 180.0f));
                                });
                                this.lineEffect = new Effect(20.0f, e -> {
                                    Object patt23202$temp = e.data;
                                    if (!(patt23202$temp instanceof Vec2)) {
                                        return;
                                    }
                                    Vec2 v = (Vec2)patt23202$temp;
                                    Draw.z((float)100.0f);
                                    Draw.color((Color)e.color);
                                    Lines.stroke((float)(e.fout() * 1.5f + 1.0f));
                                    Fx.rand.setSeed((long)e.id);
                                    for (int i = 0; i < 7; ++i) {
                                        Fx.v.trns(e.rotation, Fx.rand.random(8.0f, v.dst(e.x, e.y) - 8.0f));
                                        Lines.lineAngleCenter((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(e.rotation + e.finpow()), (float)(e.foutpowdown() * 20.0f * Fx.rand.random(0.5f, 1.0f) + 0.3f));
                                    }
                                    e.scaled(14.0f, b -> {
                                        Lines.stroke((float)(b.fout() * 3.0f));
                                        Draw.color((Color)e.color);
                                        Lines.line((float)e.x, (float)e.y, (float)v.x, (float)v.y);
                                    });
                                });
                            }
                        };
                    }
                });
            }
        };
        callees = new HelicopterUnitType("callees"){
            {
                this.constructor = HelicopterUnitEntity::create;
                this.speed = 1.4f;
                this.rotateSpeed = 2.0f;
                this.researchCostMultiplier = 0.0f;
                this.accel = 0.45f;
                this.health = 7200.0f;
                this.engineOffset = -7.5f;
                this.engineSize = 0.0f;
                this.hitSize = 45.0f;
                this.rotateMoveFirst = true;
                SpinningBlurRegionPart copter = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 2.0f;
                        this.yScl = 2.0f;
                        this.y = 2.0f;
                        this.rotationSpeed = 400.0f;
                        this.mirror = true;
                        this.x = 16.0f;
                    }
                };
                SpinningBlurRegionPart tail = new SpinningBlurRegionPart(){
                    {
                        this.layer = 90.0f;
                        this.xScl = 1.25f;
                        this.yScl = 1.25f;
                        this.y = -18.0f;
                        this.rotationSpeed = 800.0f;
                    }
                };
                this.parts.addAll((Object[])new DrawPart[]{copter, tail});
                this.abilities.add((Object)new ShieldArcAbility(){
                    {
                        this.radius = hitSize;
                        this.regen = 0.1f;
                        this.max = 200.0f;
                        this.cooldown = 600.0f;
                        this.angle = 80.0f;
                        this.angleOffset = 100.0f;
                        this.whenShooting = true;
                        this.width = 10.0f;
                    }
                }, (Object)new ShieldArcAbility(){
                    {
                        this.radius = hitSize;
                        this.regen = 0.1f;
                        this.max = 200.0f;
                        this.cooldown = 600.0f;
                        this.angle = 80.0f;
                        this.angleOffset = -100.0f;
                        this.whenShooting = true;
                        this.width = 10.0f;
                    }
                });
                this.trailLength = 20;
                this.trailScl = 1.9f;
                float BPS = 4.0f;
                final float bulletDamage = 680.68005f / BPS;
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.top = true;
                        this.reload = 90.0f;
                        this.recoil = 2.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.0f;
                        this.rotationLimit = 0.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 5.0f;
                        this.shootSound = SvSounds.poweredMissileShoot;
                        this.bullet = new BasicBulletType(4.0f, bulletDamage * 0.2f){
                            {
                                super(arg0, arg1);
                                this.knockback = 4.0f;
                                this.width = 25.0f;
                                this.hitSize = 20.0f;
                                this.height = 20.0f;
                                this.sprite = "shell";
                                this.shootEffect = Fx.shootBigColor;
                                this.smokeEffect = Fx.shootSmokeSquareSparse;
                                this.ammoMultiplier = 1.0f;
                                this.backColor = this.trailColor = SvPal.heatGlow;
                                this.hitColor = this.trailColor;
                                this.frontColor = SvPal.heatGlow;
                                this.trailWidth = 8.0f;
                                this.trailLength = 10;
                                this.trailInterp = Interp.fade;
                                this.hitEffect = this.despawnEffect = Fx.hitSquaresColor;
                                this.buildingDamageMultiplier = 0.2f;
                                this.fragBullets = 1;
                                this.fragVelocityMax = 0.0f;
                                this.fragRandomSpread = 0.0f;
                                this.fragSpread = 0.0f;
                                this.fragVelocityMin = 0.0f;
                                this.pierce = true;
                                this.fragBullet = new ExplosionBulletType(bulletDamage * 0.75f, 50.0f){
                                    {
                                        super(arg0, arg1);
                                        this.collidesAir = true;
                                        this.suppressionRange = 10.0f;
                                        this.killShooter = false;
                                        this.despawnSound = SvSounds.flashExplosion;
                                        this.despawnEffect = new MultiEffect(new Effect[]{(Effect)SvFx.colorRadExplosion.get((Object)new Object[]{SvPal.heatGlow, Float.valueOf(50.0f)}), new ExplosionEffect(){
                                            {
                                                this.lifetime = 50.0f;
                                                this.waveStroke = 5.0f;
                                                this.waveLife = 8.0f;
                                                this.waveColor = Color.white;
                                                this.sparkColor = this.smokeColor = SvPal.heatGlow;
                                                this.waveRad = 35.0f;
                                                this.smokeSize = 4.0f;
                                                this.smokes = 7;
                                                this.smokeSizeBase = 0.0f;
                                                this.sparks = 10;
                                                this.sparkRad = 40.0f;
                                                this.sparkLen = 6.0f;
                                                this.sparkStroke = 2.0f;
                                            }
                                        }});
                                    }
                                };
                                this.lifetime = 40.0f;
                            }
                        };
                        this.shoot = new ShootSpreadForwardBackwards(6, 5.0f);
                    }
                });
            }
        };
        ganymede = new HelicopterUnitType("ganymede"){
            {
                this.constructor = HelicopterUnitEntity::create;
                this.speed = 1.3f;
                this.rotateSpeed = 1.0f;
                this.accel = 0.45f;
                this.health = 14400.0f;
                this.researchCostMultiplier = 0.0f;
                this.lowAltitude = false;
                this.engineOffset = -7.5f;
                this.engineSize = 0.0f;
                this.hitSize = 64.0f;
                SpinningBlurRegionPart copter = new SpinningBlurRegionPart(){
                    {
                        this.mirror = true;
                        this.layer = 115.0f;
                        this.xScl = 2.0f;
                        this.yScl = 2.0f;
                        this.x = 24.0f;
                        this.y = 0.0f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                SpinningBlurRegionPart tail = new SpinningBlurRegionPart(){
                    {
                        this.layer = 115.0f;
                        this.xScl = 1.5f;
                        this.yScl = 1.5f;
                        this.y = -27.0f;
                        this.rotationSpeed = 400.0f;
                    }
                };
                final float orbRad = 10.0f;
                final float partRad = 3.0f;
                final int pa = 10;
                this.abilities.add((Object)new SuppressionFieldAbility(){
                    {
                        this.orbRadius = orbRad;
                        this.particleSize = partRad;
                        this.y = 13.0f;
                        this.particles = pa;
                        this.color = SvPal.heatGlow;
                        this.particleColor = Pal.lightOrange.cpy();
                        this.layer = 74.5f;
                    }
                });
                this.parts.add((Object)copter, (Object)tail);
                float mainWeaponBPS = 1.5f;
                final float mainWeaponDamage = 673.2f / mainWeaponBPS;
                float subWeaponBPS = 6.0f;
                final float subWeaponDamage = 224.40001f / subWeaponBPS;
                this.trailLength = 20;
                this.trailScl = 1.9f;
                this.weapons.add((Object)new Weapon(this.name + "-big-weapon"){
                    {
                        super(arg0);
                        this.mirror = false;
                        this.shootY = 4.0f;
                        this.rotate = false;
                        this.x = 0.0f;
                        this.y = 33.0f;
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.y = 0.0f;
                                this.x = 8.0f;
                            }
                        });
                        this.targetInterval = 20.0f;
                        this.targetSwitchInterval = 35.0f;
                        this.rotateSpeed = 3.5f;
                        this.reload = 240.0f;
                        this.recoil = 1.0f;
                        this.shootSound = SvSounds.poweredMissileShoot;
                        this.bullet = new BasicBulletType(5.0f, mainWeaponDamage * 0.1f){
                            {
                                super(arg0, arg1);
                                this.sprite = "circle-bullet";
                                this.backColor = SvPal.heatGlow;
                                this.frontColor = Color.white;
                                this.height = 10.0f;
                                this.width = 10.0f;
                                this.shrinkY = 0.0f;
                                this.trailLength = 20;
                                this.trailWidth = 7.0f;
                                this.trailColor = SvPal.heatGlow;
                                this.trailInterval = 3.0f;
                                shake = 5.0f;
                                this.fragBullets = 5;
                                this.fragBullet = new BulletType(){
                                    {
                                        this.shootEffect = Fx.sparkShoot;
                                        this.smokeEffect = Fx.shootSmokeTitan;
                                        this.hitColor = Pal.suppress;
                                        shake = 1.0f;
                                        this.speed = 0.0f;
                                        this.keepVelocity = false;
                                        this.collidesAir = true;
                                        this.spawnUnit = new MissileUnitType("ganymede-missile"){
                                            {
                                                super(arg0);
                                                this.outlineColor = Pal.darkOutline;
                                                trailRotation = true;
                                                this.targetAir = true;
                                                this.physics = true;
                                                this.lowAltitude = true;
                                                this.lifetime = 20.0f;
                                                hitEffect = despawnEffect = Fx.blastExplosion;
                                                smokeEffect = SvFx.shootLauncher;
                                                trailEffect = SvFx.missileTrailSmokeSmall;
                                                trailInterval = 3.0f;
                                                trailWidth = 1.0f;
                                                this.trailLength = 6;
                                                this.speed = 4.6f;
                                                this.maxRange = 3.0f;
                                                this.health = 40.0f;
                                                this.homingDelay = 5.0f;
                                                this.engineSize = 3.0f;
                                                this.engineColor = this.trailColor = SvPal.heatGlow;
                                                hitColor = this.trailColor;
                                                this.engineLayer = 110.0f;
                                                this.deathExplosionEffect = Fx.none;
                                                this.loopSoundVolume = 0.1f;
                                                this.weapons.add((Object)new Weapon(){
                                                    {
                                                        this.shootCone = 360.0f;
                                                        this.mirror = false;
                                                        this.reload = 1.0f;
                                                        this.shootOnDeath = true;
                                                        this.bullet = new EmpBulletType(){
                                                            {
                                                                float rad = 24.0f;
                                                                this.fragBullets = 1;
                                                                this.fragBullet = new EmpBulletType(){
                                                                    {
                                                                        float rad = 32.0f;
                                                                        this.scaleLife = true;
                                                                        this.lightOpacity = 0.7f;
                                                                        this.unitDamageScl = 1.1f;
                                                                        this.healPercent = 0.2f;
                                                                        this.timeIncrease = 3.0f;
                                                                        this.timeDuration = 1200.0f;
                                                                        this.powerDamageScl = 1.1f;
                                                                        this.damage = mainWeaponDamage * 0.5f;
                                                                        this.hitColor = this.lightColor = SvPal.heatGlow;
                                                                        this.lightRadius = 32.0f;
                                                                        clipSize = 40.0f;
                                                                        this.shootEffect = new Effect(40.0f, e -> {
                                                                            Draw.color((Color)SvPal.heatGlow);
                                                                            Lines.stroke((float)(e.fout() * 1.6f));
                                                                            Angles.randLenVectors((long)e.id, (int)18, (float)(e.finpow() * 27.0f), (float)e.rotation, (float)360.0f, (x, y) -> {
                                                                                float ang = Mathf.angle((float)x, (float)y);
                                                                                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 6.0f + 1.0f));
                                                                            });
                                                                        });
                                                                        this.smokeEffect = Fx.shootBigSmoke2;
                                                                        this.lifetime = 30.0f;
                                                                        this.sprite = "circle-bullet";
                                                                        this.backColor = SvPal.heatGlow;
                                                                        this.frontColor = Color.white;
                                                                        this.height = 8.0f;
                                                                        this.width = 8.0f;
                                                                        this.shrinkY = 0.0f;
                                                                        this.speed = 0.0f;
                                                                        this.trailLength = 20;
                                                                        this.trailWidth = 3.0f;
                                                                        this.trailColor = SvPal.heatGlow;
                                                                        this.trailInterval = 3.0f;
                                                                        this.splashDamage = 20.0f;
                                                                        this.radius = rad;
                                                                        this.splashDamageRadius = rad;
                                                                        this.hitShake = 4.0f;
                                                                        this.trailRotation = true;
                                                                        this.trailInterp = Interp.fastSlow;
                                                                        this.status = StatusEffects.electrified;
                                                                        this.hitSound = Sounds.plasmaboom;
                                                                        this.trailEffect = new Effect(16.0f, e -> {
                                                                            Draw.color((Color)SvPal.heatGlow);
                                                                            for (int s : Mathf.signs) {
                                                                                Drawf.tri((float)e.x, (float)e.y, (float)4.0f, (float)(10.0f * e.fslope()), (float)(e.rotation + 90.0f * (float)s));
                                                                            }
                                                                        });
                                                                        this.hitEffect = new Effect(50.0f, 100.0f, e -> {
                                                                            e.scaled(7.0f, b -> {
                                                                                Draw.color((Color)SvPal.heatGlow, (float)b.fout());
                                                                                Fill.circle((float)e.x, (float)e.y, (float)rad);
                                                                            });
                                                                            Draw.color((Color)SvPal.heatGlow);
                                                                            Lines.stroke((float)(e.fout() * 3.0f));
                                                                            Lines.circle((float)e.x, (float)e.y, (float)rad);
                                                                            int points = 10;
                                                                            float offset = Mathf.randomSeed((long)e.id, (float)360.0f);
                                                                            for (int i = 0; i < points; ++i) {
                                                                                float angle = (float)i * 360.0f / (float)points + offset;
                                                                                Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(10.0f * e.fout()), (float)angle);
                                                                                Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(-20.0f * e.fout()), (float)angle);
                                                                            }
                                                                            Fill.circle((float)e.x, (float)e.y, (float)(12.0f * e.fout()));
                                                                            Draw.color();
                                                                            Fill.circle((float)e.x, (float)e.y, (float)(6.0f * e.fout()));
                                                                            Drawf.light((float)e.x, (float)e.y, (float)(rad * 1.6f), (Color)SvPal.heatGlow, (float)e.fout());
                                                                        });
                                                                    }
                                                                };
                                                                this.scaleLife = true;
                                                                this.lightOpacity = 0.7f;
                                                                this.unitDamageScl = 1.1f;
                                                                this.healPercent = 0.2f;
                                                                this.timeIncrease = 3.0f;
                                                                this.timeDuration = 1200.0f;
                                                                this.powerDamageScl = 1.1f;
                                                                this.damage = mainWeaponDamage * 0.4f;
                                                                this.hitColor = this.lightColor = SvPal.heatGlow;
                                                                this.lightRadius = 32.0f;
                                                                clipSize = 40.0f;
                                                                this.shootEffect = new Effect(40.0f, e -> {
                                                                    Draw.color((Color)SvPal.heatGlow);
                                                                    Lines.stroke((float)(e.fout() * 1.6f));
                                                                    Angles.randLenVectors((long)e.id, (int)18, (float)(e.finpow() * 27.0f), (float)e.rotation, (float)360.0f, (x, y) -> {
                                                                        float ang = Mathf.angle((float)x, (float)y);
                                                                        Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 6.0f + 1.0f));
                                                                    });
                                                                });
                                                                this.smokeEffect = Fx.shootBigSmoke2;
                                                                this.lifetime = 0.0f;
                                                                this.sprite = "circle-bullet";
                                                                this.backColor = SvPal.heatGlow;
                                                                this.frontColor = Color.white;
                                                                this.height = 8.0f;
                                                                this.width = 8.0f;
                                                                this.shrinkY = 0.0f;
                                                                this.speed = 0.0f;
                                                                this.trailLength = 20;
                                                                this.trailWidth = 3.0f;
                                                                this.trailColor = SvPal.heatGlow;
                                                                this.trailInterval = 3.0f;
                                                                this.splashDamage = 20.0f;
                                                                this.radius = rad;
                                                                this.splashDamageRadius = rad;
                                                                this.hitShake = 4.0f;
                                                                this.trailRotation = true;
                                                                this.trailInterp = Interp.fastSlow;
                                                                this.status = StatusEffects.electrified;
                                                                this.hitSound = SvSounds.flashExplosion;
                                                                this.trailEffect = new Effect(16.0f, e -> {
                                                                    Draw.color((Color)SvPal.heatGlow);
                                                                    for (int s : Mathf.signs) {
                                                                        Drawf.tri((float)e.x, (float)e.y, (float)4.0f, (float)(10.0f * e.fslope()), (float)(e.rotation + 90.0f * (float)s));
                                                                    }
                                                                });
                                                                this.hitEffect = new Effect(50.0f, 100.0f, e -> {
                                                                    e.scaled(7.0f, b -> {
                                                                        Draw.color((Color)SvPal.heatGlow, (float)b.fout());
                                                                        Fill.circle((float)e.x, (float)e.y, (float)rad);
                                                                    });
                                                                    Draw.color((Color)SvPal.heatGlow);
                                                                    Lines.stroke((float)(e.fout() * 3.0f));
                                                                    Lines.circle((float)e.x, (float)e.y, (float)rad);
                                                                    int points = 10;
                                                                    float offset = Mathf.randomSeed((long)e.id, (float)360.0f);
                                                                    for (int i = 0; i < points; ++i) {
                                                                        float angle = (float)i * 360.0f / (float)points + offset;
                                                                        Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(10.0f * e.fout()), (float)angle);
                                                                        Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(-20.0f * e.fout()), (float)angle);
                                                                    }
                                                                    Fill.circle((float)e.x, (float)e.y, (float)(12.0f * e.fout()));
                                                                    Draw.color();
                                                                    Fill.circle((float)e.x, (float)e.y, (float)(6.0f * e.fout()));
                                                                    Drawf.light((float)e.x, (float)e.y, (float)(rad * 1.6f), (Color)SvPal.heatGlow, (float)e.fout());
                                                                });
                                                            }
                                                        };
                                                    }
                                                });
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                });
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.top = false;
                        this.alternate = false;
                        this.x = 29.0f;
                        this.y = 16.0f;
                        this.shootX = -2.0f;
                        this.cooldownTime = 0.0f;
                        this.reload = 10.0f;
                        this.recoil = 2.0f;
                        this.rotate = false;
                        this.rotateSpeed = 0.4f;
                        this.rotationLimit = 22.0f;
                        this.shootCone = 360.0f;
                        this.shootSound = Sounds.bolt;
                        this.shoot = new ShootBarrel(){
                            {
                                this.barrels = new float[]{-4.0f, 1.0f, -10.0f, -2.0f, 0.5f, 10.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.5f, -10.0f, 4.0f, 1.0f, 10.0f};
                            }
                        };
                        this.bullet = new RailBulletType(){
                            {
                                this.length = 80.0f;
                                this.damage = subWeaponDamage;
                                this.hitColor = SvPal.heatGlow;
                                this.hitEffect = this.endEffect = Fx.hitBulletColor;
                                this.pierceDamageFactor = 1.05f;
                                this.pointEffectSpace = 60.0f;
                                this.smokeEffect = Fx.colorSpark;
                                this.endEffect = new Effect(14.0f, e -> {
                                    Draw.color((Color)e.color);
                                    Draw.z((float)100.0f);
                                    Drawf.tri((float)e.x, (float)e.y, (float)(e.fout() * 1.5f), (float)5.0f, (float)e.rotation);
                                });
                                this.shootEffect = new Effect(10.0f, e -> {
                                    Draw.color((Color)e.color);
                                    Draw.z((float)100.0f);
                                    float w = 1.2f + 7.0f * e.fout();
                                    Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(30.0f * e.fout()), (float)e.rotation);
                                    Draw.color((Color)e.color);
                                    for (int i : Mathf.signs) {
                                        Drawf.tri((float)e.x, (float)e.y, (float)(w * 0.9f), (float)(18.0f * e.fout()), (float)(e.rotation + (float)i * 90.0f));
                                    }
                                    Drawf.tri((float)e.x, (float)e.y, (float)w, (float)(4.0f * e.fout()), (float)(e.rotation + 180.0f));
                                });
                                this.lineEffect = new Effect(20.0f, e -> {
                                    Object patt45039$temp = e.data;
                                    if (!(patt45039$temp instanceof Vec2)) {
                                        return;
                                    }
                                    Vec2 v = (Vec2)patt45039$temp;
                                    Draw.z((float)100.0f);
                                    Draw.color((Color)e.color);
                                    Lines.stroke((float)(e.fout() * 1.5f + 1.0f));
                                    Fx.rand.setSeed((long)e.id);
                                    for (int i = 0; i < 7; ++i) {
                                        Fx.v.trns(e.rotation, Fx.rand.random(8.0f, v.dst(e.x, e.y) - 8.0f));
                                        Lines.lineAngleCenter((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(e.rotation + e.finpow()), (float)(e.foutpowdown() * 20.0f * Fx.rand.random(0.5f, 1.0f) + 0.3f));
                                    }
                                    e.scaled(14.0f, b -> {
                                        Lines.stroke((float)(b.fout() * 3.0f));
                                        Draw.color((Color)e.color);
                                        Lines.line((float)e.x, (float)e.y, (float)v.x, (float)v.y);
                                    });
                                });
                            }
                        };
                    }
                });
            }
        };
        leeft = new HydromechUnitType("leeft"){
            {
                this.constructor = HydromechUnitEntity::create;
                this.drag = 0.07f;
                this.rotateSpeed = 8.0f;
                this.armor = 4.0f;
                this.health = 600.0f;
                this.hitSize = 15.0f;
                this.withStates(new Object[]{HydromechState.GROUND, new HydromechStateStats(){
                    {
                        this.speed = 1.1f;
                        this.inwardsDamageMul = 1.2f;
                    }
                }, HydromechState.WATER, new HydromechStateStats(){
                    {
                        this.speed = 1.8f;
                    }
                }});
                this.bodyHeat = true;
                this.heatColor = Color.red;
                this.legCount = 4;
                this.legLength = 9.0f;
                this.legForwardScl = 0.6f;
                this.legMoveSpace = 1.4f;
                this.mechSideSway = 0.55f;
                this.mechFrontSway = 0.15f;
                this.allowLegStep = true;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 74.0f;
                this.targetAir = true;
                float BPS = 3.0f;
                final float weaponDamage = 61.199997f / BPS;
                this.weapons.add((Object)new HydromechWeapon(this.name + "-weapon"){
                    {
                        super(id);
                        this.shoot = new ShootLeeft(){
                            {
                                this.shots = 2;
                            }
                        };
                        this.reload = 40.0f;
                        this.recoil = 3.0f;
                        this.inaccuracy = 10.0f;
                        this.shootY = 0.0f;
                        this.x = 0.0f;
                        this.y = 0.25f;
                        this.top = true;
                        this.mirror = false;
                        this.shootSound = Sounds.blaster;
                        this.soundPitchMin = 0.5f;
                        this.soundPitchMax = 0.55f;
                        this.groundStat = new HydromechWeaponStateStats(){
                            {
                                this.damage = weaponDamage;
                                this.lifetime = 40.0f;
                            }
                        };
                        this.waterStat = new HydromechWeaponStateStats(){
                            {
                                this.damage = weaponDamage;
                                this.lifetime = 68.0f;
                            }
                        };
                        this.bullet = new DecayingBulletType(4.0f, weaponDamage, 2.0f){
                            {
                                super(speed, dmg, damageReduction);
                                this.shootEffect = SvFx.pulverize;
                                this.smokeEffect = Fx.none;
                                this.backColor = this.trailColor = Pal.missileYellow;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.lifetime = 40.0f;
                                this.trailWidth = 5.0f;
                                this.trailLength = 8;
                                this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                            }
                        };
                    }
                });
            }
        };
        flagshi = new HydromechUnitType("flagshi"){
            {
                this.constructor = HydromechUnitEntity::create;
                this.drag = 0.07f;
                this.rotateSpeed = 8.0f;
                this.health = 1800.0f;
                this.hitSize = 20.0f;
                this.researchCostMultiplier = 0.0f;
                this.withStates(new Object[]{HydromechState.GROUND, new HydromechStateStats(){
                    {
                        this.speed = 0.8f;
                    }
                }, HydromechState.WATER, new HydromechStateStats(){
                    {
                        this.speed = 1.6f;
                        this.inwardsDamageMul = 1.2f;
                    }
                }});
                this.bodyHeat = true;
                this.heatColor = Color.red;
                this.bodyScale = 0.9f;
                this.legGroupSize = 3;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legSplashDamage = 1.1f;
                this.legStraightness = 0.4f;
                this.legCount = 6;
                this.legLength = 15.0f;
                this.legForwardScl = 0.7f;
                this.legMoveSpace = 2.0f;
                this.rippleScale = 2.0f;
                this.stepShake = 0.1f;
                this.legExtension = -5.0f;
                this.legBaseOffset = 8.0f;
                this.allowLegStep = true;
                this.mechSideSway = 0.9f;
                this.mechFrontSway = 0.9f;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 74.0f;
                this.targetAir = true;
                this.weapons.add((Object)new HydromechRepairBeam(this.name + "-repair-weapon"){
                    {
                        super(id);
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 0.03f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.activationState = HydromechState.WATER;
                        this.targetUnits = true;
                        this.targetBuildings = false;
                        this.autoTarget = true;
                        this.controllable = false;
                        this.laserColor = Pal.heal;
                        this.healColor = Pal.heal;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 60.0f;
                            }
                        };
                    }
                });
                float BPS = 4.5f;
                final float weaponDamage = 102.0f / BPS;
                this.weapons.add((Object)new HydromechWeapon(this.name + "-weapon"){
                    {
                        super(id);
                        this.shoot = new ShootLeeft(){
                            {
                                this.shots = 3;
                            }
                        };
                        this.reload = 40.0f;
                        this.recoil = 3.0f;
                        this.inaccuracy = 10.0f;
                        this.shootY = 0.0f;
                        this.top = true;
                        this.mirror = true;
                        this.flipSprite = true;
                        this.x = 9.0f;
                        this.shootSound = Sounds.blaster;
                        this.soundPitchMin = 0.4f;
                        this.soundPitchMax = 0.45f;
                        this.sclX = 1.65f;
                        this.sclY = 1.5f;
                        this.groundStat = new HydromechWeaponStateStats(){
                            {
                                this.lifetime = 50.0f;
                                this.damage = weaponDamage;
                            }
                        };
                        this.waterStat = new HydromechWeaponStateStats(){
                            {
                                this.lifetime = 78.0f;
                                this.damage = weaponDamage * 0.85f;
                            }
                        };
                        this.bullet = new DecayingBulletType(4.0f, weaponDamage, 4.0f){
                            {
                                super(speed, dmg, damageReduction);
                                this.shootEffect = SvFx.pulverize;
                                this.smokeEffect = Fx.none;
                                this.backColor = this.trailColor = Pal.missileYellow;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.lifetime = 70.0f;
                                this.trailWidth = 6.0f;
                                this.trailLength = 8;
                                this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                            }
                        };
                    }
                });
            }
        };
        vanguard = new HydromechUnitType("vanguard"){
            {
                this.constructor = HydromechUnitEntity::create;
                this.drag = 0.14f;
                this.rotateSpeed = 5.0f;
                this.researchCostMultiplier = 0.0f;
                this.health = 3600.0f;
                this.hitSize = 20.0f;
                this.waveTrailX = 8.0f;
                this.waveTrailY = -8.0f;
                this.trailScl = 12.0f;
                this.trailLength = 25;
                this.accel = 0.4f;
                this.withStates(new Object[]{HydromechState.GROUND, new HydromechStateStats(){
                    {
                        this.speed = 0.6f;
                        this.inwardsDamageMul = 0.6f;
                    }
                }, HydromechState.WATER, new HydromechStateStats(){
                    {
                        this.speed = 0.9f;
                        this.inwardsDamageMul = 0.8f;
                    }
                }});
                this.bodyHeat = true;
                this.heatColor = Color.red;
                this.legGroupSize = 3;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legSplashDamage = 1.1f;
                this.legStraightness = 0.4f;
                this.legCount = 4;
                this.legLength = 24.0f;
                this.legForwardScl = 0.7f;
                this.legMoveSpace = 2.0f;
                this.rippleScale = 2.0f;
                this.stepShake = 0.1f;
                this.legExtension = -5.0f;
                this.legBaseOffset = 8.0f;
                this.allowLegStep = true;
                this.mechSideSway = 0.9f;
                this.mechFrontSway = 0.9f;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 74.0f;
                this.targetAir = true;
                this.parts.add((Object)new RegionPart("-rifle"){
                    {
                        super(arg0);
                        this.moveRot = 30.0f;
                        this.moveX = 1.0f;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.progress = DrawPart.PartProgress.heat;
                        this.heatColor = Color.red;
                        this.mirror = true;
                    }
                });
                float BPSWater = 0.25f;
                float BPSGround = 0.6f;
                final float waterDamage = 289.0f / BPSWater * 0.6f;
                final float groundDamage = 289.0f / BPSGround;
                this.weapons.add((Object)new HydromechWeapon(){
                    {
                        this.reload = 240.0f;
                        this.recoil = 6.0f;
                        this.inaccuracy = 0.0f;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.heatColor = Color.red;
                        this.mirror = false;
                        this.alternate = false;
                        this.top = false;
                        this.shootSound = Sounds.missileSmall;
                        this.soundPitchMin = 0.4f;
                        this.soundPitchMax = 0.25f;
                        this.activationState = HydromechState.WATER;
                        this.activationBasedDraw = true;
                        this.cooldownTime = this.reload;
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = Fx.sparkShoot;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = true;
                                this.spawnUnit = new MissileUnitType("vanguard-missile-water"){
                                    {
                                        super(arg0);
                                        this.controller = u -> new StraightMissileAI();
                                        this.constructor = () -> {
                                            TimedKillUnit u = TimedKillUnit.create();
                                            u.apply(StatusEffects.invincible, 120.0f);
                                            return u;
                                        };
                                        this.outlineColor = Pal.darkOutline;
                                        trailRotation = true;
                                        this.targetAir = true;
                                        this.physics = false;
                                        this.lowAltitude = true;
                                        this.lifetime = 60.0f;
                                        this.health = 1000.0f;
                                        this.abilities.add((Object)new ShieldArcAbility(){
                                            {
                                                this.region = "subvoyage-vanguard-missile-shield";
                                                this.whenShooting = false;
                                                this.drawArc = false;
                                                this.radius = 360.0f;
                                                this.regen = 0.6f;
                                                this.max = 2000.0f;
                                                this.y = -20.0f;
                                                this.width = 0.0f;
                                            }
                                        });
                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                        smokeEffect = SvFx.shootLauncher;
                                        trailEffect = SvFx.missileTrailSmokeSmall;
                                        trailInterval = 3.0f;
                                        trailWidth = 1.0f;
                                        this.trailLength = 6;
                                        this.speed = 4.6f;
                                        this.maxRange = 3.0f;
                                        this.health = 40.0f;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = SvPal.heatGlow;
                                        hitColor = this.trailColor;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(waterDamage, 50.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.collidesAir = true;
                                                        this.suppressionRange = 80.0f;
                                                        this.shootEffect = new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 8.0f;
                                                                this.waveColor = Color.white;
                                                                this.sparkColor = this.smokeColor = SvPal.heatGlow;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        };
                                                    }
                                                };
                                            }
                                        });
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = SvFx.missileTrailSmokeSmall;
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                    }
                                };
                            }
                        };
                    }
                });
                this.weapons.add((Object)new HydromechWeapon(){
                    {
                        this.reload = 100.0f;
                        this.recoil = 4.0f;
                        this.inaccuracy = 10.0f;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.heatColor = Color.red;
                        this.mirror = false;
                        this.alternate = false;
                        this.top = false;
                        this.shootSound = Sounds.missileSmall;
                        this.soundPitchMin = 0.4f;
                        this.soundPitchMax = 0.25f;
                        this.activationState = HydromechState.GROUND;
                        this.activationBasedDraw = true;
                        this.cooldownTime = this.reload;
                        this.bullet = new BulletType(){
                            {
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = true;
                                this.shootEffect = Fx.rocketSmokeLarge;
                                this.spawnUnit = new MissileUnitType("vanguard-missile"){
                                    {
                                        super(arg0);
                                        this.controller = u -> new StraightMissileAI();
                                        this.outlineColor = Pal.darkOutline;
                                        trailRotation = true;
                                        this.targetAir = true;
                                        this.physics = false;
                                        this.lowAltitude = true;
                                        this.lifetime = 50.0f;
                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                        smokeEffect = SvFx.shootLauncher;
                                        trailEffect = SvFx.missileTrailSmokeMedium;
                                        trailInterval = 3.0f;
                                        trailWidth = 1.0f;
                                        this.trailLength = 6;
                                        this.speed = 4.6f;
                                        this.maxRange = 3.0f;
                                        this.health = 40.0f;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = SvPal.heatGlow;
                                        hitColor = this.trailColor;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = SvFx.missileTrailSmokeMedium;
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = SvFx.hitLaserOrange;
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(groundDamage, 50.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.collidesAir = true;
                                                        this.suppressionRange = 80.0f;
                                                        this.shootEffect = new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 8.0f;
                                                                this.waveColor = Color.white;
                                                                this.sparkColor = this.smokeColor = SvPal.heatGlow;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        };
                                                    }
                                                };
                                            }
                                        });
                                    }

                                    public void draw(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.draw(unit);
                                        Draw.scl();
                                    }

                                    public void drawBody(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.drawBody(unit);
                                        Draw.scl();
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        squadron = new HydromechUnitType("squadron"){
            {
                this.constructor = HydromechUnitEntity::create;
                this.drag = 0.14f;
                this.rotateSpeed = 2.0f;
                this.health = 12000.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 32.0f;
                this.bodyScale = 0.9f;
                this.waveTrailX = 8.0f;
                this.waveTrailY = -8.0f;
                this.trailScl = 12.0f;
                this.trailLength = 25;
                this.accel = 1.0f;
                this.withStates(new Object[]{HydromechState.GROUND, new HydromechStateStats(){
                    {
                        this.speed = 0.5f;
                        this.inwardsDamageMul = 1.1f;
                    }
                }, HydromechState.WATER, new HydromechStateStats(){
                    {
                        this.speed = 0.6f;
                        this.inwardsDamageMul = 1.0f;
                    }
                }});
                float BPSWater = 3.0f;
                float BPSGround = 2.0f;
                final float damageWater = 493.0f / BPSWater;
                final float damageGround = 493.0f / BPSGround;
                this.weapons.add((Object)new HydromechWeapon(this.name + "-weapon"){
                    {
                        super(id);
                        this.activationState = HydromechState.GROUND;
                        this.activationBasedDraw = true;
                        this.warmupSpeedModifier = 0.5f;
                        this.warmupReloadModifier = 0.05f;
                        this.shootSound = SvSounds.poweredMissileShoot;
                        this.shootWarmupSpeed = 0.001f;
                        this.top = true;
                        this.heatColor = Color.red;
                        this.layerOffset = 0.015f;
                        this.bullet = new BulletType(){
                            {
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = true;
                                this.shootEffect = Fx.rocketSmokeLarge;
                                this.spawnUnit = new MissileUnitType("squadron-missile"){
                                    {
                                        super(arg0);
                                        this.controller = u -> new StraightMissileAI();
                                        this.outlineColor = SvPal.outline;
                                        trailRotation = true;
                                        this.targetAir = true;
                                        this.physics = false;
                                        this.lowAltitude = true;
                                        this.lifetime = 30.0f;
                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                        smokeEffect = SvFx.shootLauncher;
                                        trailEffect = SvFx.missileTrailSmokeMedium;
                                        trailInterval = 3.0f;
                                        trailWidth = 1.0f;
                                        this.trailLength = 6;
                                        this.speed = 4.6f;
                                        this.maxRange = 3.0f;
                                        this.health = 40.0f;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = SvPal.hydromech;
                                        hitColor = this.trailColor;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.deathSound = SvSounds.flashExplosion;
                                        this.parts.add((Object)new FlarePart(){
                                            {
                                                this.progress = DrawPart.PartProgress.constant((float)1.0f);
                                                this.y = 8.0f;
                                                this.followRotation = true;
                                                this.spinSpeed = 0.0f;
                                                this.color1 = SvPal.hydromech;
                                                this.layer = 110.0f;
                                                this.radius = 1.0f;
                                                this.radiusTo = 8.0f;
                                            }

                                            public void draw(DrawPart.PartParams params) {
                                                Draw.blend((Blending)Blending.additive);
                                                super.draw(params);
                                                Draw.blend((Blending)Blending.normal);
                                            }
                                        });
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = (Effect)SvFx.hitLaserColor.get((Object)SvPal.hydromech);
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(damageGround, 50.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.collidesAir = true;
                                                        this.suppressionRange = 80.0f;
                                                        shootSound = SvSounds.flashExplosion;
                                                        this.shootEffect = new MultiEffect(new Effect[]{(Effect)SvFx.colorRadExplosion.get((Object)new Object[]{SvPal.hydromech, Float.valueOf(50.0f)}), new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 8.0f;
                                                                this.waveColor = Color.white;
                                                                this.sparkColor = this.smokeColor = SvPal.hydromech;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        }});
                                                    }
                                                };
                                            }
                                        });
                                    }

                                    public void draw(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.draw(unit);
                                        Draw.scl();
                                    }

                                    public void drawBody(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.drawBody(unit);
                                        Draw.scl();
                                    }
                                };
                            }
                        };
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.outlineLayerOffset = -0.001f;
                                this.layerOffset = 0.01f;
                                this.outline = true;
                                this.mirror = true;
                                this.moveRot = -40.0f;
                                this.moveY = 2.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().mul(DrawPart.PartProgress.warmup.mul(1.0f).clamp());
                                this.under = false;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.reload, 1.0f, 0.0f, 0.0f));
                                this.heatColor = Color.red;
                                cooldownTime = 60.0f;
                            }
                        });
                        this.parts.add((Object)new FlarePart(){
                            {
                                this.progress = DrawPart.PartProgress.smoothReload.inv().mul(DrawPart.PartProgress.warmup.mul(1.3f).clamp());
                                this.y = 8.0f;
                                this.followRotation = true;
                                this.spinSpeed = 0.0f;
                                this.color1 = SvPal.hydromech;
                                this.layer = 110.0f;
                                this.radius = 1.0f;
                                this.radiusTo = 8.0f;
                            }

                            public void draw(DrawPart.PartParams params) {
                                Draw.blend((Blending)Blending.additive);
                                super.draw(params);
                                Draw.blend((Blending)Blending.normal);
                            }
                        });
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.warmupToHeat = true;
                        this.reload = 300.0f;
                    }
                });
                this.weapons.add((Object)new HydromechWeapon(this.name + "-weapon"){
                    {
                        super(id);
                        this.activationState = HydromechState.WATER;
                        this.activationBasedDraw = true;
                        this.warmupSpeedModifier = 0.0f;
                        this.warmupReloadModifier = 0.01f;
                        this.shootWarmupSpeed = 4.0E-4f;
                        this.shootSound = SvSounds.poweredMissileShoot;
                        this.warmupToHeat = true;
                        this.reload = 300.0f;
                        this.top = true;
                        this.heatColor = Color.red;
                        this.layerOffset = 0.015f;
                        this.bullet = new BulletType(){
                            {
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = true;
                                this.shootEffect = Fx.rocketSmokeLarge;
                                this.spawnUnit = new MissileUnitType("squadron-missile-water"){
                                    {
                                        super(arg0);
                                        this.controller = u -> new StraightMissileAI();
                                        this.outlineColor = SvPal.outline;
                                        trailRotation = true;
                                        this.targetAir = true;
                                        this.physics = false;
                                        this.lowAltitude = true;
                                        this.lifetime = 20.0f;
                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                        smokeEffect = SvFx.shootLauncher;
                                        trailEffect = SvFx.missileTrailSmokeMedium;
                                        trailInterval = 3.0f;
                                        trailWidth = 1.0f;
                                        this.trailLength = 6;
                                        this.speed = 5.0f;
                                        this.maxRange = 3.0f;
                                        this.health = 40.0f;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = SvPal.hydromech;
                                        hitColor = this.trailColor;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.deathSound = SvSounds.flashExplosion;
                                        this.parts.add((Object)new FlarePart(){
                                            {
                                                this.progress = DrawPart.PartProgress.constant((float)1.0f);
                                                this.y = 8.0f;
                                                this.followRotation = true;
                                                this.spinSpeed = 0.0f;
                                                this.color1 = SvPal.hydromech;
                                                this.layer = 110.0f;
                                                this.radius = 1.0f;
                                                this.radiusTo = 8.0f;
                                            }

                                            public void draw(DrawPart.PartParams params) {
                                                Draw.blend((Blending)Blending.additive);
                                                super.draw(params);
                                                Draw.blend((Blending)Blending.normal);
                                            }
                                        });
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = (Effect)SvFx.hitLaserColor.get((Object)SvPal.hydromech);
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(damageWater, 30.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.collidesAir = true;
                                                        this.suppressionRange = 10.0f;
                                                        shootSound = SvSounds.flashExplosion;
                                                        this.shootEffect = new MultiEffect(new Effect[]{(Effect)SvFx.colorRadExplosion.get((Object)new Object[]{SvPal.hydromech, Float.valueOf(30.0f)}), new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 8.0f;
                                                                this.waveColor = Color.white;
                                                                this.sparkColor = this.smokeColor = SvPal.hydromech;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        }});
                                                    }
                                                };
                                            }
                                        });
                                    }

                                    public void draw(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.draw(unit);
                                        Draw.scl();
                                    }

                                    public void drawBody(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.drawBody(unit);
                                        Draw.scl();
                                    }
                                };
                            }
                        };
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.outlineLayerOffset = -0.001f;
                                this.layerOffset = 0.01f;
                                this.outline = true;
                                this.mirror = true;
                                this.moveRot = -30.0f;
                                this.moveY = 2.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.inv().mul(DrawPart.PartProgress.warmup.mul(1.0f).clamp());
                                this.under = false;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.reload, 1.0f, 0.0f, 0.0f));
                                this.heatColor = Color.red;
                                cooldownTime = 60.0f;
                            }
                        });
                        this.parts.add((Object)new FlarePart(){
                            {
                                this.progress = DrawPart.PartProgress.smoothReload.inv().mul(DrawPart.PartProgress.warmup.mul(1.3f).clamp());
                                this.y = 8.0f;
                                this.followRotation = true;
                                this.spinSpeed = 0.0f;
                                this.color1 = SvPal.hydromech;
                                this.layer = 110.0f;
                                this.radius = 1.0f;
                                this.radiusTo = 8.0f;
                            }

                            public void draw(DrawPart.PartParams params) {
                                Draw.blend((Blending)Blending.additive);
                                super.draw(params);
                                Draw.blend((Blending)Blending.normal);
                            }
                        });
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 0.0f;
                    }
                });
                this.bodyHeat = true;
                this.heatColor = Color.red;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legSplashDamage = 1.1f;
                this.legStraightness = 0.2f;
                this.legCount = 6;
                this.legLength = 30.0f;
                this.legForwardScl = 2.1f;
                this.legMoveSpace = 1.0f;
                this.rippleScale = 1.2f;
                this.stepShake = 1.5f;
                this.legGroupSize = 2;
                this.legExtension = -6.0f;
                this.legBaseOffset = 15.0f;
                this.legStraightLength = 0.9f;
                this.legMaxLength = 1.2f;
                this.allowLegStep = true;
                this.mechSideSway = 0.9f;
                this.mechFrontSway = 0.9f;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 74.0f;
                this.targetAir = true;
            }
        };
        armada = new HydromechUnitType("armada"){
            {
                this.constructor = HydromechUnitEntity::create;
                this.drag = 0.14f;
                this.rotateSpeed = 2.0f;
                this.health = 21000.0f;
                this.hitSize = 32.0f;
                this.researchCostMultiplier = 0.0f;
                this.bodyScale = 0.8f;
                this.waveTrailX = 8.0f;
                this.waveTrailY = -8.0f;
                this.trailScl = 12.0f;
                this.trailLength = 25;
                this.legPhysicsLayer = false;
                this.abilities.add((Object)new ShieldArcAbility(){
                    {
                        this.region = "subvoyage-armada-shield";
                        this.radius = 42.0f;
                        this.angle = 82.0f;
                        this.regen = 0.6f;
                        this.cooldown = 480.0f;
                        this.max = 2000.0f;
                        this.y = -20.0f;
                        this.width = 6.0f;
                        this.whenShooting = false;
                    }
                });
                float BPS1 = 6.0f;
                float BPS2 = 1.5f;
                final float damage1 = 172.72f / BPS1;
                final float damage2 = 690.88f / BPS2;
                this.weapons.add((Object)new HydromechWeapon(SvUnits.leeft.name + "-weapon"){
                    {
                        super(id);
                        this.shoot = new ShootLeeft(){
                            {
                                this.shots = 2;
                            }
                        };
                        this.reload = 20.0f;
                        this.recoil = 3.0f;
                        this.inaccuracy = 10.0f;
                        this.shootY = 0.0f;
                        this.x = 16.0f;
                        this.y = 0.25f;
                        this.alternate = true;
                        this.top = true;
                        this.mirror = true;
                        this.rotate = true;
                        this.rotateSpeed = 1.5f;
                        this.shootSound = Sounds.blaster;
                        this.soundPitchMin = 0.5f;
                        this.soundPitchMax = 0.55f;
                        this.groundStat = new HydromechWeaponStateStats(){
                            {
                                this.damage = 18.0f;
                                this.lifetime = damage1;
                            }
                        };
                        this.waterStat = new HydromechWeaponStateStats(){
                            {
                                this.damage = 18.0f;
                                this.lifetime = damage1;
                            }
                        };
                        this.bullet = new BasicBulletType(4.0f, damage1){
                            {
                                super(arg0, arg1);
                                this.shootEffect = SvFx.pulverize;
                                this.smokeEffect = Fx.none;
                                this.backColor = this.trailColor = SvPal.hydromech;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.lifetime = 40.0f;
                                this.trailWidth = 5.0f;
                                this.trailLength = 8;
                                this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                            }
                        };
                    }
                });
                this.weapons.add((Object)new HydromechWeapon(this.name + "-weapon"){
                    {
                        super(id);
                        this.layerOffset = -0.001f;
                        this.x = 14.5f;
                        this.y = 2.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.4f;
                        this.warmupSpeedModifier = 0.6f;
                        this.warmupReloadModifier = 0.55f;
                        this.shootWarmupSpeed = 0.05f;
                        this.shootSound = SvSounds.poweredMissileShoot;
                        this.warmupToHeat = true;
                        this.reload = 200.0f;
                        this.top = true;
                        this.heatColor = Color.red;
                        this.bullet = new BulletType(){
                            {
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = true;
                                this.shootEffect = Fx.rocketSmokeLarge;
                                this.spawnUnit = new MissileUnitType("armada-missile"){
                                    {
                                        super(arg0);
                                        this.controller = u -> new MissileAI();
                                        this.outlineColor = SvPal.outline;
                                        trailRotation = true;
                                        this.targetAir = true;
                                        this.physics = false;
                                        this.lowAltitude = true;
                                        this.lifetime = 60.0f;
                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                        smokeEffect = SvFx.shootLauncher;
                                        trailEffect = SvFx.missileTrailSmokeMedium;
                                        trailInterval = 3.0f;
                                        trailWidth = 1.0f;
                                        this.trailLength = 6;
                                        this.speed = 4.6f;
                                        this.maxRange = 3.0f;
                                        this.health = 40.0f;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = SvPal.hydromech;
                                        hitColor = this.trailColor;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.deathSound = SvSounds.flashExplosion;
                                        this.parts.add((Object)new FlarePart(){
                                            {
                                                this.progress = DrawPart.PartProgress.constant((float)1.0f);
                                                this.y = 8.0f;
                                                this.followRotation = true;
                                                this.spinSpeed = 0.0f;
                                                this.color1 = SvPal.hydromech;
                                                this.layer = 110.0f;
                                                this.radius = 1.0f;
                                                this.radiusTo = 8.0f;
                                            }

                                            public void draw(DrawPart.PartParams params) {
                                                Draw.blend((Blending)Blending.additive);
                                                super.draw(params);
                                                Draw.blend((Blending)Blending.normal);
                                            }
                                        });
                                        this.abilities.add((Object)new MoveEffectAbility(){
                                            {
                                                this.effect = (Effect)SvFx.hitLaserColor.get((Object)SvPal.hydromech);
                                                this.rotation = 180.0f;
                                                this.y = -9.0f;
                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                this.interval = 1.5f;
                                            }
                                        });
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(damage2, 50.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.collidesAir = true;
                                                        this.suppressionRange = 80.0f;
                                                        shootSound = SvSounds.flashExplosion;
                                                        this.fragBullets = 4;
                                                        this.fragRandomSpread = 5.0f;
                                                        this.fragSpread = 90.0f;
                                                        this.fragVelocityMax = 1.0f;
                                                        this.fragVelocityMin = 1.0f;
                                                        this.fragBullet = new BulletType(){
                                                            {
                                                                this.smokeEffect = Fx.shootSmokeTitan;
                                                                this.hitColor = Pal.suppress;
                                                                shake = 1.0f;
                                                                this.speed = 0.0f;
                                                                this.keepVelocity = false;
                                                                this.collidesAir = true;
                                                                this.shootEffect = Fx.rocketSmokeLarge;
                                                                this.spawnUnit = new MissileUnitType("armada-missile-frag"){
                                                                    {
                                                                        super(arg0);
                                                                        this.controller = u -> new MissileAI();
                                                                        this.outlineColor = SvPal.outline;
                                                                        trailRotation = true;
                                                                        this.targetAir = true;
                                                                        this.physics = false;
                                                                        this.lowAltitude = true;
                                                                        this.lifetime = 15.0f;
                                                                        hitEffect = despawnEffect = Fx.blastExplosion;
                                                                        smokeEffect = SvFx.shootLauncher;
                                                                        trailEffect = SvFx.missileTrailSmokeMedium;
                                                                        trailInterval = 3.0f;
                                                                        trailWidth = 1.0f;
                                                                        this.trailLength = 6;
                                                                        this.speed = 4.6f;
                                                                        this.maxRange = 3.0f;
                                                                        this.health = 40.0f;
                                                                        this.engineSize = 3.0f;
                                                                        this.engineColor = this.trailColor = SvPal.hydromech;
                                                                        hitColor = this.trailColor;
                                                                        this.engineLayer = 110.0f;
                                                                        this.deathExplosionEffect = Fx.none;
                                                                        this.loopSoundVolume = 0.1f;
                                                                        this.deathSound = SvSounds.flashExplosion;
                                                                        this.parts.add((Object)new FlarePart(){
                                                                            {
                                                                                this.progress = DrawPart.PartProgress.constant((float)1.0f);
                                                                                this.y = 8.0f;
                                                                                this.followRotation = true;
                                                                                this.spinSpeed = 0.0f;
                                                                                this.color1 = SvPal.hydromech;
                                                                                this.layer = 110.0f;
                                                                                this.radius = 1.0f;
                                                                                this.radiusTo = 8.0f;
                                                                            }

                                                                            public void draw(DrawPart.PartParams params) {
                                                                                Draw.blend((Blending)Blending.additive);
                                                                                super.draw(params);
                                                                                Draw.blend((Blending)Blending.normal);
                                                                            }
                                                                        });
                                                                        this.abilities.add((Object)new MoveEffectAbility(){
                                                                            {
                                                                                this.effect = (Effect)SvFx.hitLaserColor.get((Object)SvPal.hydromech);
                                                                                this.rotation = 180.0f;
                                                                                this.y = -9.0f;
                                                                                this.color = Color.grays((float)0.6f).lerp(Color.white, 0.5f).a(0.4f);
                                                                                this.interval = 1.5f;
                                                                            }
                                                                        });
                                                                        this.weapons.add((Object)new Weapon(){
                                                                            {
                                                                                this.shootCone = 360.0f;
                                                                                this.mirror = false;
                                                                                this.reload = 1.0f;
                                                                                this.shootOnDeath = true;
                                                                                this.bullet = new ExplosionBulletType(damage2, 40.0f){
                                                                                    {
                                                                                        super(arg0, arg1);
                                                                                        this.collidesAir = true;
                                                                                        this.suppressionRange = 80.0f;
                                                                                        shootSound = SvSounds.flashExplosion;
                                                                                        this.shootEffect = new MultiEffect(new Effect[]{(Effect)SvFx.colorRadExplosion.get((Object)new Object[]{SvPal.hydromech, Float.valueOf(40.0f)}), new ExplosionEffect(){
                                                                                            {
                                                                                                this.lifetime = 50.0f;
                                                                                                this.waveStroke = 5.0f;
                                                                                                this.waveLife = 8.0f;
                                                                                                this.waveColor = Color.white;
                                                                                                this.sparkColor = this.smokeColor = SvPal.hydromech;
                                                                                                this.waveRad = 40.0f;
                                                                                                this.smokeSize = 4.0f;
                                                                                                this.smokes = 7;
                                                                                                this.smokeSizeBase = 0.0f;
                                                                                                this.sparks = 10;
                                                                                                this.sparkRad = 40.0f;
                                                                                                this.sparkLen = 6.0f;
                                                                                                this.sparkStroke = 2.0f;
                                                                                            }
                                                                                        }});
                                                                                    }
                                                                                };
                                                                            }
                                                                        });
                                                                    }

                                                                    public void draw(Unit unit) {
                                                                        Draw.scl((float)1.5f);
                                                                        super.draw(unit);
                                                                        Draw.scl();
                                                                    }

                                                                    public void drawBody(Unit unit) {
                                                                        Draw.scl((float)1.5f);
                                                                        super.drawBody(unit);
                                                                        Draw.scl();
                                                                    }
                                                                };
                                                            }
                                                        };
                                                        this.shootEffect = new MultiEffect(new Effect[]{(Effect)SvFx.colorRadExplosion.get((Object)new Object[]{SvPal.hydromech, Float.valueOf(50.0f)}), new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 8.0f;
                                                                this.waveColor = Color.white;
                                                                this.sparkColor = this.smokeColor = SvPal.hydromech;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        }});
                                                    }
                                                };
                                            }
                                        });
                                    }

                                    public void draw(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.draw(unit);
                                        Draw.scl();
                                    }

                                    public void drawBody(Unit unit) {
                                        Draw.scl((float)1.5f);
                                        super.drawBody(unit);
                                        Draw.scl();
                                    }
                                };
                            }
                        };
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.reload, 0.15f);
                                this.heatColor = SvPal.heatGlow;
                                this.x = 1.25f;
                                this.y = 0.0f;
                                this.moveRot = -33.0f;
                                this.moveY = -1.0f;
                                this.moveX = -1.0f;
                                this.under = true;
                                this.mirror = true;
                            }
                        });
                    }
                });
                this.accel = 1.0f;
                this.withStates(new Object[]{HydromechState.GROUND, new HydromechStateStats(){
                    {
                        this.speed = 0.5f;
                        this.inwardsDamageMul = 1.2f;
                    }
                }, HydromechState.WATER, new HydromechStateStats(){
                    {
                        this.speed = 0.7f;
                        this.inwardsDamageMul = 1.0f;
                    }
                }});
                this.bodyHeat = true;
                this.heatColor = Color.red;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legSplashDamage = 1.1f;
                this.legStraightness = 0.2f;
                this.legCount = 8;
                this.legLength = 36.0f;
                this.legForwardScl = 0.25f;
                this.legMoveSpace = 1.5f;
                this.rippleScale = 1.2f;
                this.stepShake = 1.6f;
                this.legGroupSize = 3;
                this.legExtension = -6.0f;
                this.legBaseOffset = 15.0f;
                this.legStraightLength = 0.9f;
                this.legMaxLength = 1.4f;
                this.allowLegStep = true;
                this.mechSideSway = 0.9f;
                this.mechFrontSway = 0.9f;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 76.0f;
                this.targetAir = true;
            }
        };
        stunt = new RoverUnitType("stunt"){
            {
                this.constructor = TankUnit::create;
                this.itemCapacity = 5;
                this.health = 419.99997f;
                this.armor = 1.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 12.0f;
                this.abilities.add((Object)new LegionfieldAbility(){
                    {
                        this.radius = 2.0f;
                    }
                });
                this.speed = 1.0f;
                this.treadPullOffset = 14;
                this.treadRects = new Rect[]{new Rect(-26.0f, -18.0f, 18.0f, 47.0f)};
                float BPS = 1.5f;
                final float damageMain = 45.9f / BPS * 1.0f;
                final float damageSub = 45.9f / BPS * 0.0f;
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.reload = 120.0f;
                        this.mirror = false;
                        this.linearWarmup = false;
                        this.minWarmup = 0.8f;
                        this.top = true;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.rotateSpeed = 5.0f;
                        this.shoot = new ShootStunt(){
                            {
                                this.shots = 2;
                            }
                        };
                        range = 60.0f;
                        this.bullet = new BasicBulletType(4.0f, damageSub){
                            {
                                super(arg0, arg1);
                                this.width = 12.0f;
                                this.height = 12.0f;
                                this.lifetime = 30.0f;
                                this.hitSize = 12.0f;
                                this.backColor = this.trailColor = SvPal.phosphide;
                                this.hitColor = this.trailColor;
                                this.frontColor = SvPal.spaclanium;
                                this.trailWidth = 5.0f;
                                this.trailLength = 8;
                                this.hitEffect = this.despawnEffect = Fx.trailFade;
                                this.smokeEffect = SvFx.shootLauncher;
                                this.hittable = false;
                                this.collides = false;
                                this.damage = 0.0f;
                                this.fragOnHit = true;
                                this.fragOnAbsorb = false;
                                this.fragAngle = 0.0f;
                                this.fragSpread = 0.0f;
                                this.fragRandomSpread = 0.0f;
                                this.fragVelocityMin = 0.0f;
                                this.fragVelocityMax = 0.0f;
                                this.fragLifeMin = 1.0f;
                                this.fragBullets = 1;
                                shootSound = Sounds.shootAlt;
                                this.fragBullet = new BombBulletType(damageMain, 20.0f){
                                    {
                                        super(arg0, arg1);
                                        this.width = 12.0f;
                                        this.height = 12.0f;
                                        this.sprite = "large-bomb";
                                        this.despawnEffect = new Effect(40.0f, 100.0f, e -> {
                                            int i;
                                            Draw.color((Color)SvPal.phosphide);
                                            Lines.stroke((float)(e.fout() * 2.0f));
                                            float circleRad = 4.0f + e.finpow() * 15.0f;
                                            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
                                            Draw.color((Color)SvPal.phosphide);
                                            for (i = 0; i < 4; ++i) {
                                                Drawf.tri((float)e.x, (float)e.y, (float)6.0f, (float)(20.0f * e.fout()), (float)((float)(i * 90) + e.rotation));
                                            }
                                            Draw.color();
                                            for (i = 0; i < 4; ++i) {
                                                Drawf.tri((float)e.x, (float)e.y, (float)3.0f, (float)(10.0f * e.fout()), (float)((float)(i * 90) + e.rotation));
                                            }
                                            Drawf.light((float)e.x, (float)e.y, (float)(circleRad * 1.6f), (Color)SvPal.phosphide, (float)e.fout());
                                        });
                                        this.shootEffect = Fx.none;
                                        this.smokeEffect = Fx.none;
                                        this.keepVelocity = false;
                                        shootSound = Sounds.laser;
                                        this.backColor = this.trailColor = Pal.sap.cpy().a(0.7f);
                                        this.hitColor = this.trailColor;
                                        this.frontColor = SvPal.spaclanium.cpy().a(0.7f);
                                        this.status = StatusEffects.blasted;
                                        this.statusDuration = 60.0f;
                                        this.shrinkX = 0.5f;
                                        this.shrinkY = 0.5f;
                                    }
                                };
                                this.trailEffect = SvFx.missileTrailSmokeSmall;
                                this.trailRotation = true;
                                this.trailInterval = 3.0f;
                            }
                        };
                    }
                });
            }
        };
        zeal = new RoverUnitType("zeal"){
            {
                this.constructor = TankUnit::create;
                this.itemCapacity = 5;
                this.health = 1049.9999f;
                this.armor = 2.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 18.0f;
                this.abilities.add((Object)new LegionfieldAbility(){
                    {
                        this.radius = 3.0f;
                    }
                });
                this.abilities.add((Object)new EnergyFieldAbility(10.0f, 65.0f, 40.0f){
                    {
                        super(arg0, arg1, arg2);
                        this.statusDuration = 120.0f;
                        this.maxTargets = 5;
                        this.healPercent = 0.05f;
                        this.sameTypeHealMult = 1.25f;
                        this.effectRadius = 1.0f;
                        this.y = -4.0f;
                        this.color = SvPal.spaclanium;
                    }
                });
                this.speed = 0.8f;
                this.treadPullOffset = 3;
                float BPS = 0.75f;
                final float damageMain = 122.40002f / BPS;
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.reload = 80.0f;
                        this.alternate = false;
                        this.mirror = false;
                        this.linearWarmup = false;
                        this.minWarmup = 0.3f;
                        this.shootY = 12.0f;
                        this.top = true;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.7f;
                        this.shootSound = SvSounds.rifleShoot;
                        this.bullet = new EmpBulletType(){
                            {
                                float rad = 24.0f;
                                this.scaleLife = true;
                                this.lightOpacity = 0.7f;
                                this.unitDamageScl = 1.1f;
                                this.healPercent = 0.2f;
                                this.timeIncrease = 3.0f;
                                this.timeDuration = 1200.0f;
                                this.powerDamageScl = 1.1f;
                                this.damage = damageMain;
                                this.hitColor = this.lightColor = SvPal.spaclanium;
                                this.lightRadius = 32.0f;
                                clipSize = 40.0f;
                                this.shootEffect = new Effect(40.0f, e -> {
                                    Draw.color((Color)SvPal.phosphide);
                                    Lines.stroke((float)(e.fout() * 1.6f));
                                    Angles.randLenVectors((long)e.id, (int)18, (float)(e.finpow() * 27.0f), (float)e.rotation, (float)360.0f, (x, y) -> {
                                        float ang = Mathf.angle((float)x, (float)y);
                                        Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 6.0f + 1.0f));
                                    });
                                });
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.lifetime = 15.0f;
                                this.sprite = "circle-bullet";
                                this.backColor = SvPal.phosphide;
                                this.frontColor = Color.white;
                                this.height = 8.0f;
                                this.width = 8.0f;
                                this.shrinkY = 0.0f;
                                this.speed = 4.0f;
                                this.trailLength = 20;
                                this.trailWidth = 3.0f;
                                this.trailColor = SvPal.phosphide;
                                this.trailInterval = 3.0f;
                                this.splashDamage = damageMain;
                                this.radius = rad;
                                this.splashDamageRadius = rad;
                                this.hitShake = 4.0f;
                                this.trailRotation = true;
                                this.trailInterp = Interp.fastSlow;
                                this.status = StatusEffects.electrified;
                                this.hitSound = SvSounds.flashExplosion;
                                this.trailEffect = new Effect(16.0f, e -> {
                                    Draw.color((Color)SvPal.phosphide);
                                    for (int s : Mathf.signs) {
                                        Drawf.tri((float)e.x, (float)e.y, (float)4.0f, (float)(10.0f * e.fslope()), (float)(e.rotation + 90.0f * (float)s));
                                    }
                                });
                                this.hitEffect = new Effect(50.0f, 100.0f, e -> {
                                    e.scaled(7.0f, b -> {
                                        Draw.color((Color)SvPal.phosphide, (float)b.fout());
                                        Fill.circle((float)e.x, (float)e.y, (float)rad);
                                    });
                                    Draw.color((Color)SvPal.spaclanium);
                                    Lines.stroke((float)(e.fout() * 3.0f));
                                    Lines.circle((float)e.x, (float)e.y, (float)rad);
                                    int points = 10;
                                    float offset = Mathf.randomSeed((long)e.id, (float)360.0f);
                                    for (int i = 0; i < points; ++i) {
                                        float angle = (float)i * 360.0f / (float)points + offset;
                                        Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(10.0f * e.fout()), (float)angle);
                                        Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)5.0f, (float)(-20.0f * e.fout()), (float)angle);
                                    }
                                    Fill.circle((float)e.x, (float)e.y, (float)(12.0f * e.fout()));
                                    Draw.color();
                                    Fill.circle((float)e.x, (float)e.y, (float)(6.0f * e.fout()));
                                    Drawf.light((float)e.x, (float)e.y, (float)(rad * 1.6f), (Color)SvPal.spaclanium, (float)e.fout());
                                });
                            }
                        };
                    }
                });
                this.treadRects = new Rect[]{new Rect(-35.0f, -43.0f, 17.0f, 88.0f)};
            }
        };
        gambit = new RoverUnitType("gambit"){
            {
                this.constructor = TankUnit::create;
                this.itemCapacity = 10;
                this.health = 1784.9999f;
                this.armor = 4.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 26.0f;
                this.abilities.add((Object)new LegionfieldAbility(){
                    {
                        this.radius = 4.0f;
                    }
                });
                this.speed = 0.7f;
                this.rotateSpeed = 1.8f;
                this.treadPullOffset = 3;
                this.canBoost = true;
                this.boostMultiplier = 0.7f;
                this.engineSize = 8.0f;
                this.engineOffset = 10.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(){
                    {
                        this.radius = 8.0f;
                        this.x = 0.0f;
                        this.y = 10.0f;
                    }
                }});
                float BPS = 2.0f;
                final float damageMain = 211.65002f / BPS;
                this.weapons.add((Object)new Weapon(this.name + "-weapon"){
                    {
                        super(arg0);
                        this.reload = 120.0f;
                        this.alternate = false;
                        this.mirror = false;
                        this.linearWarmup = false;
                        this.minWarmup = 0.3f;
                        this.shootY = 16.0f;
                        this.top = true;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.8f;
                        this.inaccuracy = 5.0f;
                        this.bullet = new BasicBulletType(4.0f, 0.0f){
                            {
                                super(arg0, arg1);
                                this.collides = false;
                                this.hittable = false;
                                this.lifetime = 30.0f;
                                this.fragBullets = 4;
                                this.fragVelocityMax = 1.0f;
                                this.fragVelocityMin = 1.0f;
                                this.fragSpread = 90.0f;
                                this.fragRandomSpread = 0.0f;
                                this.scaleLife = true;
                                this.height = 16.0f;
                                this.width = 16.0f;
                                this.trailLength = 8;
                                this.trailWidth = 6.0f;
                                this.hitEffect = Fx.none;
                                this.trailColor = this.hitColor = SvPal.phosphide;
                                this.backColor = this.hitColor;
                                this.frontColor = Color.white;
                                this.despawnEffect = new Effect(90.0f, 100.0f, e -> {
                                    Draw.color((Color)SvPal.phosphide);
                                    Lines.stroke((float)(e.fout() * 2.0f));
                                    float circleRad = 4.0f + e.finpow() * 30.0f;
                                    Draw.color((Color)SvPal.phosphide);
                                    for (int i = 0; i < 4; ++i) {
                                        Drawf.tri((float)e.x, (float)e.y, (float)8.0f, (float)(60.0f * Mathf.lerp((float)e.fin(), (float)0.0f, (float)(e.time > 80.0f ? (e.time - 80.0f) / 10.0f : 0.0f))), (float)((float)(i * 90) + e.rotation));
                                    }
                                    Drawf.light((float)e.x, (float)e.y, (float)(circleRad * 1.6f), (Color)SvPal.phosphide, (float)e.fout());
                                });
                                this.despawnSound = SvSounds.gambitBombCharge;
                                this.fragBullet = new BasicBulletType(){
                                    {
                                        this.height = 0.0f;
                                        this.width = 0.0f;
                                        this.maxRange = 30.0f;
                                        this.trailColor = this.hitColor = SvPal.phosphide;
                                        this.backColor = this.hitColor;
                                        this.frontColor = Color.white;
                                        this.hitSound = Sounds.plasmaboom;
                                        shootCone = 180.0f;
                                        ejectEffect = Fx.none;
                                        this.hitShake = 4.0f;
                                        this.collidesAir = false;
                                        this.lifetime = 80.0f;
                                        this.despawnSound = SvSounds.flashExplosion;
                                        this.despawnEffect = new Effect(40.0f, 100.0f, e -> {
                                            int i;
                                            Draw.color((Color)SvPal.phosphide);
                                            Lines.stroke((float)(e.fout() * 2.0f));
                                            float circleRad = 4.0f + e.finpow() * 40.0f;
                                            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
                                            Draw.color((Color)SvPal.phosphide);
                                            for (i = 0; i < 4; ++i) {
                                                Drawf.tri((float)e.x, (float)e.y, (float)6.0f, (float)(50.0f * e.fout()), (float)((float)(i * 90) + e.rotation));
                                            }
                                            Draw.color();
                                            for (i = 0; i < 4; ++i) {
                                                Drawf.tri((float)e.x, (float)e.y, (float)3.0f, (float)(30.0f * e.fout()), (float)((float)(i * 90) + e.rotation));
                                            }
                                            Drawf.light((float)e.x, (float)e.y, (float)(circleRad * 1.6f), (Color)SvPal.phosphide, (float)e.fout());
                                        });
                                        this.hitEffect = Fx.massiveExplosion;
                                        this.keepVelocity = false;
                                        this.shrinkX = 0.7f;
                                        this.shrinkInterp = Interp.pow3Out;
                                        this.speed = 0.5f;
                                        this.collides = false;
                                        this.splashDamage = damageMain;
                                        this.splashDamageRadius = 50.0f;
                                    }
                                };
                            }
                        };
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.5f;
                        this.shootSound = SvSounds.rifleShoot;
                    }
                });
                this.treadRects = new Rect[]{new Rect(-40.0f, -57.0f, 20.0f, 112.0f)};
            }
        };
        covenant = new RoverUnitType("covenant"){
            {
                this.constructor = TankUnit::create;
                this.itemCapacity = 10;
                this.health = 7559.9995f;
                this.armor = 4.0f;
                this.researchCostMultiplier = 0.0f;
                this.hitSize = 32.0f;
                this.abilities.add((Object)new LegionfieldAbility(){
                    {
                        this.radius = 6.0f;
                    }
                });
                this.speed = 0.6f;
                this.rotateSpeed = 1.6f;
                this.treadPullOffset = 3;
                float BPS = 3.0f;
                float BPS2 = 3.32f;
                final float damageMain = 305.23502f / BPS;
                final float damageSub = 130.81502f / BPS2;
                this.weapons.add((Object)new DroneWeapon(this.name + "-weapon"){
                    {
                        super(name);
                        this.reload = 600.0f;
                        this.alternate = false;
                        this.mirror = false;
                        this.linearWarmup = false;
                        this.minWarmup = 0.3f;
                        this.shootY = 8.0f;
                        this.top = true;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.layerOffset = 0.01f;
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.x = 0.0f;
                                this.y = 0.0f;
                                this.mirror = true;
                                this.outlineLayerOffset = -0.005f;
                                this.moveRot = -20.0f;
                                this.progress = DrawPart.PartProgress.reload;
                            }
                        });
                        this.rotate = true;
                        this.rotateSpeed = 0.5f;
                        this.inaccuracy = 5.0f;
                        this.drone = new AtlacianUnitType("covenant-weapon-drone"){
                            {
                                super(name);
                                this.constructor = UnitEntity::create;
                                this.hidden = true;
                                this.logicControllable = false;
                                this.playerControllable = false;
                                this.controller = u -> new DefenderDroneAI(){
                                    {
                                        this.filter = u -> u.type == covenant;
                                        this.aliveTime = 1800.0f;
                                    }
                                };
                                this.parts.add((Object)new HoverPart(){
                                    {
                                        this.x = 0.0f;
                                        this.y = -8.0f;
                                        this.mirror = false;
                                        this.radius = 6.0f;
                                        this.phase = 10.0f;
                                        this.stroke = 2.0f;
                                        this.sides = 6;
                                        this.layerOffset = -0.001f;
                                        this.color = SvPal.phosphide;
                                    }
                                });
                                this.speed = 2.7f;
                                this.accel = 0.08f;
                                this.drag = 0.04f;
                                this.flying = true;
                                this.health = 335.99997f;
                                this.engineOffset = 5.75f;
                                this.targetFlags = BlockFlag.all;
                                this.hitSize = 9.0f;
                                this.itemCapacity = 10;
                                this.weapons.add((Object)new Weapon(){
                                    {
                                        this.y = 0.0f;
                                        this.x = 0.0f;
                                        this.mirror = false;
                                        this.reload = 20.0f;
                                        this.bullet = new BasicBulletType(3.0f, damageMain){
                                            {
                                                super(arg0, arg1);
                                                this.width = 12.0f;
                                                this.height = 12.0f;
                                                this.lifetime = 30.0f;
                                                this.hitSize = 12.0f;
                                                this.backColor = this.trailColor = SvPal.phosphide;
                                                this.hitColor = this.trailColor;
                                                this.frontColor = SvPal.spaclanium;
                                                this.trailWidth = 5.0f;
                                                this.trailLength = 8;
                                                this.hitEffect = this.despawnEffect = Fx.trailFade;
                                                this.smokeEffect = SvFx.shootLauncher;
                                            }
                                        };
                                        this.shootSound = SvSounds.rifleShoot;
                                    }
                                });
                            }
                        };
                        this.bullet = new BallisticBulletType(1.0f, 0.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 120.0f;
                                this.scaleLife = true;
                                this.width = 16.0f;
                                this.height = 16.0f;
                                this.trailWidth = 2.5f;
                                this.trailLength = 8;
                                this.hitColor = this.backColor = SvPal.phosphide;
                                this.trailColor = this.backColor;
                                this.frontColor = Color.white;
                                this.collides = false;
                                this.parts.add((Object)new FlarePart(){
                                    {
                                        this.progress = DrawPart.PartProgress.life.slope().curve((Interp)Interp.pow2In);
                                        this.radius = 0.0f;
                                        this.radiusTo = 35.0f;
                                        this.stroke = 3.0f;
                                        this.rotation = 45.0f;
                                        this.y = -5.0f;
                                        this.followRotation = true;
                                    }
                                });
                                this.shootEffect = new MultiEffect(new Effect[]{Fx.shootBigColor, new Effect(9.0f, e -> {
                                    Draw.color((Color)Color.white, (Color)e.color, (float)e.fin());
                                    Lines.stroke((float)(0.7f + e.fout()));
                                    Lines.square((float)e.x, (float)e.y, (float)(e.fin() * 5.0f), (float)(e.rotation + 45.0f));
                                    Drawf.light((float)e.x, (float)e.y, (float)23.0f, (Color)e.color, (float)(e.fout() * 0.7f));
                                }), new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = SvPal.phosphide;
                                        this.sizeTo = 15.0f;
                                        this.lifetime = 12.0f;
                                        this.strokeFrom = 3.0f;
                                    }
                                }});
                                this.despawnEffect = new MultiEffect(new Effect[]{Fx.massiveExplosion, new WrapEffect(Fx.dynamicSpikes, SvPal.phosphide, 24.0f), new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = SvPal.phosphide;
                                        this.sizeTo = 40.0f;
                                        this.lifetime = 12.0f;
                                        this.strokeFrom = 4.0f;
                                    }
                                }});
                            }

                            public void despawned(Bullet b) {
                                super.despawned(b);
                                this.spawnDrone(b);
                            }
                        };
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.5f;
                        this.shootSound = SvSounds.rifleShoot;
                    }
                });
                for (final int sign : Mathf.signs) {
                    this.weapons.add((Object)new Weapon(this.name + "-weapon-small"){
                        {
                            super(arg0);
                            this.reload = 36.0f;
                            this.alternate = true;
                            this.mirror = true;
                            this.linearWarmup = false;
                            this.minWarmup = 0.3f;
                            this.x = 8.0f;
                            this.y = -2.0f + (float)sign * 8.0f;
                            this.rotate = true;
                            this.rotateSpeed = 1.0f;
                            this.inaccuracy = 5.0f;
                            this.bullet = new BasicBulletType(3.0f, damageSub){
                                {
                                    super(arg0, arg1);
                                    this.width = 12.0f;
                                    this.height = 12.0f;
                                    this.lifetime = 30.0f;
                                    this.hitSize = 12.0f;
                                    this.backColor = this.trailColor = SvPal.phosphide;
                                    this.hitColor = this.trailColor;
                                    this.frontColor = SvPal.spaclanium;
                                    this.trailWidth = 5.0f;
                                    this.trailLength = 8;
                                    this.hitEffect = this.despawnEffect = Fx.trailFade;
                                    this.smokeEffect = SvFx.shootLauncher;
                                }
                            };
                            this.shootSound = SvSounds.rifleShoot;
                        }
                    });
                }
                this.treadRects = new Rect[]{new Rect(-59.0f, -73.0f, 27.0f, 152.0f)};
            }
        };
        bulker = new AtlacianUnitType("bulker"){
            {
                this.controller = u -> new CargoAI();
                this.constructor = BuildingTetherPayloadUnit::create;
                this.isEnemy = false;
                this.allowedInPayloads = false;
                this.logicControllable = false;
                this.playerControllable = false;
                this.envDisabled = 0;
                this.payloadCapacity = 0.0f;
                this.lowAltitude = false;
                this.flying = true;
                this.drag = 0.06f;
                this.speed = 3.5f;
                this.rotateSpeed = 9.0f;
                this.accel = 0.1f;
                this.itemCapacity = 50;
                this.health = 200.0f;
                this.hitSize = 11.0f;
                this.engineSize = 2.3f;
                this.engineOffset = 6.5f;
                this.hidden = true;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(6.0f, -6.0f, 2.3f, 315.0f)});
            }
        };
        pisun = new AtlacianUnitType("assembler-drone"){
            {
                this.controller = u -> new AssemblerAI();
                this.constructor = BuildingTetherPayloadUnit::create;
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.11f;
                this.speed = 1.3f;
                this.health = 90.0f;
                this.engineSize = 2.0f;
                this.engineOffset = 6.5f;
                this.payloadCapacity = 0.0f;
                this.targetable = false;
                this.bounded = false;
                this.outlineColor = SvPal.outline;
                this.isEnemy = false;
                this.hidden = true;
                this.useUnitCap = false;
                this.logicControllable = false;
                this.playerControllable = false;
                this.allowedInPayloads = false;
                this.createWreck = false;
                this.envEnabled = -1;
                this.envDisabled = 0;
            }
        };
    }

    public static void helicopter(String id) {
        mapHelicopter = EntityMapping.register((String)id, HelicopterUnitEntity::new);
    }

    public static void hmech(String id) {
        mapHMech = EntityMapping.register((String)id, HydromechUnitEntity::create);
    }

    public static void helicopter(String ... ids) {
        for (String id : ids) {
            SvUnits.helicopter(id);
        }
    }

    public static void hmech(String ... ids) {
        for (String id : ids) {
            SvUnits.hmech(id);
        }
    }

    public static void loadUwu(boolean isUwu) {
        SpinningBlurRegionPart p;
        if (isUwu && Advancement.uwu != null) {
            Advancement.uwu.unlock();
        }
        SvUnits.leeft.region = Core.atlas.find(SvUnits.leeft.name + (isUwu ? "-uwu" : ""));
        ((Weapon)SvUnits.leeft.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
        SvUnits.leeft.drawCell = !isUwu;
        SvUnits.flagshi.region = Core.atlas.find(SvUnits.flagshi.name + (isUwu ? "-uwu" : ""));
        SvUnits.flagshi.drawCell = !isUwu;
        ((HydromechUnitType)SvUnits.flagshi).bodyHeat = !isUwu;
        SvUnits.vanguard.region = Core.atlas.find(SvUnits.vanguard.name + (isUwu ? "-uwu" : ""));
        SvUnits.vanguard.drawCell = !isUwu;
        ((HydromechUnitType)SvUnits.vanguard).bodyHeat = !isUwu;
        SvUnits.squadron.region = Core.atlas.find(SvUnits.squadron.name + (isUwu ? "-uwu" : ""));
        SvUnits.squadron.drawCell = !isUwu;
        ((Weapon)SvUnits.squadron.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
        ((HydromechUnitType)SvUnits.squadron).bodyHeat = !isUwu;
        SvUnits.armada.region = Core.atlas.find(SvUnits.armada.name + (isUwu ? "-uwu" : ""));
        SvUnits.armada.drawCell = !isUwu;
        ((HydromechUnitType)SvUnits.armada).bodyHeat = !isUwu;
        SvUnits.lapetus.region = Core.atlas.find(SvUnits.lapetus.name + (isUwu ? "-uwu" : ""));
        SvUnits.lapetus.drawCell = !isUwu;
        Object object = SvUnits.lapetus.parts.first();
        if (object instanceof SpinningBlurRegionPart) {
            SpinningBlurRegionPart part = (SpinningBlurRegionPart)((Object)object);
            part.draw = !isUwu;
        }
        SvUnits.skath.region = Core.atlas.find(SvUnits.skath.name + (isUwu ? "-uwu" : ""));
        SvUnits.skath.drawCell = !isUwu;
        for (DrawPart part : SvUnits.skath.parts) {
            if (!(part instanceof SpinningBlurRegionPart)) continue;
            p = (SpinningBlurRegionPart)part;
            p.draw = !isUwu;
        }
        SvUnits.charon.region = Core.atlas.find(SvUnits.charon.name + (isUwu ? "-uwu" : ""));
        SvUnits.charon.drawCell = !isUwu;
        for (DrawPart part : SvUnits.charon.parts) {
            if (!(part instanceof SpinningBlurRegionPart)) continue;
            p = (SpinningBlurRegionPart)part;
            p.draw = !isUwu;
        }
        SvUnits.callees.region = Core.atlas.find(SvUnits.callees.name + (isUwu ? "-uwu" : ""));
        SvUnits.callees.drawCell = !isUwu;
        ((Weapon)SvUnits.callees.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
        for (DrawPart part : SvUnits.callees.parts) {
            if (!(part instanceof SpinningBlurRegionPart)) continue;
            p = (SpinningBlurRegionPart)part;
            p.draw = !isUwu;
        }
        SvUnits.ganymede.region = Core.atlas.find(SvUnits.ganymede.name + (isUwu ? "-uwu" : ""));
        SvUnits.ganymede.drawCell = !isUwu;
        for (DrawPart part : SvUnits.ganymede.parts) {
            if (!(part instanceof SpinningBlurRegionPart)) continue;
            p = (SpinningBlurRegionPart)part;
            p.draw = !isUwu;
        }
        SvUnits.stunt.region = Core.atlas.find(SvUnits.stunt.name + (isUwu ? "-uwu" : ""));
        SvUnits.stunt.drawCell = !isUwu;
        ((Weapon)SvUnits.stunt.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
        SvUnits.zeal.region = Core.atlas.find(SvUnits.zeal.name + (isUwu ? "-uwu" : ""));
        SvUnits.zeal.drawCell = !isUwu;
        ((Weapon)SvUnits.zeal.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
        SvUnits.gambit.region = Core.atlas.find(SvUnits.gambit.name + (isUwu ? "-uwu" : ""));
        SvUnits.gambit.drawCell = !isUwu;
        ((Weapon)SvUnits.gambit.weapons.first()).layerOffset = isUwu ? -1.0f : 0.0f;
    }

    static {
        mapHelicopter = 0;
        mapHMech = 0;
    }
}

