/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.graphics.g2d.TextureRegion;
import mindustry.io.SaveVersion;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.distribution.DirectionLiquidBridge;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.liquid.ArmoredConduit;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.production.Incinerator;
import mindustry.world.meta.BuildVisibility;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.core.draw.SvPal;
import subvoyage.type.block.distribution.ItemPipeline;
import subvoyage.type.block.distribution.LiquidPipeline;

public class SvDistribution {
    public static Block duct;
    public static Block isolatedDuct;
    public static Block highPressureDuct;
    public static Block ductRouter;
    public static Block ductBridge;
    public static Block ductSorter;
    public static Block ductInvSorter;
    public static Block ductUnderflow;
    public static Block ductOverflow;
    public static Block ductDistributor;
    public static Block incinerator;
    public static Block itemPipeline;
    public static Block fortifiedConduit;
    public static Block isolatedConduit;
    public static Block highPressureConduit;
    public static Block conduitRouter;
    public static Block conduitBridge;
    public static Block liquidPipeline;

    public static void load() {
        duct = new Duct("duct"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 1}));
                this.health = 90;
                this.speed = 4.0f;
                this.envDisabled |= 0x10;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 2});
            }

            public TextureRegion[] icons() {
                return new TextureRegion[]{this.fullIcon};
            }
        };
        isolatedDuct = new Duct("isolated-duct"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 1, SvItems.iridium, 1}));
                this.health = 270;
                this.speed = 4.0f;
                this.armored = true;
                this.envDisabled |= 0x10;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 20, SvItems.iridium, 20});
            }

            public TextureRegion[] icons() {
                return new TextureRegion[]{this.fullIcon};
            }

            public void load() {
                super.load();
                this.botRegions = ((Duct)SvDistribution.duct).botRegions;
            }
        };
        ductBridge = new DuctBridge("duct-bridge"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 4, SvItems.spaclanium, 2}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 16, SvItems.spaclanium, 4});
                ((Duct)SvDistribution.duct).bridgeReplacement = this;
                this.placeableLiquid = true;
                this.envDisabled |= 0x10;
                this.health = 90;
                this.speed = 4.0f;
            }
        };
        ductRouter = new Router("duct-router"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 3}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 16});
                this.envDisabled |= 0x10;
            }
        };
        ductSorter = new Sorter("duct-sorter"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2, SvItems.spaclanium, 2}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 100, SvItems.spaclanium, 350});
                this.buildCostMultiplier = 3.0f;
                this.envDisabled |= 0x10;
            }
        };
        ductInvSorter = new Sorter("duct-inverted-sorter"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2, SvItems.spaclanium, 2}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 100, SvItems.spaclanium, 350});
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
                this.envDisabled |= 0x10;
            }
        };
        ductDistributor = new Router("duct-distributor"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(BuildVisibility.hidden), ItemStack.with((Object[])new Object[]{SvItems.corallite, 4, SvItems.spaclanium, 4}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 320, SvItems.spaclanium, 70});
                this.buildCostMultiplier = 3.0f;
                this.size = 2;
                this.squareSprite = false;
            }
        };
        SaveVersion.modContentNameMap.put((Object)SvDistribution.ductDistributor.name, (Object)SvDistribution.ductRouter.name);
        ductOverflow = new OverflowGate("duct-overflow-gate"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2, SvItems.spaclanium, 4}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 300, SvItems.spaclanium, 300});
                this.buildCostMultiplier = 3.0f;
            }
        };
        ductUnderflow = new OverflowGate("duct-underflow-gate"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2, SvItems.spaclanium, 4}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 300, SvItems.spaclanium, 300});
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
            }
        };
        incinerator = new Incinerator("incinerator"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 5, SvItems.spaclanium, 10}));
                this.health = 90;
                this.envEnabled |= 2;
                this.buildCostMultiplier = 0.8f;
                this.consumePower(0.05f);
            }
        };
        fortifiedConduit = new Conduit("clay-conduit"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 3});
                this.envDisabled |= 0x10;
                this.botColor = SvPal.veryDarkViolet;
                this.health = 45;
            }
        };
        isolatedConduit = new ArmoredConduit("isolated-conduit"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 2, SvItems.iridium, 1}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 30, SvItems.iridium, 30});
                this.envDisabled |= 0x10;
                this.botColor = SvPal.veryDarkViolet;
                this.health = 125;
            }
        };
        conduitBridge = new DirectionLiquidBridge("bridge-conduit"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 4, SvItems.clay, 8}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 80, SvItems.clay, 40});
                ((Conduit)SvDistribution.fortifiedConduit).rotBridgeReplacement = this;
                this.range = 4;
                this.hasPower = false;
                this.envDisabled |= 0x10;
            }
        };
        conduitRouter = new LiquidRouter("liquid-router"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 4, SvItems.clay, 2}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 40, SvItems.clay, 10});
                this.liquidCapacity = 20.0f;
                this.underBullets = true;
                this.solid = false;
                this.envDisabled |= 0x10;
            }
        };
        itemPipeline = new ItemPipeline("item-pipeline"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(BuildVisibility.editorOnly), ItemStack.with((Object[])new Object[0]));
                this.health = 1200;
                this.range = 24;
                this.pulse = false;
                this.hasPower = false;
            }
        };
        liquidPipeline = new LiquidPipeline("liquid-pipeline"){
            {
                this.requirements(Category.distribution, SvBlocks.atl(BuildVisibility.editorOnly), ItemStack.with((Object[])new Object[0]));
                this.health = 1200;
                this.range = 64;
                this.pulse = false;
                this.hasPower = false;
            }
        };
    }
}

