/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.graphics.Color;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.gen.Sounds;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawGlowRegion;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawWarmupRegion;
import mindustry.world.meta.BuildVisibility;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.type.block.power.generator.WindTurbine;
import subvoyage.type.block.power.node.PowerBubbleMerger;
import subvoyage.type.block.power.node.PowerBubbleNode;

public class SvPower {
    public static Block powerBubbleNode;
    public static Block powerBubbleMerger;
    public static Block windTurbine;
    public static Block spaclaniumHydrolyzer;
    public static Block hydrocarbonicGenerator;

    public static void load() {
        powerBubbleNode = new PowerBubbleNode("power-bubble-node"){
            {
                this.requirements(Category.power, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.iridium, 8, SvItems.corallite, 4}));
                this.size = 1;
                this.outputsPower = false;
                this.consumesPower = true;
                this.squareSprite = false;
                this.buildCostMultiplier = 1.5f;
            }
        };
        powerBubbleMerger = new PowerBubbleMerger("power-bubble-merger"){
            {
                this.requirements(Category.power, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.iridium, 20, SvItems.corallite, 20}));
                this.size = 1;
                this.range = 12.0f;
                this.consumePowerBuffered(400.0f);
                this.buildCostMultiplier = 3.0f;
                this.outputsPower = true;
                this.consumesPower = true;
                this.squareSprite = false;
            }
        };
        windTurbine = new WindTurbine("wind-turbine"){
            {
                this.requirements(Category.power, SvBlocks.atl(BuildVisibility.sandboxOnly), ItemStack.with((Object[])new Object[]{SvItems.corallite, 60, SvItems.clay, 15, SvItems.iridium, 30}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 250, SvItems.clay, 80, SvItems.iridium, 40});
                this.ambientSound = Sounds.wind;
                this.ambientSoundVolume = 0.05f;
                this.powerProduction = 0.2f;
                this.size = 2;
            }
        };
        spaclaniumHydrolyzer = new ConsumeGenerator("spaclanium-hydrolyzer"){
            {
                this.requirements(Category.power, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 160, SvItems.clay, 90, SvItems.iridium, 45}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 200, SvItems.clay, 150, SvItems.iridium, 100});
                this.powerProduction = 5.4f;
                this.envDisabled |= 0x10;
                this.ambientSound = Sounds.extractLoop;
                this.ambientSoundVolume = 0.03f;
                this.size = 2;
                this.consumeEffect = Fx.generatespark;
                this.generateEffect = Fx.pulverizeSmall;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.alpha = 0.75f;
                        this.color = Color.violet;
                    }
                }});
                this.itemDuration = 108.0f;
                this.consumeItem(SvItems.spaclanium, 2);
                this.consumeLiquid(Liquids.water, 1.0666667f);
            }
        };
        hydrocarbonicGenerator = new ConsumeGenerator("hydrocarbonic-generator"){
            {
                this.requirements(Category.power, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 300, SvItems.clay, 100, SvItems.iridium, 200, SvItems.chrome, 10}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 700, SvItems.clay, 350, SvItems.iridium, 350, SvItems.chrome, 50});
                this.size = 2;
                this.ambientSound = Sounds.glow;
                this.ambientSoundVolume = 0.05f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawWarmupRegion(), new DrawGlowRegion()});
                this.powerProduction = 24.0f;
                this.itemDuration = 48.0f;
                this.envDisabled |= 0x10;
                this.consumeLiquid(SvItems.propane, 0.8f);
            }
        };
    }
}

