/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.graphics.g2d.TextureRegion;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BuildVisibility;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.content.SvUnits;
import subvoyage.content.other.SvTeam;
import subvoyage.type.block.storage.core.AtlacianCore;

public class SvStorage {
    public static Block corePuffer;
    public static Block container;
    public static Block largeVault;
    public static Block unloader;
    public static Block liquidContainer;
    public static Block liquidTank;
    public static Block coreBastion;

    public static void load() {
        corePuffer = new AtlacianCore("core-puffer"){
            {
                this.requirements(Category.effect, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 400, SvItems.corallite, 400, SvItems.clay, 150}));
                this.alwaysUnlocked = true;
                this.buildVisibility = BuildVisibility.editorOnly;
                this.isFirstTier = true;
                this.unitType = SvUnits.commute;
                this.health = 4000;
                this.itemCapacity = 3000;
                this.size = 4;
                this.incinerateNonBuildable = true;
                this.squareSprite = false;
                this.requiresCoreZone = false;
                this.envDisabled |= 0x10;
                this.unitCapModifier = 12;
                this.placeableLiquid = true;
                this.bannedItems.addAll((Object[])new Item[]{SvItems.crude});
            }

            protected TextureRegion[] icons() {
                return new TextureRegion[]{this.region, this.teamRegions[SvTeam.melius.id]};
            }
        };
        container = new StorageBlock("vault"){
            {
                this.requirements(Category.effect, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.chrome, 20, SvItems.iridium, 85}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.chrome, 80, SvItems.iridium, 200});
                this.size = 2;
                this.itemCapacity = 80;
                this.scaledHealth = 55.0f;
                this.squareSprite = false;
            }

            protected TextureRegion[] icons() {
                return new TextureRegion[]{this.region, this.teamRegions[SvTeam.melius.id]};
            }
        };
        unloader = new Unloader("unloader"){
            {
                this.requirements(Category.effect, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.chrome, 25, SvItems.clay, 30}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.chrome, 100, SvItems.clay, 300});
                this.speed = 5.4545455f;
                this.group = BlockGroup.transportation;
                this.squareSprite = false;
            }

            protected TextureRegion[] icons() {
                return new TextureRegion[]{this.region, this.teamRegions[SvTeam.melius.id]};
            }
        };
        liquidTank = new LiquidRouter("liquid-tank"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 80, SvItems.clay, 140, SvItems.iridium, 30}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 1040, SvItems.clay, 870, SvItems.iridium, 500});
                this.liquidCapacity = 1800.0f;
                this.health = 500;
                this.size = 3;
                this.liquidPadding = 1.5f;
                this.solid = true;
                this.squareSprite = false;
            }
        };
        coreBastion = new AtlacianCore("core-bastion"){
            {
                this.requirements(Category.effect, SvBlocks.atl(BuildVisibility.editorOnly), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 600, SvItems.corallite, 600, SvItems.clay, 300, SvItems.sulfur, 300}));
                this.alwaysUnlocked = true;
                this.buildVisibility = BuildVisibility.editorOnly;
                this.isFirstTier = true;
                this.unitType = SvUnits.commute;
                this.health = 4000;
                this.itemCapacity = 3000;
                this.size = 4;
                this.incinerateNonBuildable = true;
                this.squareSprite = false;
                this.requiresCoreZone = false;
                this.envDisabled |= 0x10;
                this.unitCapModifier = 12;
                this.placeableLiquid = true;
                this.bannedItems.addAll((Object[])new Item[]{SvItems.crude});
            }

            protected TextureRegion[] icons() {
                return new TextureRegion[]{this.region, this.teamRegions[SvTeam.melius.id]};
            }
        };
    }
}

