/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.IntSeq;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.FlarePart;
import mindustry.entities.part.HaloPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.part.ShapePart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.draw.DrawTurret;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.content.ost.SvSounds;
import subvoyage.core.draw.DataEffect;
import subvoyage.core.draw.SvFx;
import subvoyage.core.draw.SvPal;
import subvoyage.core.draw.block.DrawTurretCallbacked;
import subvoyage.core.draw.part.SvRegionPart;
import subvoyage.type.block.turret.LaserTurret;
import subvoyage.type.block.turret.resist.DrawResist;
import subvoyage.type.block.turret.resist.ResistTurret;
import subvoyage.type.shoot.ShootUpsurge;

public class SvTurret {
    public static Block whirl;
    public static Block rupture;
    public static Block resonance;
    public static Block cascade;
    public static Block spectrum;
    public static Block upsurge;
    public static Block resistance;

    public static void load() {
        whirl = new ItemTurret("whirl"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 85, SvItems.clay, 45, SvItems.iridium, 30}));
                this.outlineColor = SvPal.outline;
                this.squareSprite = false;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 10, SvItems.clay, 10});
                this.size = 3;
                this.drawer = new DrawTurretCallbacked("atlacian-"){
                    {
                        super(basePrefix);
                        DrawTurret draw = (DrawTurret)drawer;
                        SvRegionPart liquidPart = new SvRegionPart(draw, "-blade"){
                            {
                                super(drawer, region);
                                this.heatColor = Color.sky.cpy().a(0.42f);
                                this.heatProgress = DrawPart.PartProgress.warmup.add(-0.2f).add(p -> Mathf.sin((float)9.0f, (float)0.2f) * p.warmup);
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 1.5f;
                                this.moveRot = -8.0f;
                            }
                        };
                        this.parts.add((Object)new RegionPart("-blade-mid"){
                            {
                                super(arg0);
                                this.heatColor = Color.sky.cpy().a(0.42f);
                                this.heatProgress = DrawPart.PartProgress.warmup.add(-0.2f).add(p -> Mathf.sin((float)9.0f, (float)0.2f) * p.warmup);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.moveY = -1.25f;
                            }
                        });
                        this.parts.add((Object)liquidPart);
                        this.onDraw = (build, drawer) -> {
                            liquidPart.liquidDraw = build.liquids.current();
                            liquidPart.liquidAlpha = build.liquids.get(liquidPart.liquidDraw) / build.block.liquidCapacity;
                        };
                    }
                };
                this.shootSound = Sounds.blaster;
                this.reload = 60.0f;
                this.shoot = new ShootUpsurge(){
                    {
                        this.shots = 2;
                        this.shotDelay = 10.0f;
                        this.firstShotDelay = 10.0f;
                    }
                };
                float BPS = 2.0f;
                float mainDamage = 136.0f / BPS;
                this.ammo(new Object[]{SvItems.spaclanium, new BasicBulletType(3.7f, mainDamage){
                    {
                        super(arg0, arg1);
                        this.width = 15.0f;
                        this.height = 15.0f;
                        this.shrinkY = 0.1f;
                        this.lifetime = 296.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.despawnEffect = Fx.blastExplosion;
                        this.shootEffect = SvFx.pulverize;
                        this.smokeEffect = Fx.none;
                        this.backColor = this.trailColor = SvPal.spaclanium;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 3.0f;
                        this.trailLength = 5;
                        this.ammoMultiplier = 2.0f;
                    }
                }});
                this.shootY = 5.0f;
                this.recoil = 1.0f;
                this.rotate = false;
                this.range = 144.0f;
                this.scaledHealth = 100.0f;
                this.coolantMultiplier = 1.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 0.33333334f));
                this.limitRange(0.0f);
            }
        };
        rupture = new ItemTurret("rupture"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 145, SvItems.clay, 125, SvItems.iridium, 30}));
                this.size = 3;
                this.outlineColor = SvPal.outline;
                this.shootCone = 360.0f;
                this.fogRadius = 6;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 100, SvItems.clay, 60, SvItems.iridium, 30});
                this.targetGround = false;
                this.targetAir = true;
                this.squareSprite = false;
                this.cooldownTime = 60.0f;
                this.shoot = new ShootSpread(){
                    {
                        this.spread = 5.0f;
                        this.shots = 2;
                    }
                };
                this.reload = 80.0f;
                float BPS = 60.0f / (this.reload + this.shoot.firstShotDelay + (float)this.shoot.shots * this.shoot.shotDelay) * ((float)this.shoot.shots * 2.0f);
                float mainDamage = 190.4f / BPS * 1.0f;
                this.ammo(new Object[]{SvItems.sulfur, new BasicBulletType(6.0f, mainDamage){
                    {
                        super(arg0, arg1);
                        this.width = 6.0f;
                        this.height = 12.0f;
                        this.lifetime = 30.0f;
                        this.shootEffect = SvFx.pulverize;
                        this.smokeEffect = Fx.none;
                        this.backColor = this.trailColor = Pal.missileYellow;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 6.0f;
                        this.trailLength = 12;
                        this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        ammoPerShot = 3;
                        this.intervalRandomSpread = 0.0f;
                        this.intervalSpread = 80.0f;
                        this.intervalBullets = 3;
                        this.intervalDelay = -1.0f;
                        this.bulletInterval = 10.0f;
                        this.fragRandomSpread = 0.0f;
                        this.fragSpread = 90.0f;
                        this.fragBullets = 3;
                        this.fragVelocityMin = 1.0f;
                        this.knockback = -3.0f;
                    }
                }});
                this.drawer = new DrawTurret("atlacian-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 1.5f;
                                this.moveRot = -4.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.warmup, 1.25f, 2.25f, -16.0f));
                            }
                        });
                        this.parts.add((Object)new RegionPart("-blade-mid"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.heat;
                                this.moveY = -1.25f;
                            }
                        });
                        this.parts.add((Object)new FlarePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.05f);
                                this.color1 = SvPal.quartzFiber;
                                this.stroke = 3.0f;
                                this.radius = 0.0f;
                                this.radiusTo = 6.0f;
                                this.layer = 110.0f;
                                this.y = -8.0f;
                                this.x = 0.0f;
                                this.followRotation = true;
                                this.sides = 6;
                            }
                        });
                        this.parts.add((Object)new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.05f);
                                this.color = SvPal.quartzFiber;
                                this.stroke = 1.0f;
                                this.radius = 2.5f;
                                this.radiusTo = 6.0f;
                                this.layer = 110.0f;
                                this.y = -8.0f;
                                this.x = 0.0f;
                                this.rotateSpeed = 1.0f;
                                this.hollow = true;
                                this.sides = 6;
                            }
                        });
                    }
                };
                this.shootSound = Sounds.railgun;
                this.shootY = 12.0f;
                this.recoil = 0.5f;
                this.range = 260.0f;
                this.scaledHealth = 200.0f;
                this.coolantMultiplier = 2.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 0.33333334f));
                this.limitRange(6.0f);
            }
        };
        resonance = new PowerTurret("resonance"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 185, SvItems.iridium, 140, SvItems.spaclanium, 80, SvItems.clay, 180}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 800, SvItems.iridium, 500, SvItems.chrome, 300});
                this.size = 3;
                this.outlineColor = SvPal.outline;
                this.shootCone = 360.0f;
                this.targetGround = true;
                this.targetAir = true;
                this.fogRadius = 8;
                this.health = 540;
                this.shootSound = Sounds.cannon;
                this.range = 120.0f;
                this.velocityRnd = 0.0f;
                this.reload = 160.0f;
                this.shake = 5.0f;
                this.chargeSound = Sounds.lasercharge;
                this.shootY = 0.0f;
                this.rotateSpeed = 0.0f;
                this.drawer = new DrawTurret("atlacian-");
                this.shootEffect = new MultiEffect(new Effect[]{SvFx.resonanceExplosion, SvFx.resonanceExplosionDust, new WaveEffect(){
                    {
                        this.lifetime = 10.0f;
                        this.strokeFrom = 3.0f;
                        this.strokeTo = 0.0f;
                        this.sizeTo = range;
                    }
                }});
                float BPS = 60.0f / (this.reload + this.shoot.firstShotDelay + (float)this.shoot.shots * this.shoot.shotDelay) * (float)this.shoot.shots;
                float mainDamage = 326.40002f / BPS * 0.6f;
                final float subDamage = 326.40002f / BPS * 0.4f / 8.0f;
                this.shootType = new ExplosionBulletType(mainDamage, this.range){
                    {
                        super(arg0, arg1);
                        this.collidesAir = true;
                        this.buildingDamageMultiplier = 1.1f;
                        this.ammoMultiplier = 1.0f;
                        this.speed = 0.0f;
                        this.lifetime = 1.0f;
                        this.killShooter = false;
                        this.fragBullets = 8;
                        this.fragSpread = 45.0f;
                        this.fragRandomSpread = 5.0f;
                        this.fragVelocityMin = 1.0f;
                        this.lightningColor = Color.white;
                        this.lightningDamage = 6.0f;
                        this.lightning = 8;
                        this.lightningLength = 10;
                        this.fragBullet = new BasicBulletType(6.0f, subDamage * 0.7f){
                            {
                                super(arg0, arg1);
                                this.width = 9.0f;
                                this.hitSize = 5.0f;
                                this.height = 15.0f;
                                this.pierce = true;
                                this.lifetime = 40.0f;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Pal.lightishGray;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 2.1f;
                                this.trailLength = 5;
                                this.weaveMag = 10.0f;
                                this.weaveScale = 18.0f;
                                this.lightningColor = Color.white;
                                this.lightningDamage = subDamage * 0.3f / 2.0f;
                                this.lightning = 2;
                                this.lightningLength = 10;
                                this.hitEffect = this.despawnEffect = new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Pal.lightishGray;
                                        this.sizeTo = 4.0f;
                                        this.strokeFrom = 4.0f;
                                        this.lifetime = 10.0f;
                                    }
                                };
                                this.buildingDamageMultiplier = 0.8f;
                                this.homingPower = 0.08f;
                                this.homingRange = 80.0f;
                            }
                        };
                    }
                };
                this.consumePower(3.3f);
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 0.33333334f));
                this.coolantMultiplier = 8.0f;
            }
        };
        cascade = new LaserTurret("cascade"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 300, SvItems.iridium, 200, SvItems.spaclanium, 220, SvItems.clay, 150, SvItems.chrome, 100}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.clay, 1000, SvItems.iridium, 800, SvItems.chrome, 700, SvItems.spaclanium, 600});
                this.outlineColor = SvPal.outline;
                this.size = 3;
                this.shootCone = 360.0f;
                this.fogRadius = 6;
                this.targetGround = true;
                this.targetAir = true;
                this.squareSprite = false;
                this.inputs = IntSeq.with((int[])new int[]{1, 2, 3});
                this.laserRequirement = 30.0f;
                this.laserMaxEfficiency = 2.0f;
                this.laserOverpowerScale = 0.5f;
                this.capacity = 120.0f;
                this.consumePower(1.2f);
                this.reload = 40.0f;
                this.shoot = new ShootSpread(2, 30.0f);
                float BPS = 60.0f / (this.reload + this.shoot.firstShotDelay + (float)this.shoot.shots * this.shoot.shotDelay) * (float)this.shoot.shots;
                float mainDamage = 462.40002f / BPS * 0.6f;
                final float subDamage = 462.40002f / BPS * 0.4f / 10.0f;
                this.shootType = new BasicBulletType(6.0f, mainDamage){
                    {
                        super(arg0, arg1);
                        this.sprite = "large-orb";
                        this.inaccuracy = 1.0f;
                        this.ammoMultiplier = 3.0f;
                        ammoPerShot = 2;
                        this.width = 12.0f;
                        this.height = 12.0f;
                        this.lifetime = 120.0f;
                        this.shootEffect = SvFx.pulverize;
                        this.smokeEffect = Fx.none;
                        this.backColor = this.trailColor = SvPal.chromiumLightish;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.intervalBullets = 5;
                        this.fragBullets = 5;
                        this.fragVelocityMin = 1.0f;
                        this.fragVelocityMax = 1.0f;
                        this.bulletInterval = 40.0f;
                        this.intervalDelay = 10.0f;
                        this.fragBullet = this.intervalBullet = new LaserBulletType(subDamage){
                            {
                                super(arg0);
                                this.colors = new Color[]{SvPal.chromiumLightish.cpy().a(0.4f), SvPal.chromiumLightish, Color.white};
                                this.chargeEffect = new MultiEffect(new Effect[]{Fx.lancerLaserCharge, Fx.lancerLaserChargeBegin});
                                this.buildingDamageMultiplier = 0.25f;
                                this.hitEffect = Fx.hitLancer;
                                this.hitSize = 4.0f;
                                this.lifetime = 16.0f;
                                this.drawSize = 400.0f;
                                this.collidesAir = false;
                                this.length = 40.0f;
                                this.ammoMultiplier = 1.0f;
                                this.pierceCap = 4;
                                this.status = StatusEffects.electrified;
                            }
                        };
                        this.homingPower = 0.18f;
                        this.homingRange = 16.0f;
                        this.trailRotation = true;
                        this.trailEffect = Fx.disperseTrail;
                        this.trailInterval = 3.0f;
                        this.trailWidth = 6.0f;
                        this.trailLength = 6;
                        this.trailInterp = v -> Math.max(Mathf.slope((float)v), 0.8f);
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    }
                };
                this.smokeEffect = Fx.shootSmokeSmite;
                this.drawer = new DrawTurret("atlacian-"){
                    {
                        super(arg0);
                        final DrawPart.PartProgress heatp = DrawPart.PartProgress.warmup.blend(p -> Mathf.absin((float)2.0f, (float)1.0f) * p.warmup, 0.2f);
                        final DrawPart.PartProgress haloProgress = DrawPart.PartProgress.warmup.delay(0.5f);
                        final float haloY = -10.0f;
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = SvPal.turretHeatGlow;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 2.0f;
                                this.moveRot = -7.0f;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.warmup, 0.0f, -2.0f, 3.0f));
                            }
                        }, new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.recoil;
                                this.under = true;
                                this.moveY = -4.0f;
                                this.heatColor = SvPal.turretHeatGlow;
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(arg0);
                                this.heatProgress = heatp;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatColor = SvPal.turretHeatGlow;
                                this.moveY = -8.0f;
                                this.mirror = false;
                                this.under = true;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.2f);
                                this.color = Pal.accent;
                                this.circle = true;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 6.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.rotateSpeed = 1.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotateSpeed = -1.0f;
                                this.shapes = 4;
                                this.shapeRotation = 180.0f;
                                this.triLength = 0.0f;
                                this.triLengthTo = 2.0f;
                                this.haloRotation = 45.0f;
                                this.haloRadius = 2.0f;
                                this.tri = true;
                                this.radius = 4.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotateSpeed = -1.0f;
                                this.shapes = 4;
                                this.shapeRotation = 180.0f;
                                this.triLength = 0.0f;
                                this.triLengthTo = 2.0f;
                                this.haloRotation = 45.0f;
                                this.haloRadius = 10.0f;
                                this.tri = true;
                                this.radius = 4.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.shapes = 4;
                                this.triLength = 0.0f;
                                this.triLengthTo = 4.0f;
                                this.haloRadius = 10.0f;
                                this.haloRotation = 0.0f;
                                this.shapeRotation = 90.0f;
                                this.tri = true;
                                this.radius = 4.0f;
                            }
                        }});
                    }
                };
                this.shootSound = Sounds.railgun;
                this.shootY = 8.0f;
                this.recoil = 0.5f;
                this.range = 180.0f;
                this.scaledHealth = 200.0f;
                this.coolantMultiplier = 1.0f;
                this.limitRange(6.0f);
            }
        };
        upsurge = new ItemTurret("upsurge"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.phosphide, 100, SvItems.iridium, 300, SvItems.spaclanium, 300, SvItems.clay, 300, SvItems.chrome, 200}));
                this.coolantMultiplier = 1.1f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 0.33333334f));
                this.outlineColor = SvPal.outline;
                this.size = 4;
                this.rotateSpeed = 1.4f;
                this.shootSound = Sounds.shotgun;
                this.ammoPerShot = 2;
                this.maxAmmo = this.ammoPerShot * 3;
                this.drawer = new DrawTurret("atlacian-"){
                    {
                        super(arg0);
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.moveY = -1.0f;
                                this.moveRot = -10.0f;
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(arg0);
                                this.mirror = false;
                            }
                        }, new RegionPart("-wing"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.moveY = 2.0f;
                                this.moveRot = -5.0f;
                            }
                        }});
                    }
                };
                this.reload = 70.0f;
                this.moveWhileCharging = true;
                this.targetAir = true;
                this.targetGround = false;
                this.minWarmup = 0.0f;
                this.shoot = new ShootMulti(){
                    {
                        this.shots = 40;
                        this.source = new ShootAlternate(){
                            {
                                this.spread = 4.7f;
                                this.shots = 4;
                                this.barrels = 4;
                            }
                        };
                        this.dest = new ShootPattern[]{new ShootUpsurge(){
                            {
                                this.shotDelay = 5.0f;
                                this.shots = 10;
                            }
                        }};
                    }
                };
                float BPS = 60.0f / this.reload * 40.0f;
                final float mainDamage = 584.80005f / BPS;
                this.inaccuracy = 0.0f;
                this.predictTarget = false;
                this.shootY = 4.0f;
                this.ammo(new Object[]{SvItems.phosphide, new BasicBulletType(){
                    {
                        this.damage = mainDamage;
                        this.speed = 8.5f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.shrinkY = 0.3f;
                        this.pierce = true;
                        this.pierceCap = 3;
                        this.backSprite = "large-bomb-back";
                        this.sprite = "large-bomb";
                        velocityRnd = 0.11f;
                        this.collidesGround = false;
                        this.collidesTiles = false;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.frontColor = SvPal.phosphide;
                        this.trailColor = this.hitColor = SvPal.phosphide;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.ammoMultiplier = 2.0f;
                        this.lifetime = 21.0f;
                        this.rotationOffset = 90.0f;
                        this.trailRotation = true;
                        this.trailEffect = SvFx.upsurgeTrail;
                        this.inaccuracy = 1.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    }
                }});
                this.range = 336.0f;
            }
        };
        spectrum = new ItemTurret("spectrum"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 1}));
                this.coolantMultiplier = 1.1f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 0.33333334f));
                this.outlineColor = SvPal.outline;
                this.size = 4;
                this.rotateSpeed = 1.4f;
                this.shootSound = Sounds.mediumCannon;
                this.ammoPerShot = 2;
                this.maxAmmo = this.ammoPerShot * 3;
                this.reload = 160.0f;
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 1;
                        this.firstShotDelay = 10.0f;
                    }
                };
                float BPS = 120.0f / this.reload;
                final float mainDamage = 748.0f / BPS;
                this.drawer = new DrawTurret("atlacian-"){
                    {
                        super(arg0);
                        this.parts.addAll((Object[])new DrawPart[]{new FlarePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.mul(DrawPart.PartProgress.reload.min(DrawPart.PartProgress.constant((float)0.2f)).inv()).delay(0.2f).curve(Interp.smoother);
                                this.color1 = Pal.redLight;
                                this.layer = 110.0f;
                                this.y = 4.0f;
                                this.radius = 0.0f;
                                this.radiusTo = 8.0f;
                                this.spinSpeed = 1.0f;
                                this.followRotation = true;
                            }
                        }, new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.heatProgress = this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 2.0f;
                                this.moveY = -2.0f;
                                this.moveRot = -5.0f;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.heat, 0.0f, -2.0f, 5.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.smoothReload, 0.0f, -2.0f, 3.0f));
                            }
                        }, new RegionPart("-barrage"){
                            {
                                super(arg0);
                                this.heatProgress = this.progress = DrawPart.PartProgress.recoil;
                                this.moveX = 0.0f;
                                this.moveY = 0.0f;
                                this.moveRot = -10.0f;
                                this.mirror = true;
                                this.under = true;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.warmup, 2.0f, -2.0f, -5.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.heat, 0.0f, -2.0f, 5.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.smoothReload, 0.0f, -2.0f, 3.0f));
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(arg0);
                                this.mirror = false;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.heat, 0.0f, -2.0f, 0.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.smoothReload, 0.0f, -2.0f, 0.0f));
                            }
                        }, new RegionPart("-wing"){
                            {
                                super(arg0);
                                this.heatProgress = this.progress = DrawPart.PartProgress.warmup;
                                this.moveRot = 10.0f;
                                this.moveY = -4.0f;
                                this.mirror = true;
                                this.under = true;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.heat, 0.0f, -2.0f, 5.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.smoothReload, 0.0f, -2.0f, 3.0f));
                            }
                        }, new RegionPart("-bottom"){
                            {
                                super(arg0);
                                this.mirror = false;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.heat, 0.0f, -2.0f, 0.0f));
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.smoothReload, 0.0f, -2.0f, 0.0f));
                            }
                        }});
                    }
                };
                this.moveWhileCharging = false;
                this.targetAir = false;
                this.targetGround = true;
                this.minWarmup = 0.5f;
                this.inaccuracy = 0.0f;
                this.predictTarget = false;
                this.range = 180.0f;
                this.shootY = 4.0f;
                this.ammo(new Object[]{SvItems.nitride, new ArtilleryBulletType(2.5f, 0.0f, "shell"){
                    {
                        super(arg0, arg1, arg2);
                        this.lifetime = 60.0f;
                        this.intervalDelay = 30.0f;
                        this.bulletInterval = 100.0f;
                        this.width = 0.0f;
                        this.height = 0.0f;
                        this.collides = false;
                        this.hittable = false;
                        this.scaleLife = false;
                        this.fragBullets = 1;
                        this.fragVelocityMax = 0.0f;
                        this.fragVelocityMin = 0.0f;
                        this.fragRandomSpread = 0.0f;
                        this.fragSpread = 0.0f;
                        this.fragAngle = 0.0f;
                        this.fragBullet = new ExplosionBulletType(mainDamage * 0.3f, 40.0f){
                            {
                                super(arg0, arg1);
                                this.killShooter = false;
                                this.hitEffect = new MultiEffect(new Effect[]{new DataEffect(SvFx.spectrumExplosion, Float.valueOf(40.0f))});
                                this.collidesAir = true;
                                this.collidesGround = true;
                                this.pierce = true;
                                this.pierceCap = 1;
                                this.despawnEffect = Fx.none;
                                this.knockback = 2.0f;
                                this.splashDamageRadius = 65.0f;
                                this.splashDamage = mainDamage;
                                this.scaledSplashDamage = true;
                                this.hitColor = this.trailColor = Color.valueOf((String)"ea8878").lerp(Pal.redLight, 0.5f);
                                backColor = this.trailColor;
                                frontColor = Color.white;
                                this.ammoMultiplier = 1.0f;
                                this.hitSound = Sounds.titanExplosion;
                                this.status = StatusEffects.blasted;
                                this.knockback = 5.0f;
                                this.trailLength = 32;
                                this.trailWidth = 3.35f;
                                this.trailSinScl = 2.5f;
                                this.trailSinMag = 0.5f;
                                this.trailEffect = Fx.none;
                                this.despawnShake = 7.0f;
                                this.shootEffect = Fx.shootTitan;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.trailInterp = Interp.slope;
                                shrinkX = 0.2f;
                                shrinkY = 0.1f;
                                this.buildingDamageMultiplier = 0.3f;
                            }
                        };
                        this.intervalBullet = new ExplosionBulletType(mainDamage * 0.7f, 64.0f){
                            {
                                super(arg0, arg1);
                                this.killShooter = false;
                                this.hitEffect = new MultiEffect(new Effect[]{new DataEffect(SvFx.spectrumExplosion, Float.valueOf(64.0f))});
                                this.collidesAir = true;
                                this.collidesGround = true;
                                this.pierce = true;
                                this.pierceCap = 1;
                                this.despawnEffect = Fx.none;
                                this.knockback = 2.0f;
                                this.splashDamageRadius = 65.0f;
                                this.splashDamage = mainDamage;
                                this.scaledSplashDamage = true;
                                this.hitColor = this.trailColor = Color.valueOf((String)"ea8878").lerp(Pal.redLight, 0.5f);
                                backColor = this.trailColor;
                                frontColor = Color.white;
                                this.ammoMultiplier = 1.0f;
                                this.hitSound = Sounds.titanExplosion;
                                this.status = StatusEffects.blasted;
                                this.knockback = 5.0f;
                                this.trailLength = 32;
                                this.trailWidth = 3.35f;
                                this.trailSinScl = 2.5f;
                                this.trailSinMag = 0.5f;
                                this.trailEffect = Fx.none;
                                this.despawnShake = 7.0f;
                                this.shootEffect = Fx.shootTitan;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.trailInterp = Interp.slope;
                                shrinkX = 0.2f;
                                shrinkY = 0.1f;
                                this.buildingDamageMultiplier = 0.3f;
                            }
                        };
                    }
                }});
            }
        };
        resistance = new ResistTurret("resistance"){
            {
                this.requirements(Category.turret, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 1}));
                this.range = 1440.0f;
                this.fogRadius = 15;
                this.spacing = 160;
                this.fogRadiusMultiplier = 0.4f;
                this.health = 5400;
                this.bulletType = new ExplosionBulletType(788.80005f, 32.0f){
                    {
                        super(arg0, arg1);
                        this.buildingDamageMultiplier = 0.4f;
                        this.ammoMultiplier = 1.0f;
                        this.speed = 0.0f;
                        this.lifetime = 1.0f;
                        this.despawnShake = 10.0f;
                        this.hitShake = 10.0f;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.pierceArmor = true;
                        this.hitSound = this.despawnSound = SvSounds.flashExplosion;
                        this.fragBullet = new BasicBulletType(6.0f, 15.776001f, "shell"){
                            {
                                super(arg0, arg1, arg2);
                                this.hitSound = this.despawnSound = Sounds.bang;
                                this.width = 9.0f;
                                this.hitSize = 5.0f;
                                this.height = 15.0f;
                                this.pierce = true;
                                this.lifetime = 35.0f;
                                this.weaveMag = 10.0f;
                                this.weaveScale = 18.0f;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = SvPal.teslaCharge;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailLength = 32;
                                this.trailWidth = 3.35f;
                                this.trailSinScl = 2.5f;
                                this.trailSinMag = 0.5f;
                                this.trailEffect = Fx.none;
                                this.status = StatusEffects.slow;
                                this.statusDuration = 60.0f;
                                this.hitEffect = this.despawnEffect = new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = SvPal.teslaCharge;
                                        this.sizeTo = 4.0f;
                                        this.strokeFrom = 4.0f;
                                        this.lifetime = 10.0f;
                                    }
                                };
                                this.buildingDamageMultiplier = 0.3f;
                                this.homingPower = 0.2f;
                                this.homingRange = 30.0f;
                            }
                        };
                        this.fragRandomSpread = 0.0f;
                        this.fragSpread = 30.0f;
                        this.fragBullets = 10;
                        this.fragVelocityMin = 1.0f;
                        this.lightningColor = SvPal.teslaCharge;
                        this.lightningDamage = 4.9300003f;
                        this.lightning = 16;
                        this.lightningLength = 10;
                        this.killShooter = false;
                    }
                };
                this.consumePower(2.3f);
                this.inputs = IntSeq.with((int[])new int[]{1, 2, 3});
                this.laserRequirement = 120.0f;
                this.laserMaxEfficiency = 2.0f;
                this.laserOverpowerScale = 0.5f;
                this.capacity = 240.0f;
                this.coolant = (ConsumeLiquid)((ConsumeLiquid)this.consume((Consume)new ConsumeLiquid(SvItems.hydrogen, 2.0f))).boost();
                this.liquidCapacity = 300.0f;
                this.size = 5;
                this.cooldownTime = 120.0f;
                this.recoilTime = 50.0f;
                this.recoilPow = 2.0f;
                this.recoil = 1.0f;
                this.outlineColor = SvPal.outline;
                this.heatColor = SvPal.teslaCharge;
                this.drawer = new DrawResist("atlacian-"){
                    {
                        super(basePrefix);
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.x = 0.0f;
                                this.y = 0.0f;
                                this.heatProgress = this.progress = DrawPart.PartProgress.warmup;
                                this.moveRot = -25.0f;
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.progress = DrawPart.PartProgress.recoil.inv();
                                        moveY = -5.0f;
                                    }
                                });
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.progress = DrawPart.PartProgress.heat;
                                        moveRot = -10.0f;
                                    }
                                });
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(arg0);
                                this.mirror = false;
                                this.x = 0.0f;
                                this.y = 0.0f;
                                this.heatProgress = this.progress = DrawPart.PartProgress.warmup;
                                this.moveY = -2.0f;
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.progress = DrawPart.PartProgress.recoil.inv();
                                        moveY = -5.0f;
                                    }
                                });
                            }
                        }, new RegionPart("-arc"){
                            {
                                super(arg0);
                                this.mirror = false;
                                this.x = 0.0f;
                                this.y = 0.0f;
                                this.heatProgress = this.progress = DrawPart.PartProgress.warmup;
                                this.moveY = -4.0f;
                                this.moves.add((Object)new DrawPart.PartMove(){
                                    {
                                        this.progress = DrawPart.PartProgress.recoil.inv();
                                        moveY = -5.0f;
                                    }
                                });
                            }
                        }, new FlarePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.09f);
                                this.color1 = SvPal.teslaCharge;
                                this.layer = 110.0f;
                                this.stroke = 3.0f;
                                this.radius = 0.0f;
                                this.radiusTo = 8.0f;
                                this.y = 7.0f;
                                this.x = 0.0f;
                                this.followRotation = true;
                                this.sides = 6;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.08f);
                                this.color = SvPal.teslaCharge;
                                this.layer = 110.0f;
                                this.stroke = 2.0f;
                                this.radius = 0.0f;
                                this.radiusTo = 8.0f;
                                this.y = 7.0f;
                                this.x = 0.0f;
                                this.rotateSpeed = 2.0f;
                                this.hollow = true;
                                this.sides = 6;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.05f);
                                this.color = SvPal.teslaCharge;
                                this.layer = 110.0f;
                                this.stroke = 2.0f;
                                this.radius = 0.0f;
                                this.radiusTo = 12.0f;
                                this.y = 7.0f;
                                this.x = 0.0f;
                                this.rotateSpeed = -2.0f;
                                this.hollow = true;
                                this.sides = 6;
                            }
                        }});
                    }
                };
                this.minRingCount = 1;
                this.boostRingCount = 2;
                this.ringChargeTime = 140.0f;
                this.ringMovementSpeed = 1.0f;
                this.ringRadius = 24.0f;
                this.ringAccuracy = 0.8f;
                this.consumePower(5.0f);
                this.consumeItem(SvItems.nitride, 3);
            }
        };
    }
}

