/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core;

import arc.Core;
import arc.func.Boolc;
import arc.func.Prov;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.gen.Icon;
import mindustry.type.Planet;
import mindustry.ui.dialogs.SettingsMenuDialog;
import subvoyage.Subvoyage;
import subvoyage.content.SvUnits;
import subvoyage.content.world.SvPlanets;
import subvoyage.core.UpdateManager;
import subvoyage.core.ui.SvUI;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.core.ui.settings.BannerPref;
import subvoyage.core.ui.settings.ButtonPref;
import subvoyage.core.ui.settings.CheckIconSetting;
import subvoyage.core.ui.settings.SeparatorPref;
import subvoyage.core.ui.settings.SliderIconSetting;
import subvoyage.core.ui.settings.SwitchPref;

public class SvSettings {
    static SettingsMenuDialog.SettingsTable table;

    public static void load() {
        Vars.ui.settings.addCategory(Core.bundle.get("setting.subvoyage-title"), "subvoyage-icon", t -> {
            table = t;
            t.pref((SettingsMenuDialog.SettingsTable.Setting)new BannerPref(Subvoyage.ID + "-modname", 256.0f));
            SvSettings.separator("subvoyage-data");
            SvSettings.buttonPref("subvoyage-clear-campaign", (Drawable)Icon.save, () -> Vars.ui.showConfirm("@confirm", "@settings.sv-clear-campaign.confirm", () -> {
                SvSettings.resetSaves(SvPlanets.atlacian);
                Vars.ui.showInfoOnHidden("@settings.sv-clear-campaign-close.confirm", () -> Core.app.exit());
            }));
            SvSettings.buttonPref("subvoyage-clear-tech-tree", (Drawable)Icon.tree, () -> Vars.ui.showConfirm("@confirm", "@settings.sv-clear-tech-tree.confirm", () -> SvSettings.resetTree(SvPlanets.atlacian.techTree)));
            SvSettings.buttonPref("subvoyage-clear-advancements", (Drawable)Icon.modePvp, () -> Vars.ui.showConfirm("@confirm", "@settings.sv-clear-advancements.confirm", SvSettings::resetAdvancements));
            SvSettings.separator("subvoyage-graphics");
            String planetQuality = Core.bundle.get("setting.subvoyage-planet-divisions.name");
            String lowQuality = Core.bundle.get("setting.subvoyage-planet-divisions.1");
            String mediumQuality = Core.bundle.get("setting.subvoyage-planet-divisions.2");
            String highQuality = Core.bundle.get("setting.subvoyage-planet-divisions.3");
            SvSettings.buttonPref("subvoyage-planet-divisions", (Prov<CharSequence>)((Prov)() -> planetQuality + ":\n" + Core.bundle.get("setting.subvoyage-planet-divisions." + SvSettings.i("planet-divisions"))), (Drawable)new TextureRegionDrawable((TextureRegion)Core.atlas.find(Subvoyage.ID + "-atlacian")), () -> SvUI.planetQuality.showDialog());
            Core.settings.defaults(new Object[]{"subvoyage-planet-divisions", 6});
            SvSettings.switchPref(Subvoyage.ID + "-overdrive-projector", "subvoyage-drawer-mode", true);
            SvSettings.switchPref(Subvoyage.ID + "-laser-projector", "subvoyage-laser-shaders", true);
            SvSettings.switchPref(Subvoyage.ID + "-power-bubble-node", "subvoyage-power-bubble-shaders", true);
            SvSettings.switchPref(Subvoyage.ID + "-phosphide-wall-large-full", "subvoyage-wall-tiling", true);
            SvSettings.separator("subvoyage-other");
            SvSettings.switchPref(Subvoyage.ID + "-energy-dock-ship", "subvoyage-autoupdate", true);
            SvSettings.buttonPref("subvoyage-autoupdate-btn", null, UpdateManager::begin);
            SvSettings.separator("subvoyage-fun");
            SvSettings.switchPref(Subvoyage.ID + "-leeft-uwu", "subvoyage-leeft-uwu", false, SvUnits::loadUwu);
            SvUnits.loadUwu(SvSettings.unitUwu());
        });
    }

    public static boolean drawerMode() {
        return SvSettings.boolDef("drawer-mode", true);
    }

    public static boolean wallTiling() {
        return SvSettings.boolDef("wall-tiling", true);
    }

    public static boolean autoUpdate() {
        return SvSettings.boolDef("autoupdate", true);
    }

    public static boolean unitUwu() {
        return SvSettings.boolDef("leeft-uwu", false);
    }

    public static boolean bool(String key) {
        return Core.settings.getBool("subvoyage-" + key);
    }

    public static boolean boolDef(String key, boolean def) {
        return Core.settings.getBool("subvoyage-" + key, def);
    }

    public static void bool(String key, boolean bool) {
        Core.settings.put("subvoyage-" + key, (Object)bool);
    }

    public static int i(String key) {
        return Core.settings.getInt("subvoyage-" + key);
    }

    public static int iDef(String key, int def) {
        return Core.settings.getInt("subvoyage-" + key, def);
    }

    public static void i(String key, int val) {
        Core.settings.put("subvoyage-" + key, (Object)val);
    }

    public static void resetSaves(Planet planet) {
        planet.sectors.each(sector -> {
            if (sector.hasSave()) {
                sector.save.delete();
            }
        });
    }

    public static void resetTree(TechTree.TechNode root) {
        root.reset();
        root.content.clearUnlock();
        root.children.each(SvSettings::resetTree);
    }

    public static void resetAdvancements() {
        Advancement.all.each(Advancement::lock);
    }

    static void separator(String name) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new SeparatorPref(name));
    }

    static void buttonPref(String name, Drawable drawable, Runnable listener) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new ButtonPref(name, drawable, listener));
    }

    static void buttonPref(String name, Prov<CharSequence> title, Drawable drawable, Runnable listener) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new ButtonPref(name, drawable, title, listener));
    }

    static void sliderPref(String ico, String name, int def, int min, int max, SettingsMenuDialog.StringProcessor p) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new SliderIconSetting(ico, name, def, min, max, 1, p));
        Core.settings.defaults(new Object[]{name, def});
    }

    static void switchPref(String ico, String name, boolean def) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new SwitchPref(ico, name, def, null));
        Core.settings.defaults(new Object[]{name, def});
    }

    static void switchPref(String ico, String name, boolean def, Boolc changed) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new SwitchPref(ico, name, def, changed));
        Core.settings.defaults(new Object[]{name, def});
    }

    static void checkPref(String ico, String name, boolean def) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new CheckIconSetting(ico, name, def, null));
        Core.settings.defaults(new Object[]{name, def});
    }

    static void checkPref(String ico, String name, boolean def, Boolc changed) {
        table.pref((SettingsMenuDialog.SettingsTable.Setting)new CheckIconSetting(ico, name, def, changed));
        Core.settings.defaults(new Object[]{name, def});
    }
}

