/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core;

import arc.Core;
import arc.files.Fi;
import arc.func.Floatc;
import arc.util.ArcRuntimeException;
import arc.util.Http;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mindustry.Vars;
import mindustry.mod.Mods;
import subvoyage.Subvoyage;
import subvoyage.util.Var;

public class UpdateManager {
    public static String FICO_REPO = "Sublemon-Team/FontIconsLib";
    static float modImportProgress = 0.0f;

    public static void checkFico() {
        if (Vars.mods.getMod("font-icon-lib") != null) {
            return;
        }
        Core.settings.put("mod-font-icon-lib-enabled", (Object)true);
        Vars.ui.loadfrag.show(Core.bundle.get("@subvoyage-installing-fico"));
        Var<Float> loadingProgress = new Var<Float>(Float.valueOf(0.0f));
        Vars.ui.loadfrag.setProgress(() -> ((Float)loadingProgress.val).floatValue());
        Http.get((String)("https://api.github.com/repos/" + FICO_REPO + "/releases/latest"), res -> {
            Jval asset;
            Jval json = Jval.read((String)res.getResultAsString());
            Jval.JsonArray assets = json.get("assets").asArray();
            Jval dexedAsset = (Jval)assets.find(j -> j.getString("name").startsWith("dexed") && j.getString("name").endsWith(".jar"));
            Jval jval = asset = dexedAsset == null ? (Jval)assets.find(j -> j.getString("name").endsWith(".jar")) : dexedAsset;
            if (asset == null) {
                throw new ArcRuntimeException("No JAR file found in releases. Make sure you have a valid jar file in the mod's latest Github Release.");
            }
            String url = asset.getString("browser_download_url");
            Http.get((String)url, result -> {
                try {
                    Fi file = Vars.tmpDirectory.child(FICO_REPO.replace("/", "") + ".zip");
                    long len = result.getContentLength();
                    Floatc cons = len <= 0L ? f -> {} : p -> {
                        loadingProgress.val = Float.valueOf(p);
                    };
                    try (OutputStream stream = file.write(false);){
                        Streams.copyProgress((InputStream)result.getResultAsStream(), (OutputStream)stream, (long)len, (int)4096, (Floatc)cons);
                    }
                    Core.settings.put("mod-font-icon-lib-enabled", (Object)true);
                    Mods.LoadedMod mod = Vars.mods.importMod(file);
                    try {
                        Class.forName("fonticolib.IconPropsParser").getMethod("start", new Class[0]).invoke(null, new Object[0]);
                        Class.forName("fonticolib.IconPropsParser").getMethod("loadTeams", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Vars.mods.list().add((Object)mod);
                    mod.setRepo(FICO_REPO);
                    file.delete();
                    Reflect.set((Object)Vars.mods, (String)"requiresReload", (Object)false);
                    Vars.ui.loadfrag.hide();
                }
                catch (Throwable e) {
                    UpdateManager.modError(e);
                }
            }, UpdateManager::importFail);
        }, UpdateManager::importFail);
    }

    public static void begin() {
        Log.info((Object)"[Subvoyage] Fetching latest Updates...");
        System.out.println(Subvoyage.currentTag);
        Http.get((String)("https://api.github.com/repos/" + Subvoyage.GITHUB_REPO + "/releases/latest"), res -> {
            Jval json = Jval.read((String)res.getResultAsString());
            String tagName = json.getString("tag_name");
            Log.info((Object)("[Subvoyage] Latest Release Tag: " + tagName));
            boolean upToDate = Subvoyage.versionControl.isUpToDate(Subvoyage.currentTag, tagName);
            Log.info((Object)("[Subvoyage] " + (!upToDate ? "New update is available" : "Version is up-to-date")));
            if (!upToDate) {
                String text = Core.bundle.format("settings.sv-update-version.confirm", new Object[]{tagName, Subvoyage.currentTag.replace("-beta", "b").replace("-fix", "f")});
                Vars.ui.showConfirm("@update", text, UpdateManager::update);
            }
        }, err -> Vars.ui.showInfoOnHidden("@settings.sv-update-failed.show", () -> {}));
    }

    public static void update() {
        Vars.ui.loadfrag.show();
        Vars.ui.loadfrag.setProgress(() -> modImportProgress);
        Http.get((String)("https://api.github.com/repos/" + Subvoyage.GITHUB_REPO + "/releases/latest"), res -> {
            Jval asset;
            Jval json = Jval.read((String)res.getResultAsString());
            Jval.JsonArray assets = json.get("assets").asArray();
            Jval dexedAsset = (Jval)assets.find(j -> j.getString("name").startsWith("dexed") && j.getString("name").endsWith(".jar"));
            Jval jval = asset = dexedAsset == null ? (Jval)assets.find(j -> j.getString("name").endsWith(".jar")) : dexedAsset;
            if (asset == null) {
                throw new ArcRuntimeException("No JAR file found in releases. Make sure you have a valid jar file in the mod's latest Github Release.");
            }
            String url = asset.getString("browser_download_url");
            Http.get((String)url, result -> UpdateManager.handleMod(Subvoyage.GITHUB_REPO, result), UpdateManager::importFail);
        }, UpdateManager::importFail);
    }

    private static void handleMod(String repo, Http.HttpResponse result) {
        try {
            Fi file = Vars.tmpDirectory.child(repo.replace("/", "") + ".zip");
            long len = result.getContentLength();
            Floatc cons = len <= 0L ? f -> {} : p -> {
                modImportProgress = p;
            };
            try (OutputStream stream = file.write(false);){
                Streams.copyProgress((InputStream)result.getResultAsStream(), (OutputStream)stream, (long)len, (int)4096, (Floatc)cons);
            }
            Mods.LoadedMod mod = Vars.mods.importMod(file);
            mod.setRepo(repo);
            file.delete();
            Core.app.post(() -> {
                try {
                    Vars.ui.loadfrag.hide();
                    Vars.ui.showInfoOnHidden("@mods.reloadexit", () -> {
                        Log.info((Object)"Exiting to reload mods.");
                        Core.app.exit();
                    });
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                }
            });
        }
        catch (Throwable e) {
            UpdateManager.modError(e);
        }
    }

    private static void importFail(Throwable t) {
        Core.app.post(() -> UpdateManager.modError(t));
    }

    static void modError(Throwable error) {
        Vars.ui.loadfrag.hide();
        if (error instanceof NoSuchMethodError || Strings.getCauses((Throwable)error).contains(t -> t.getMessage() != null && (t.getMessage().contains("trust anchor") || t.getMessage().contains("SSL") || t.getMessage().contains("protocol")))) {
            Vars.ui.showErrorMessage("@feature.unsupported");
        } else if (error instanceof Http.HttpStatusException) {
            Http.HttpStatusException st = (Http.HttpStatusException)error;
            Vars.ui.showErrorMessage(Core.bundle.format("connectfail", new Object[]{Strings.capitalize((String)st.status.toString().toLowerCase())}));
        } else {
            Vars.ui.showException(error);
        }
    }

    public static class VersionControl {
        public boolean areVersionsUpToDate(String origin, String release) {
            Integer[] originVersion = this.parseTagVersion(origin);
            Integer[] releaseVersion = this.parseTagVersion(release);
            int len = Math.max(originVersion.length, releaseVersion.length);
            boolean okay = true;
            for (int i = 0; i < len; ++i) {
                int reV;
                int orV = i >= originVersion.length ? 0 : originVersion[i];
                int n = reV = i >= releaseVersion.length ? 0 : releaseVersion[i];
                if (reV <= orV) continue;
                okay = false;
                break;
            }
            return okay;
        }

        public boolean areAttributeUpToDate(String origin, String release) {
            List<Attribute> originAttr = Arrays.asList(this.parseTagAttributes(origin));
            List<Attribute> releaseAttr = Arrays.asList(this.parseTagAttributes(release));
            if (releaseAttr.contains((Object)Attribute.FIX) && !originAttr.contains((Object)Attribute.FIX)) {
                return false;
            }
            return releaseAttr.contains((Object)Attribute.BETA) || !originAttr.contains((Object)Attribute.BETA);
        }

        public Integer[] parseTagVersion(String tag) {
            return (Integer[])Arrays.stream(tag.split("-")[0].split("\\.")).map(Integer::parseInt).toArray(Integer[]::new);
        }

        public Attribute[] parseTagAttributes(String tag) {
            String[] rawAttributes = (String[])Structs.remove((Object[])tag.split("-"), (int)0);
            Arrays.stream(rawAttributes).map(e -> Objects.equals(e, "b") ? "beta" : (Objects.equals(e, "f") ? "fix" : e));
            return (Attribute[])Arrays.stream(rawAttributes).map(e -> Attribute.valueOf(e.toUpperCase())).toArray(Attribute[]::new);
        }

        public boolean isUpToDate(String originTag, String releaseTag) {
            boolean versionUptd;
            originTag = originTag.replace("-beta", "b");
            originTag = originTag.replace("-fix", "f");
            releaseTag = releaseTag.replace("-beta", "b");
            releaseTag = releaseTag.replace("-fix", "f");
            originTag = originTag.replace("b", "-beta");
            originTag = originTag.replace("f", "-fix");
            releaseTag = releaseTag.replace("b", "-beta");
            releaseTag = releaseTag.replace("f", "-fix");
            if (originTag.startsWith("v")) {
                originTag = originTag.substring(1);
            }
            if (releaseTag.startsWith("v")) {
                releaseTag = releaseTag.substring(1);
            }
            if (!(versionUptd = this.areVersionsUpToDate(originTag, releaseTag))) {
                return false;
            }
            boolean attributeUptd = this.areAttributeUpToDate(originTag, releaseTag);
            return attributeUptd;
        }

        public static enum Attribute {
            FIX,
            BETA;

        }
    }
}

