/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.graphics.CacheLayer;

public class SvDraw {
    public static FrameBuffer buffer = new FrameBuffer();
    private static final float[] vertices = new float[24];

    public static void applyShader(Shader shader, Runnable draw) {
        Draw.flush();
        buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        buffer.begin(Color.clear);
        draw.run();
        buffer.end();
        buffer.blit(shader);
        Draw.flush();
    }

    public static void applyCache(CacheLayer cache, Runnable draw) {
        cache.begin();
        draw.run();
        cache.end();
    }

    public static void applyBloom(Runnable draw) {
        SvDraw.applyBloom(1.0f, draw);
    }

    public static void applyBloom(float intensity, Runnable draw) {
        int w = Core.graphics.getWidth();
        int h = Core.graphics.getHeight();
        Draw.flush();
        Vars.renderer.bloom.resize(w, h);
        Vars.renderer.bloom.capture();
        Vars.renderer.bloom.setBloomIntensity(intensity);
        draw.run();
        Vars.renderer.bloom.render();
    }

    public static void applyBloomBasic(Runnable draw) {
        float z = Draw.z();
        Draw.z((float)110.0f);
        draw.run();
        Draw.z((float)z);
    }

    public static void quad(TextureRegion region, float x1, float y1, float c1, float x2, float y2, float c2, float x3, float y3, float c3, float x4, float y4, float c4) {
        float u = region.u;
        float v = region.v;
        float u2 = region.u2;
        float v2 = region.v2;
        float mcolor = Draw.getMixColor().toFloatBits();
        SvDraw.vertices[0] = x1;
        SvDraw.vertices[1] = y1;
        SvDraw.vertices[2] = c1;
        SvDraw.vertices[3] = u;
        SvDraw.vertices[4] = v;
        SvDraw.vertices[5] = mcolor;
        SvDraw.vertices[6] = x2;
        SvDraw.vertices[7] = y2;
        SvDraw.vertices[8] = c2;
        SvDraw.vertices[9] = u;
        SvDraw.vertices[10] = v2;
        SvDraw.vertices[11] = mcolor;
        SvDraw.vertices[12] = x3;
        SvDraw.vertices[13] = y3;
        SvDraw.vertices[14] = c3;
        SvDraw.vertices[15] = u2;
        SvDraw.vertices[16] = v2;
        SvDraw.vertices[17] = mcolor;
        SvDraw.vertices[18] = x4;
        SvDraw.vertices[19] = y4;
        SvDraw.vertices[20] = c4;
        SvDraw.vertices[21] = u2;
        SvDraw.vertices[22] = v;
        SvDraw.vertices[23] = mcolor;
        Draw.vert((Texture)region.texture, (float[])vertices, (int)0, (int)vertices.length);
    }

    public static Texture crop(String name) {
        return new Texture(Core.atlas.getPixmap(name).crop());
    }

    public static class _3D {
        public static float xHeight(float x, float height) {
            if (height <= 0.0f) {
                return x;
            }
            return x + _3D.xOffset(x, height);
        }

        public static float yHeight(float y, float height) {
            if (height <= 0.0f) {
                return y;
            }
            return y + _3D.yOffset(y, height);
        }

        public static float xOffset(float x, float height) {
            return (x - Core.camera.position.x) * _3D.hMul(height);
        }

        public static float yOffset(float y, float height) {
            return (y - Core.camera.position.y) * _3D.hMul(height);
        }

        public static float hScale(float height) {
            return 1.0f + _3D.hMul(height);
        }

        public static float hMul(float height) {
            return height * Vars.renderer.getDisplayScale();
        }

        public static float layerOffset(float x, float y) {
            float max = Math.max(Core.camera.width, Core.camera.height);
            return -Mathf.dst((float)x, (float)y, (float)Core.camera.position.x, (float)Core.camera.position.y) / max / 1000.0f;
        }

        public static float heightFade(float height) {
            float scl = _3D.hScale(height);
            return 1.0f - Mathf.curve((float)scl, (float)1.5f, (float)7.0f);
        }
    }
}

