/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw;

import arc.Core;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import subvoyage.content.block.SvPayload;
import subvoyage.core.draw.EFill;
import subvoyage.core.draw.SvDraw;
import subvoyage.core.draw.SvPal;
import subvoyage.type.block.payload.PayloadLaunchPad;
import subvoyage.type.unit.ability.LegionfieldAbility;

public class SvFx {
    public static final Rand rand = new Rand();
    public static final Vec2 v = new Vec2();
    public static final Vec2 vec = new Vec2();
    public static final Vec2 vec2 = new Vec2();
    public static TextureRegion laser;
    public static TextureRegion laserEnd;
    public static TextureRegion laserTop;
    public static TextureRegion laserTopEnd;
    public static final Effect none;
    public static final Effect steam;
    public static final Effect particle;
    public static final Effect heliWave;
    public static final Effect shootShockwave;
    public static final Effect burnFlash;
    public static final Effect photosynthFlash;
    public static final Effect blast;
    public static final Effect upsurgeTrail;
    public static final Effect skathTrail;
    public static final Effect coreBubble;
    public static final Effect scutchFlash;
    public static final Effect tugPress;
    public static final Effect rocketLandDust;
    public static final Effect payloadLaunchPadRocketLaunch;
    public static final Effect payloadLaunchPadRocketLand;
    public static final Effect smokeCloud;
    public static final Effect aweExplosion;
    public static final Effect resonanceExplosion;
    public static final Effect spectrumExplosion;
    public static final Effect aweExplosionDust;
    public static final Effect resonanceExplosionDust;
    public static final Effect pulverize;
    public static final Effect point;
    public static final Effect decoderWave;
    public static final Effect smokePuff;
    public static final Effect hitLaserOrange;
    public static final Effect missileTrailSmokeMedium;
    public static final Effect missileTrailSmokeSmall;
    public static final Effect missileTrailShort;
    public static final Effect shootLauncher;
    public static final Effect beam;
    public static Func<Object, Effect> hitLaserColor;
    public static Func<Object, Effect> colorRadExplosion;

    public static void loadLaser() {
        laser = Core.atlas.find("laser-white");
        laserEnd = Core.atlas.find("laser-white-end");
        laserTop = Core.atlas.find("laser-top");
        laserTopEnd = Core.atlas.find("laser-top-end");
    }

    public static void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2) {
        if (laser == null) {
            SvFx.loadLaser();
        }
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f - 1.5f;
        float len2 = (float)(size2 * 8) / 2.0f - 1.5f;
        Drawf.laser((TextureRegion)laser, (TextureRegion)laserEnd, (float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)0.25f);
    }

    static {
        none = new Effect(0.0f, 0.0f, e -> {});
        steam = new Effect(35.0f, e -> {
            Draw.z((float)30.41f);
            Draw.color((Color)Color.white);
            Angles.randLenVectors((long)e.id, (int)2, (float)(2.0f + e.fin() * 7.0f), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.2f + e.fslope() * 1.5f)));
        });
        particle = new Effect(10.0f, e -> {
            Lines.stroke((float)e.fin(), (Color)e.color.cpy().value(1.1f));
            Draw.z((float)101.0f);
            Lines.circle((float)e.x, (float)e.y, (float)(e.fout() * 5.5f));
            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 3.5f));
        });
        heliWave = new Effect(30.0f, e -> {
            Draw.z((float)100.0f);
            Draw.color((Color)e.color);
            float size = ((Float)e.data).floatValue();
            float rad = size * 12.0f * e.fin();
            LegionfieldAbility.lightInner(e.x, e.y, (int)(rad * 8.0f), rad * e.fin(), rad, 0.0f, e.color.cpy().a(0.0f), e.color.cpy());
            LegionfieldAbility.lightInner(e.x, e.y, (int)(rad * 8.0f), rad + rad * e.fout() * 0.2f, rad, 0.0f, e.color.cpy().a(0.0f), e.color.cpy());
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 2.0f);
                Tmp.v1.trns(angle, rad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * size * 2.0f), (float)(e.fout() * size * lenRand + 6.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
        shootShockwave = new Effect(60.0f, e -> {
            Draw.color((Color)e.color);
            float fin = Interp.circleOut.apply(e.fout());
            float fin2 = new Interp.ExpOut(10.0f, 10.0f).apply(e.fin());
            float fout = new Interp.ExpOut(10.0f, 10.0f).apply(e.fout());
            float progress = e.fin();
            float cover = 280.0f * fin2 - 40.0f * Mathf.slope((float)Interp.circleOut.apply(e.fin()));
            vec.trns(e.rotation, 8.0f - 18.0f * fin).add(e.x, e.y);
            EFill.donutEllipse(SvFx.vec.x, SvFx.vec.y, 8.0f * progress * fout, 28.0f * fout, 4.0f * progress * fout, 24.0f * fout, cover / 360.0f, -cover / 2.0f, e.rotation);
        }).followParent(true).rotWithParent(true);
        burnFlash = new Effect(30.0f, e -> {
            Draw.color((Color)Pal.powerLight);
            Lines.stroke((float)(e.fout() * 3.0f), (Color)Pal.powerLight);
            Lines.circle((float)e.x, (float)e.y, (float)(e.finpowdown() * 16.0f));
            Fill.circle((float)e.x, (float)e.y, (float)(e.foutpow() * 16.0f));
        });
        photosynthFlash = new Effect(30.0f, e -> {
            Lines.stroke((float)e.fout((Interp)Interp.pow2Out), (Color)SvPal.photoFlash);
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow2Out) * 3.0f * 8.0f / 2.0f), (float)(45.0f * e.finpowdown()));
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow2Out) * 3.0f * 8.0f / 2.0f), (float)(-45.0f * e.finpowdown()));
        });
        blast = new Effect(30.0f, e -> {
            Draw.z((float)30.1f);
            Draw.color((Color)SvPal.teslaCharge);
            Lines.stroke((float)(e.fout() * 4.0f));
            float circleRad = e.finpow() * 1.0f * 8.0f;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            Draw.color((Color)Color.white);
            Fill.circle((float)e.x, (float)e.y, (float)(circleRad * e.foutpow() * 0.75f));
            rand.setSeed((long)e.id);
            Draw.color((Color)SvPal.teslaCharge.cpy().lerp(Color.white, e.fin()));
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(-0.35f, 0.35f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 6.0f), (float)(e.fout() * 10.0f * lenRand + 4.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
        upsurgeTrail = new Effect(8.0f, e -> {
            Draw.color((Color)SvPal.phosphide);
            for (int i : Mathf.signs) {
                Drawf.tri((float)e.x, (float)e.y, (float)(6.0f * e.fout()), (float)24.0f, (float)(e.rotation + 90.0f + 90.0f * (float)i));
            }
            Drawf.light((float)e.x, (float)e.y, (float)(60.0f * e.fout()), (Color)SvPal.phosphide, (float)0.5f);
        });
        skathTrail = new Effect(8.0f, e -> {
            Draw.color((Color)SvPal.heatGlow);
            for (int i : Mathf.signs) {
                Drawf.tri((float)e.x, (float)e.y, (float)(6.0f * e.fout()), (float)-12.0f, (float)(e.rotation + 90.0f + 90.0f * (float)i));
            }
            Drawf.light((float)e.x, (float)e.y, (float)(60.0f * e.fout()), (Color)SvPal.phosphide, (float)0.5f);
        });
        coreBubble = new Effect(20.0f, e -> {
            Draw.z((float)29.5f);
            Draw.color((Color)Tmp.c1.set(e.color).shiftValue(0.1f));
            Lines.stroke((float)(e.fout() + 0.2f));
            Angles.randLenVectors((long)e.id, (int)2, (float)(e.rotation * 0.9f), (x, y) -> Lines.circle((float)(e.x + x), (float)(e.y + y), (float)(1.0f + e.fin() * 3.0f)));
        });
        scutchFlash = new Effect(30.0f, e -> {
            Lines.stroke((float)e.fout((Interp)Interp.pow2Out), (Color)SvPal.quartzFiber);
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow2Out) * 3.0f * 8.0f / 2.0f), (float)(45.0f * e.finpowdown()));
            Lines.poly((float)e.x, (float)e.y, (int)8, (float)(e.fin() * 3.0f * 8.0f), (float)0.0f);
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow2Out) * 3.0f * 8.0f / 2.0f), (float)(-45.0f * e.finpowdown()));
        });
        tugPress = new Effect(30.0f, e -> {
            Lines.stroke((float)e.fout((Interp)Interp.pow2Out), (Color)SvPal.tugSheetGlow);
            Lines.square((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow2Out) * 3.0f * 8.0f), (float)0.0f);
            Lines.line((float)(e.x + 16.0f * e.finpowdown()), (float)(e.y - 16.0f), (float)(e.x + 16.0f * e.finpowdown()), (float)(e.y + 16.0f));
            Lines.line((float)(e.x - 16.0f * e.finpowdown()), (float)(e.y - 16.0f), (float)(e.x - 16.0f * e.finpowdown()), (float)(e.y + 16.0f));
        });
        rocketLandDust = new Effect(100.0f, e -> {
            Draw.color((Color)e.color, (float)(e.fout(0.1f) * e.color.a));
            rand.setSeed((long)e.id);
            Tmp.v1.trns(e.rotation, e.finpow() * 90.0f * rand.random(0.2f, 1.0f));
            Fill.circle((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(8.0f * rand.random(0.6f, 1.0f) * e.fout(0.2f)));
        }).layer(61.0f);
        payloadLaunchPadRocketLaunch = new Effect(240.0f, e -> {
            PayloadLaunchPad launchPad = (PayloadLaunchPad)SvPayload.payloadLaunchPad;
            Draw.alpha((float)e.fout());
            Draw.scl((float)(1.0f + e.finpowdown() * 2.0f), (float)(1.0f + e.finpowdown() * 2.0f));
            float x = SvDraw._3D.xHeight(e.x, e.finpowdown() * 2.0f);
            float y = SvDraw._3D.yHeight(e.y, e.finpowdown() * 2.0f);
            Draw.rect((TextureRegion)launchPad.rocketRegion, (float)x, (float)y, (float)(e.fin() * 360.0f));
            if (e.fout() > 0.75f && !Vars.state.isPaused() && rand.chance(0.5)) {
                rocketLandDust.create(x, y, Mathf.random((float)360.0f), Pal.stoneGray.cpy().a(0.2f), new Object());
            }
            if (e.fout() > 0.97f && !Vars.state.isPaused() && rand.chance(0.125)) {
                Fx.launchPod.create(x, y, 0.0f, Pal.accent, new Object());
            }
        });
        payloadLaunchPadRocketLand = new Effect(240.0f, e -> {
            PayloadLaunchPad launchPad = (PayloadLaunchPad)SvPayload.payloadLaunchPad;
            Draw.alpha((float)e.finpowdown());
            Draw.scl((float)(1.0f + e.foutpow() * 2.0f), (float)(1.0f + e.foutpow() * 2.0f));
            float x = SvDraw._3D.xHeight(e.x, e.foutpow());
            float y = SvDraw._3D.yHeight(e.y, e.foutpow());
            Draw.rect((TextureRegion)launchPad.rocketRegion, (float)x, (float)y, (float)(e.fin() * 360.0f));
            if (e.fin() > 0.75f && !Vars.state.isPaused() && rand.chance((double)0.9f)) {
                rocketLandDust.create(x, y, Mathf.random((float)360.0f), Pal.stoneGray.cpy().a(0.2f), new Object());
            }
            if (e.fin() > 0.97f && !Vars.state.isPaused() && rand.chance(0.125)) {
                Fx.launchPod.create(x, y, 0.0f, Pal.accent, new Object());
            }
        });
        smokeCloud = new Effect(25.0f, e -> Angles.randLenVectors((long)e.id, (float)e.fin(), (int)15, (float)15.0f, (x, y, fin, fout) -> {
            Draw.color((Color)Color.gray);
            Draw.alpha((float)((0.5f - Math.abs(fin - 0.5f)) * 2.0f));
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.5f + fout * 4.0f));
        }));
        aweExplosion = new Effect(60.0f, 160.0f, e -> {
            Draw.color((Color)SvPal.teslaCharge);
            Lines.stroke((float)(e.fout() * 4.0f));
            float circleRad = e.finpow() * 6.0f * 8.0f;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 1.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 6.0f), (float)(e.fout() * 10.0f * lenRand + 6.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
        resonanceExplosion = new Effect(60.0f, 160.0f, e -> {
            Draw.color((Color)Color.white);
            Lines.stroke((float)(e.fout() * 2.0f));
            float circleRad = e.finpow() * 10.0f * 8.0f;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 1.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 6.0f), (float)(e.fout() * 10.0f * lenRand + 6.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
        spectrumExplosion = new Effect(60.0f, 160.0f, e -> {
            Draw.color((Color)e.color);
            Lines.stroke((float)(e.fout() * 3.0f));
            float circleRad = 6.0f + e.finpow() * ((Float)e.data).floatValue();
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            LegionfieldAbility.lightInner(e.x, e.y, (int)(circleRad * 8.0f), circleRad * e.fin(), circleRad, 0.0f, e.color.cpy().a(0.0f), e.color.cpy());
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 2.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 12.0f), (float)(e.fout() * 10.0f * lenRand + 6.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
        aweExplosionDust = new Effect(60.0f, 160.0f, e -> {
            Draw.color((Color)SvPal.teslaCharge);
            Draw.alpha((float)0.3f);
            Lines.stroke((float)(e.fout() * 5.0f));
            float circleRad = e.finpow() * 6.0f * 8.0f;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 1.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Draw.alpha((float)(0.3f - rand.random(0.25f)));
                    Fill.circle((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 24.0f * lenRand));
                }
            }
        });
        resonanceExplosionDust = new Effect(60.0f, 160.0f, e -> {
            Draw.color((Color)Color.white);
            Draw.alpha((float)0.3f);
            Lines.stroke((float)(e.fout() * 2.0f));
            float circleRad = e.finpow() * 10.0f * 8.0f;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 1.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Draw.alpha((float)(0.3f - rand.random(0.25f)));
                    Fill.circle((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 24.0f * lenRand));
                }
            }
        });
        pulverize = new Effect(20.0f, e -> {
            Draw.color((Color)e.color.a(0.75f));
            Lines.stroke((float)(e.fout() * 2.0f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.finpow() * (e.lifetime / 5.0f)));
            Angles.randLenVectors((long)(e.id + 1), (int)4, (float)(18.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(1.0f + e.fout() * 3.0f)));
        });
        point = new Effect(60.0f, e -> {
            Draw.color((Color)e.color.a(e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(e.finpow() * 4.0f));
        });
        decoderWave = new Effect(20.0f, 80.0f, e -> {
            Draw.color((Color)Color.white, (Color)Color.lightGray, (float)e.fin());
            Lines.stroke((float)(e.fout() * 4.0f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * ((Float)e.data).floatValue()));
        });
        smokePuff = new Effect(18.0f, e -> {
            Draw.color((Color)e.color.a(0.2f));
            Angles.randLenVectors((long)e.id, (int)6, (float)(30.0f * e.finpow()), (x, y) -> {
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 2.0f));
                Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)e.fout());
            });
        });
        hitLaserOrange = new Effect(8.0f, e -> {
            Draw.color((Color)Color.white, (Color)Pal.lightOrange, (float)e.fin());
            Lines.stroke((float)(0.5f + e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 5.0f));
            Drawf.light((float)e.x, (float)e.y, (float)23.0f, (Color)Pal.lightOrange, (float)(e.fout() * 0.7f));
        });
        missileTrailSmokeMedium = new Effect(120.0f, 200.0f, b -> {
            float intensity = 2.0f;
            Draw.color((Color)b.color, (float)0.7f);
            int i = 0;
            while (i < 4) {
                rand.setSeed((long)b.id * 2L + (long)i);
                float lenScl = rand.random(0.5f, 1.0f);
                int fi = i++;
                b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), (float)e.fin((Interp)Interp.pow10Out), (int)((int)(1.25f * intensity)), (float)(6.5f * intensity), (x, y, in, out) -> {
                    float fout = e.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                    float rad = fout * ((2.0f + intensity) * 1.25f);
                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)rad);
                    Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(rad * 1.85f), (Color)b.color, (float)0.5f);
                }));
            }
        }).layer(99.0f);
        missileTrailSmokeSmall = new Effect(60.0f, 100.0f, b -> {
            float intensity = 2.0f;
            Draw.color((Color)b.color, (float)0.5f);
            int i = 0;
            while (i < 4) {
                rand.setSeed((long)b.id * 2L + (long)i);
                float lenScl = rand.random(0.5f, 1.0f);
                int fi = i++;
                b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), (float)e.fin((Interp)Interp.pow10Out), (int)((int)(1.25f * intensity)), (float)(3.0f * intensity), (x, y, in, out) -> {
                    float fout = e.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                    float rad = fout * intensity;
                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)rad);
                    Drawf.light((float)(e.x + x), (float)(e.y + y), (float)rad, (Color)b.color, (float)0.25f);
                }));
            }
        }).layer(99.0f);
        missileTrailShort = new Effect(16.0f, e -> {
            Draw.color((Color)e.color);
            Fill.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout() / 2.0f));
        }).layer(99.999f);
        shootLauncher = new Effect(70.0f, e -> {
            rand.setSeed((long)e.id);
            for (int i = 0; i < 6; ++i) {
                v.trns(e.rotation + (float)rand.range(15), rand.random(e.finpow() * 40.0f));
                e.scaled(e.lifetime, b -> {
                    Draw.color((Color)e.color, (Color)Pal.lightishGray, (float)b.fin());
                    Fill.circle((float)(e.x + SvFx.v.x), (float)(e.y + SvFx.v.y), (float)b.fout());
                });
            }
        });
        beam = new Effect(60.0f, e -> {
            float[] pos = (float[])e.data();
            float x1 = pos[0];
            float y1 = pos[1];
            float x2 = pos[2];
            float y2 = pos[3];
            Draw.color((Color)e.color);
            SvFx.drawLaser(x1, y1, x2, y2, 2, 2);
            Draw.reset();
        });
        hitLaserColor = c -> new Effect(8.0f, e -> {
            Draw.color((Color)Color.white, (Color)((Color)c), (float)e.fin());
            Lines.stroke((float)(0.5f + e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 5.0f));
            Drawf.light((float)e.x, (float)e.y, (float)23.0f, (Color)((Color)c), (float)(e.fout() * 0.7f));
        });
        colorRadExplosion = cr -> new Effect(60.0f, 160.0f, e -> {
            Color c = (Color)((Object[])cr)[0];
            float r = ((Float)((Object[])cr)[1]).floatValue();
            Draw.color((Color)c);
            Lines.stroke((float)(e.fout() * 2.0f));
            float circleRad = e.finpow() * r;
            Lines.circle((float)e.x, (float)e.y, (float)circleRad);
            rand.setSeed((long)e.id);
            for (int i = 0; i < 16; ++i) {
                float angle = rand.random(360.0f);
                float lenRand = rand.random(0.5f, 1.0f);
                Tmp.v1.trns(angle, circleRad);
                for (int s : Mathf.signs) {
                    Drawf.tri((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(e.foutpow() * 6.0f), (float)(e.fout() * 10.0f * lenRand + 6.0f), (float)(angle + 90.0f + (float)s * 90.0f));
                }
            }
        });
    }
}

