/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import java.util.HashMap;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawColorWeave
extends DrawBlock {
    public TextureRegion weave;
    public Color color;
    public HashMap<Building, Float> degrees = new HashMap();

    public DrawColorWeave(Color color) {
        this.color = color;
    }

    public void draw(Building build) {
        Draw.rect((TextureRegion)this.weave, (float)(build.x + Mathf.sinDeg((float)(build.totalProgress() * 8.0f))), (float)build.y, (float)build.totalProgress());
        Draw.color((Color)this.color);
        Draw.alpha((float)build.warmup());
        Lines.stroke((float)2.0f);
        Lines.lineAngleCenter((float)(build.x + Mathf.sin((float)build.totalProgress(), (float)6.0f, (float)(2.6666667f * (float)build.block.size))), (float)build.y, (float)90.0f, (float)((float)(build.block.size * 8) / 2.0f));
        Draw.reset();
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.weave};
    }

    public void load(Block block) {
        this.weave = Core.atlas.find(block.name + "-weave");
    }
}

