/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import mindustry.entities.part.DrawPart;
import mindustry.world.Block;
import mindustry.world.draw.DrawTurret;

public class DrawCustomTurret
extends DrawTurret {
    public DrawCustomTurret(String s) {
        super(s);
    }

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        super.getRegionsToOutline(block, out);
        if (block.region.found() && (block.outlinedIcon <= 0 || block.outlinedIcon >= block.getGeneratedIcons().length || !block.getGeneratedIcons()[block.outlinedIcon].equals(block.region))) {
            out.add((Object)block.region);
        }
    }

    public void load(Block block) {
        this.preview = Core.atlas.find(block.name + "-preview", block.region);
        this.outline = Core.atlas.find(block.name + "-outline");
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
        this.heat = Core.atlas.find(block.name + "-heat");
        this.base = Core.atlas.find(block.name + "-base");
        for (DrawPart part : this.parts) {
            part.turretShading = true;
            part.load(block.name);
        }
        if (!this.base.found() && block.minfo.mod != null) {
            this.base = Core.atlas.find(block.minfo.mod.name + "-" + this.basePrefix + "block-" + block.size);
        }
        if (!this.base.found()) {
            this.base = Core.atlas.find(this.basePrefix + "block-" + block.size);
        }
    }
}

