/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawHeatGlow
extends DrawBlock {
    public Color color = new Color(1.0f, 0.22f, 0.22f, 0.8f);
    public float pulse = 0.3f;
    public float pulseScl = 10.0f;
    public float layer = 31.0f;
    public TextureRegion heat;
    public String suffix = "-heat";

    public DrawHeatGlow(float layer) {
        this.layer = layer;
    }

    public DrawHeatGlow(String suffix) {
        this.suffix = suffix;
    }

    public DrawHeatGlow() {
    }

    public void draw(Building build) {
        Draw.z((float)31.0f);
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)this.color, (float)(Mathf.clamp((float)build.warmup()) * (this.color.a * (1.0f - this.pulse + Mathf.absin((float)this.pulseScl, (float)this.pulse)))));
        Draw.rect((TextureRegion)this.heat, (float)build.x, (float)build.y, (float)build.drawrot());
        Draw.blend();
        Draw.color();
        Draw.z((float)z);
    }

    public void load(Block block) {
        this.heat = Core.atlas.find(block.name + this.suffix);
    }
}

