/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawRegion;

public class DrawOutline
extends DrawRegion {
    public TextureRegion outline;

    public DrawOutline(String s) {
        super(s);
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.outline, this.region};
    }

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        super.getRegionsToOutline(block, out);
        if (block.region.found() && (block.outlinedIcon <= 0 || block.outlinedIcon >= block.getGeneratedIcons().length || !block.getGeneratedIcons()[block.outlinedIcon].equals(block.region))) {
            out.add((Object)block.region);
        }
    }

    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.outline.found()) {
            Draw.z((float)(this.layer - 0.01f));
            Draw.rect((TextureRegion)this.outline, (float)build.x, (float)build.y, (float)build.drawrot());
            Draw.z((float)this.layer);
        }
        if (this.spinSprite) {
            Drawf.spinSprite((TextureRegion)this.region, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * this.rotateSpeed + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f)));
        } else {
            Draw.rect((TextureRegion)this.region, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * this.rotateSpeed + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f)));
        }
        Draw.z((float)z);
    }

    public void load(Block block) {
        super.load(block);
        this.outline = Core.atlas.find(block.name + "-outline");
    }
}

