/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import subvoyage.core.SvSettings;

public class DrawSplit
extends DrawBlock {
    public DrawBlock drawerLow;
    public DrawBlock drawer;
    public boolean splitAssets = false;

    public DrawSplit(DrawBlock low, DrawBlock def) {
        this.drawerLow = low;
        this.drawer = def;
    }

    public DrawSplit(DrawBlock def) {
        this.drawerLow = new DrawDefault();
        this.drawer = def;
    }

    public DrawSplit(DrawBlock ... other) {
        this.drawerLow = new DrawDefault();
        this.drawer = new DrawMulti(other);
    }

    public static DrawSplit withLow(DrawBlock ... other) {
        return new DrawSplit((DrawBlock)new DrawMulti(other), (DrawBlock)new DrawDefault());
    }

    public static DrawSplit withLow() {
        return new DrawSplit((DrawBlock)new DrawDefault());
    }

    public DrawSplit with(DrawBlock ... other) {
        this.drawer = new DrawMulti(other);
        return this;
    }

    public DrawSplit splitAssets() {
        this.splitAssets = true;
        return this;
    }

    public void draw(Building build) {
        this.current().draw(build);
    }

    public void drawLight(Building build) {
        this.current().drawLight(build);
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        this.current().drawPlan(block, plan, list);
    }

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        this.drawerLow.getRegionsToOutline(block, out);
        this.drawer.getRegionsToOutline(block, out);
    }

    public void load(Block block) {
        this.drawerLow.load(block);
        this.drawer.load(block);
    }

    public TextureRegion[] icons(Block block) {
        return this.drawer.icons(block);
    }

    public DrawBlock current() {
        return SvSettings.drawerMode() ? this.drawer : this.drawerLow;
    }
}

