/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Time;
import java.util.HashMap;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawWarmupRegion
extends DrawBlock {
    public TextureRegion region;
    public String suffix = "";
    public boolean spinSprite = false;
    public boolean drawPlan = true;
    public boolean buildingRotate = false;
    public float x;
    public float y;
    public float rotation;
    public float layer = -1.0f;
    public HashMap<Building, Float> smoothEfficiencies = new HashMap();

    public DrawWarmupRegion(String suffix) {
        this.suffix = suffix;
    }

    public DrawWarmupRegion(String suffix, boolean spinSprite) {
        this.suffix = suffix;
        this.spinSprite = spinSprite;
    }

    public DrawWarmupRegion() {
    }

    public void draw(Building build) {
        float z = Draw.z();
        float smoothEfficiency = this.smoothEfficiencies.getOrDefault(build, Float.valueOf(0.0f)).floatValue();
        smoothEfficiency = Mathf.lerp((float)smoothEfficiency, (float)build.efficiency, (float)(Time.delta / 40.0f));
        this.smoothEfficiencies.put(build, Float.valueOf(smoothEfficiency));
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.spinSprite) {
            Drawf.spinSprite((TextureRegion)this.region, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * smoothEfficiency + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f)));
        } else {
            Draw.rect((TextureRegion)this.region, (float)(build.x + this.x), (float)(build.y + this.y), (float)(build.totalProgress() * smoothEfficiency + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f)));
        }
        Draw.z((float)z);
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        if (!this.drawPlan) {
            return;
        }
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy(), (float)(this.buildingRotate ? (float)plan.rotation * 90.0f : 0.0f));
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region};
    }

    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

