/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.mesh;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import subvoyage.core.draw.mesh.MeshUtils;
import subvoyage.core.draw.shader.SvShaders;

public class AuroraMesh
extends PlanetMesh {
    public final Mesh mesh;
    public TextureRegion region;
    public Texture texture;
    public Color color = Color.white.cpy();
    float speed;
    static Mat3D mat = new Mat3D();

    public AuroraMesh(TextureRegion region, Planet planet, int sides, float radiusIn, float off, float speed, Vec3 axis) {
        this.planet = planet;
        this.region = region;
        MeshUtils.begin(sides * 6 * 8 * 2);
        Tmp.v33.setZero();
        this.speed = speed;
        class MeshPoint {
            final Vec3 position;
            final Vec2 textureCords;

            public MeshPoint(Vec3 position, Vec2 textureCords) {
                this.position = position;
                this.textureCords = textureCords;
            }
        }
        MeshPoint[] meshPoints = new MeshPoint[]{new MeshPoint(new Vec3(), new Vec2(0.0f, 0.0f)), new MeshPoint(new Vec3(), new Vec2(1.0f, 0.0f)), new MeshPoint(new Vec3(), new Vec2(1.0f, 1.0f)), new MeshPoint(new Vec3(), new Vec2(0.0f, 1.0f))};
        int[] order = new int[]{0, 1, 2, 2, 3, 0};
        Vec3 plane = new Vec3().set(1.0f, 0.0f, 0.0f).rotate(Vec3.X, 90.0f).rotate(Vec3.X, axis.angle(Vec3.X) + 1.0f).rotate(Vec3.Y, axis.angle(Vec3.Y) + 1.0f).rotate(Vec3.Z, axis.angle(Vec3.Z) + 1.0f).crs(axis).add(0.0f, 0.3f, 0.0f);
        Vec3 inv = (Vec3)axis.cpy().unaryMinus();
        for (int i = 0; i < sides; ++i) {
            float len = 0.12f;
            float lenMult = 1.2f;
            float offsetY = 1.0f + Mathf.sin((float)((float)i / (float)sides * (float)Math.PI), (float)1.0f, (float)0.05f) + Mathf.random((float)0.0f, (float)0.01f) + off;
            float offXZ = 1.0f + Mathf.sin((float)((float)i / (float)sides * (float)Math.PI * 5.0f * 20.0f), (float)Mathf.randomSeed((long)sides, (int)5, (int)10), (float)0.15f);
            meshPoints[0].position.set(plane).rotate(axis, (float)i * 1.0f / (float)sides * 360.0f).setLength2(len).scl(offXZ, offsetY, offXZ).scl(radiusIn);
            meshPoints[1].position.set(plane).rotate(axis, (float)i * 1.0f / (float)sides * 360.0f).setLength2(len * lenMult).scl(radiusIn);
            meshPoints[2].position.set(plane).rotate(axis, ((float)i + 1.0f) / (float)sides * 360.0f).setLength2(len * lenMult).scl(radiusIn);
            meshPoints[3].position.set(plane).rotate(axis, ((float)i + 1.0f) / (float)sides * 360.0f).setLength2(len).scl(offXZ, offsetY, offXZ).scl(radiusIn);
            for (int j : order) {
                MeshPoint point = meshPoints[j];
                MeshUtils.vert(point.position, axis, point.textureCords);
            }
            for (int j = order.length - 1; j >= 0; --j) {
                MeshPoint point = meshPoints[order[j]];
                MeshUtils.vert(point.position, inv, point.textureCords);
            }
        }
        this.mesh = MeshUtils.end();
    }

    public float relRot() {
        return Time.globalTime * this.speed / 40.0f;
    }

    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        this.preRender(params);
        if (this.texture == null) {
            this.texture = new Texture(Core.atlas.getPixmap(this.region).crop());
        }
        this.texture.setWrap(Texture.TextureWrap.repeat);
        Blending.additive.apply();
        Shader shader = AuroraMesh.shader();
        shader.bind();
        shader.setUniformMatrix4("u_proj", projection.val);
        shader.setUniformMatrix4("u_trans", AuroraMesh.mat.setToTranslation((Vec3)this.planet.position).rotate((Vec3)Vec3.Y, (float)(this.planet.getRotation() + this.relRot())).val);
        shader.setUniformf("u_color", this.color.hue(Time.globalTime / 40.0f % 1.0f));
        this.setPlanetInfo("u_sun_info", this.planet.solarSystem);
        this.setPlanetInfo("u_planet_info", this.planet);
        this.texture.bind(0);
        shader.setUniformi("u_texture", 0);
        shader.apply();
        Gl.disable((int)2884);
        this.mesh.render(shader, 4);
        Gl.enable((int)2884);
        Blending.normal.apply();
    }

    public void preRender(PlanetParams params) {
        SvShaders.planetTextureShader.planet = this.planet;
        SvShaders.planetTextureShader.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation()).nor();
        SvShaders.planetTextureShader.ambientColor.set(this.planet.solarSystem.lightColor);
    }

    private void setPlanetInfo(String name, Planet planet) {
        Vec3 position = planet.position;
        Shader shader = AuroraMesh.shader();
        shader.setUniformf(name, position.x, position.y, position.z, planet.radius);
    }

    private static Shader shader() {
        return SvShaders.planetTextureShader;
    }
}

