/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.ui.advancements;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.graphics.Pal;
import subvoyage.core.ui.advancements.Advancement;

public class AdvancementToastFragment
extends Table {
    public Seq<Advancement> queue = Seq.with((Object[])new Advancement[0]);
    @Nullable
    public Advancement current = null;
    public float time = 0.0f;
    public float advancementTime = 210.0f;
    public float fadeTime = 60.0f;
    public static ObjectMap<String, TextureRegion> found = new ObjectMap();

    public AdvancementToastFragment() {
        this.setFillParent(true);
        this.visible(() -> true);
        this.update(() -> {});
        this.setup();
    }

    public void setup() {
        this.setClip(false);
        this.setTransform(true);
        this.top().left();
        this.fill();
        this.marginTop(120.0f);
        TextButton.TextButtonStyle style = (TextButton.TextButtonStyle)Core.scene.getStyle(TextButton.TextButtonStyle.class);
        Table gr = (Table)this.table(style.down).width(320.0f).height(100.0f).pad(10.0f).get();
        gr.setTransform(true);
        gr.top().left();
        gr.row();
        gr.image(this::region).padRight(3.0f).align(8).margin(0.0f).width(48.0f).height(48.0f).growY();
        gr.table(t -> {
            t.label(this::title).marginLeft(50.0f).top().left();
            t.row();
            t.label(this::description).marginTop(8.0f).top().left().fontScale(0.8f).growX().wrap().color(Pal.lightishGray);
        }).marginLeft(5.0f).top().growX().growY();
        gr.update(() -> {
            if (this.current == null && this.queue.firstOpt() != null) {
                this.current = (Advancement)this.queue.firstOpt();
                this.queue.remove(0);
            }
            if (this.current != null) {
                this.time += Time.delta;
                if (this.time > this.advancementTime) {
                    this.current = null;
                    this.time = 0.0f;
                }
            }
            float t = 0.0f;
            if (this.time < this.fadeTime && this.time > 0.0f) {
                t = this.time / this.fadeTime;
            } else if (this.time < this.advancementTime - this.fadeTime) {
                t = 1.0f;
            } else if (this.time < this.advancementTime) {
                t = 1.0f - (this.time - this.advancementTime + this.fadeTime) / this.fadeTime;
            }
            if (this.current == null) {
                t = 0.0f;
            }
            t = Interp.pow3Out.apply(t);
            gr.setTranslation(-330.0f * (1.0f - t), 0.0f);
        });
    }

    public TextureRegion region() {
        return this.current == null ? this.findCache("error") : this.findCache(this.current.icon);
    }

    public TextureRegion findCache(String id) {
        if (found.containsKey((Object)id)) {
            return (TextureRegion)found.get((Object)id, (Object)Core.atlas.find(id));
        }
        found.put((Object)id, (Object)Core.atlas.find(id));
        return this.findCache(id);
    }

    public String title() {
        return this.current == null ? "oh" : AdvancementToastFragment.clamp(this.current.title, 22);
    }

    public String description() {
        return this.current == null ? "no" : AdvancementToastFragment.clamp(this.current.description, 70);
    }

    public static String clamp(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength - 3) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public void build(Group parent) {
        Core.scene.add((Element)this);
    }
}

