/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.ui.advancements;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.ui.dialogs.BaseDialog;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.core.ui.advancements.AdvancementToastFragment;

public class AdvancementsDialog
extends BaseDialog {
    public AdvancementsDialog() {
        super("Subvoyage: " + Core.bundle.get("sv_advancement"));
        this.addCloseButton();
        this.shouldPause = false;
    }

    public void rebuild() {
        this.cont.clear();
        Table all = (Table)this.cont.table().grow().pad(20.0f).margin(10.0f).get();
        all.add((Element)new Bar(Core.bundle.get("sv_advancement.progress") + ": " + (float)Mathf.floor((float)(this.getProgress() * 1000.0f)) / 10.0f + "%", Pal.accent, this::getProgress)).align(2).height(18.0f).pad(4.0f).top().minWidth(320.0f).maxWidth(640.0f).growX();
        all.row();
        all.pane(t -> {
            t.top();
            for (Advancement adv : Advancement.all) {
                t.add((Element)this.advancement(adv)).growX().pad(5.0f).top();
                t.row();
            }
        }).top().minWidth(320.0f).maxWidth(640.0f).grow();
        all.align(10);
    }

    public float getProgress() {
        return (float)Advancement.all.count(Advancement::unlocked) / (float)Advancement.all.size;
    }

    public Table advancement(Advancement adv) {
        TextButton.TextButtonStyle style = (TextButton.TextButtonStyle)Core.scene.getStyle(TextButton.TextButtonStyle.class);
        Table t = new Table(!Advancement.unlocked(adv) ? style.up : style.down);
        t.setTransform(true);
        t.top().left();
        t.row();
        t.image(() -> this.icon(adv)).padRight(3.0f).align(8).margin(0.0f).width(48.0f).height(48.0f).growY();
        t.table(u -> {
            u.label(() -> this.title(adv)).marginLeft(50.0f).top().left();
            u.row();
            u.label(() -> this.description(adv)).marginTop(8.0f).top().left().fontScale(0.8f).growX().wrap().color(Pal.lightishGray);
        }).marginLeft(5.0f).top().growY().growX();
        return t;
    }

    public TextureRegion icon(Advancement adv) {
        return !Advancement.unlocked(adv) ? this.findCache("subvoyage-advancement-locked") : this.findCache(adv.icon);
    }

    public String title(Advancement adv) {
        return !Advancement.unlocked(adv) ? Core.bundle.get("sv_advancement.locked.name") : AdvancementsDialog.clamp(adv.title, 40);
    }

    public String description(Advancement adv) {
        return !Advancement.unlocked(adv) ? Core.bundle.get("sv_advancement.locked.description") : AdvancementsDialog.clamp(adv.description, 100);
    }

    public static String clamp(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength - 3) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public TextureRegion findCache(String id) {
        if (AdvancementToastFragment.found.containsKey((Object)id)) {
            return (TextureRegion)AdvancementToastFragment.found.get((Object)id, (Object)Core.atlas.find(id));
        }
        AdvancementToastFragment.found.put((Object)id, (Object)Core.atlas.find(id));
        return this.findCache(id);
    }

    public void showDialog() {
        this.rebuild();
        this.show(Core.scene);
    }

    public void addCloseButton(float width) {
        this.buttons.defaults().size(width, 64.0f);
        this.buttons.button("@back", (Drawable)Icon.left, () -> ((AdvancementsDialog)this).hide()).size(width, 64.0f).align(2);
        this.addCloseListener();
    }
}

