/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.ui.advancements;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import subvoyage.content.world.SvPlanets;
import subvoyage.type.world.AtlacianPlanetType;

public class PlanetQualityDialog
extends BaseDialog {
    public ImageButton[] btns = new ImageButton[10];

    public PlanetQualityDialog() {
        super(Core.bundle.get("setting.subvoyage-planet-divisions.name"));
        this.addCloseButton();
        this.shouldPause = false;
    }

    public void rebuild() {
        this.cont.clear();
        this.cont.pane(p -> {
            Table all = (Table)p.table().growY().width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).pad(5.0f).get();
            all.top().left();
            this.mode(all, "low", 5);
            this.mode(all, "medium", 6);
            this.mode(all, "high", 8);
        }).pad(5.0f);
    }

    public void mode(Table all, String quality, int num) {
        ImageButton btn;
        String qua = Core.bundle.get("setting.subvoyage-planet-divisions." + num);
        float width = Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f);
        all.add((CharSequence)qua).growX().center().top().padTop(3.0f);
        all.row();
        all.image().growX().pad(5.0f).padLeft(0.0f).padRight(0.0f).height(3.0f).color(num == 5 ? Color.lime : (num == 6 ? Pal.accent : Color.orange));
        all.row();
        this.btns[num] = btn = (ImageButton)all.button((Drawable)new TextureRegionDrawable((TextureRegion)Core.atlas.find("subvoyage-atlacian-" + quality)), Styles.clearTogglei, () -> {
            Core.settings.put("subvoyage-planet-divisions", (Object)num);
            for (ImageButton bb : this.btns) {
                if (bb == null) continue;
                bb.setChecked(bb == this.btns[num]);
            }
            Vars.ui.loadfrag.show();
            Vars.ui.loadfrag.setProgress(0.0f);
            SvPlanets.atlacian.reloadMesh();
            Vars.ui.loadfrag.setProgress(0.33f);
            SvPlanets.atlacian.cloudMesh = (GenericMesh)SvPlanets.atlacian.cloudMeshLoader.get();
            Vars.ui.loadfrag.setProgress(0.66f);
            ((AtlacianPlanetType)SvPlanets.atlacian).atmMesh = (GenericMesh)((AtlacianPlanetType)SvPlanets.atlacian).atmosphereMesh.get();
            Vars.ui.loadfrag.setProgress(1.0f);
            Vars.ui.loadfrag.hide();
        }).width(width - 20.0f).height(width * 0.5f - 20.0f).padTop(3.0f).padBottom(3.0f).get();
        btn.center();
        btn.setChecked(Core.settings.getInt("subvoyage-planet-divisions") == num);
        btn.getImageCell().width(width - 20.0f).height(width * 0.5f - 20.0f).padBottom(8.0f).scaling(Scaling.fit);
        all.row();
    }

    public void showDialog() {
        this.rebuild();
        this.show(Core.scene);
    }

    public void addCloseButton(float width) {
        this.buttons.defaults().size(width, 64.0f);
        this.buttons.button("@back", (Drawable)Icon.left, () -> ((PlanetQualityDialog)this).hide()).size(width, 64.0f).align(2);
        this.addCloseListener();
    }
}

