/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.crafter;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.blocks.production.GenericCrafter;
import subvoyage.content.SvItems;

public class TugRoller
extends GenericCrafter {
    public float sinMag = 4.0f;
    public float sinScl = 10.0f;
    public float sideOffset = 0.0f;
    public float lenOffset = -1.0f;
    public float horiOffset = 0.0f;
    public float angleOffset = 0.0f;
    public TextureRegion region1;
    public TextureRegion region2;
    public TextureRegion bottom;
    public TextureRegion pistons;

    public TugRoller(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.bottom = Core.atlas.find(this.name + "-bottom");
        this.region1 = Core.atlas.find(this.name + "-piston0", this.name + "-piston");
        this.region2 = Core.atlas.find(this.name + "-piston1", this.name + "-piston");
        this.pistons = Core.atlas.find(this.name + "-pistons");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottom, this.pistons, this.region};
    }

    public class TugRollerBuild
    extends GenericCrafter.GenericCrafterBuild {
        Seq<ItemParticle> particles;
        float curLen1;
        float curLen2;

        public TugRollerBuild() {
            super((GenericCrafter)TugRoller.this);
            this.particles = new Seq();
            this.curLen1 = 0.0f;
            this.curLen2 = 0.0f;
        }

        public void created() {
            super.created();
            this.particles = new Seq();
            for (int i = 0; i <= 25; ++i) {
                this.particles.add((Object)new ItemParticle());
            }
        }

        public void updateTile() {
            super.updateTile();
            if (!Vars.headless) {
                int total = this.items.total();
                if (total <= this.particles.size) {
                    int[] index = new int[]{0};
                    this.items.each((item, a) -> {
                        for (int i = 0; i < a; ++i) {
                            ((ItemParticle)this.particles.get((int)index[0])).item = item;
                            index[0] = index[0] + 1;
                        }
                    });
                    for (int i = 0; i < this.particles.size; ++i) {
                        if (i <= total) continue;
                        ((ItemParticle)this.particles.get((int)i)).item = null;
                    }
                } else {
                    float ratio = (float)this.particles.size / (float)total;
                    int lratio = Mathf.floor((float)(1.0f / ratio));
                    float[] index = new float[]{0.0f};
                    this.items.each((item, a) -> {
                        for (int i = 0; i < a; i += lratio) {
                            ((ItemParticle)this.particles.get((int)Mathf.floor((float)index[0]))).item = item;
                            index[0] = index[0] + ratio * (float)lratio;
                            index[0] = Math.min(index[0], (float)(this.particles.size - 1));
                        }
                    });
                }
                for (int i = 0; i < this.particles.size; ++i) {
                    if (((ItemParticle)this.particles.get((int)i)).item != SvItems.sulfur && ((ItemParticle)this.particles.get((int)i)).item != SvItems.chrome) {
                        ((ItemParticle)this.particles.get((int)i)).item = null;
                    }
                    ((ItemParticle)this.particles.get((int)i)).aD = this.curLen1 / TugRoller.this.sinMag - TugRoller.this.lenOffset / TugRoller.this.sinMag;
                }
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)TugRoller.this.bottom, (float)this.x, (float)this.y);
            for (ItemParticle particle : this.particles) {
                particle.draw();
            }
            for (int i = 0; i < 2; ++i) {
                TextureRegion reg;
                float len = Mathf.absin((float)(this.progress * 90.0f + TugRoller.this.sideOffset * (float)i), (float)TugRoller.this.sinScl, (float)TugRoller.this.sinMag) + TugRoller.this.lenOffset;
                float thisLen = i == 0 ? (this.curLen1 = Mathf.lerp((float)this.curLen1, (float)len, (float)(Time.delta / 5.0f))) : (this.curLen2 = Mathf.lerp((float)this.curLen2, (float)len, (float)(Time.delta / 5.0f)));
                float angle = TugRoller.this.angleOffset + (float)i * 360.0f / 2.0f;
                TextureRegion textureRegion = reg = angle >= 135.0f && angle < 315.0f ? TugRoller.this.region2 : TugRoller.this.region1;
                if (Mathf.equal((float)angle, (float)315.0f)) {
                    Draw.yscl = -1.0f;
                }
                Tmp.v1.trns(angle, thisLen, -TugRoller.this.horiOffset);
                Draw.rect((TextureRegion)reg, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)angle);
                Draw.yscl = 1.0f;
            }
            TugRoller.this.drawer.draw((Building)this);
        }

        public class ItemParticle {
            float r = Mathf.random((float)((float)Math.PI * 2));
            float d = Mathf.lerp((float)0.0f, (float)4.0f, (float)Mathf.sqrt((float)Mathf.random()));
            float aD = 0.0f;
            Item item;

            void draw() {
                if (this.item != null) {
                    Draw.rect((TextureRegion)this.item.fullIcon, (float)(TugRollerBuild.this.x + Mathf.cos((float)this.r) * (this.aD * this.d)), (float)(TugRollerBuild.this.y + Mathf.sin((float)this.r) * this.d), (float)5.0f, (float)5.0f);
                }
            }
        }
    }
}

