/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.fog;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.Radar;

public class Buoy
extends Radar {
    public boolean isWater = true;

    public Buoy(String name) {
        super(name);
        this.swapDiagonalPlacement = true;
        this.allowDiagonal = true;
        this.outlineIcon = false;
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps((Circle)Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, this.lightRadius * 8.0f), (Rect)Tmp.r1.setSize((float)(this.size * 8)).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (!this.isWater) {
            return super.canPlaceOn(tile, team, rotation);
        }
        return tile.floor().isLiquid;
    }

    public class BuoyBuild
    extends Radar.RadarBuild {
        public BuoyBuild() {
            super((Radar)Buoy.this);
        }

        public void drawSelect() {
            super.drawSelect();
            if ((float)Buoy.this.fogRadius * this.progress < 6.0f) {
                Drawf.dashCircle((float)this.x, (float)this.y, (float)48.0f, (Color)Pal.accent);
            }
        }

        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.05f);
            if (Math.abs(this.fogRadius() - this.lastRadius) >= 0.5f) {
                Vars.fogControl.forceUpdate(this.team, (Building)this);
                this.lastRadius = this.fogRadius();
            }
            this.progress += this.edelta() / Buoy.this.discoveryTime * (float)((float)Buoy.this.fogRadius * this.progress < 6.0f ? 8 : 1);
            this.progress = Mathf.clamp((float)this.progress);
            this.totalProgress += this.efficiency * this.edelta();
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
        }
    }
}

